/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.misc.IOUtils;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.provider.KeyProtector;

abstract class JavaKeyStore
extends KeyStoreSpi {
    private static final int MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private final Hashtable<String, Object> entries = new Hashtable();

    JavaKeyStore() {
    }

    abstract String convertAlias(String var1);

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object object = this.entries.get(this.convertAlias(string));
        if (object == null || !(object instanceof KeyEntry)) {
            return null;
        }
        if (cArray == null) {
            throw new UnrecoverableKeyException("Password must not be null");
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        byte[] byArray = ((KeyEntry)object).protectedPrivKey;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
        }
        return keyProtector.recover(encryptedPrivateKeyInfo);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        Object object = this.entries.get(this.convertAlias(string));
        if (object != null && object instanceof KeyEntry) {
            if (((KeyEntry)object).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)object).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        Object object = this.entries.get(this.convertAlias(string));
        if (object != null) {
            if (object instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)object).cert;
            }
            if (((KeyEntry)object).chain == null) {
                return null;
            }
            return ((KeyEntry)object).chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        Object object = this.entries.get(this.convertAlias(string));
        if (object != null) {
            if (object instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)object).date.getTime());
            }
            return new Date(((KeyEntry)object).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyProtector keyProtector = null;
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("Cannot store non-PrivateKeys");
        }
        try {
            Hashtable<String, Object> hashtable = this.entries;
            synchronized (hashtable) {
                KeyEntry keyEntry = new KeyEntry();
                keyEntry.date = new Date();
                keyProtector = new KeyProtector(cArray);
                keyEntry.protectedPrivKey = keyProtector.protect(key);
                keyEntry.chain = certificateArray != null && certificateArray.length != 0 ? (Certificate[])certificateArray.clone() : null;
                this.entries.put(this.convertAlias(string), keyEntry);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
        finally {
            keyProtector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            try {
                new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo");
            }
            KeyEntry keyEntry = new KeyEntry();
            keyEntry.date = new Date();
            keyEntry.protectedPrivKey = (byte[])byArray.clone();
            keyEntry.chain = certificateArray != null && certificateArray.length != 0 ? (Certificate[])certificateArray.clone() : null;
            this.entries.put(this.convertAlias(string), keyEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object object = this.entries.get(this.convertAlias(string));
            if (object != null && object instanceof KeyEntry) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            this.entries.put(this.convertAlias(string), trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(this.convertAlias(string));
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(this.convertAlias(string));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        Object object = this.entries.get(this.convertAlias(string));
        return object != null && object instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        Object object = this.entries.get(this.convertAlias(string));
        return object != null && object instanceof TrustedCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration<String> enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = enumeration.nextElement();
            Object object = this.entries.get(string);
            if (object instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)object).cert;
            } else {
                if (((KeyEntry)object).chain == null) continue;
                certificate2 = ((KeyEntry)object).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            if (cArray == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest messageDigest = this.getPreKeyedHash(cArray);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
            dataOutputStream.writeInt(-17957139);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(this.entries.size());
            Object object = this.entries.keys();
            while (object.hasMoreElements()) {
                byte[] byArray;
                String string = object.nextElement();
                Object object2 = this.entries.get(string);
                if (object2 instanceof KeyEntry) {
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeLong(((KeyEntry)object2).date.getTime());
                    dataOutputStream.writeInt(((KeyEntry)object2).protectedPrivKey.length);
                    dataOutputStream.write(((KeyEntry)object2).protectedPrivKey);
                    int n = ((KeyEntry)object2).chain == null ? 0 : ((KeyEntry)object2).chain.length;
                    dataOutputStream.writeInt(n);
                    for (int i = 0; i < n; ++i) {
                        byArray = ((KeyEntry)object2).chain[i].getEncoded();
                        dataOutputStream.writeUTF(((KeyEntry)object2).chain[i].getType());
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                    }
                    continue;
                }
                dataOutputStream.writeInt(2);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeLong(((TrustedCertEntry)object2).date.getTime());
                byArray = ((TrustedCertEntry)object2).cert.getEncoded();
                dataOutputStream.writeUTF(((TrustedCertEntry)object2).cert.getType());
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
            object = messageDigest.digest();
            dataOutputStream.write((byte[])object);
            dataOutputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            DataInputStream dataInputStream;
            MessageDigest messageDigest = null;
            CertificateFactory certificateFactory = null;
            Hashtable<String, CertificateFactory> hashtable2 = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = null;
            if (inputStream == null) {
                return;
            }
            if (cArray != null) {
                messageDigest = this.getPreKeyedHash(cArray);
                dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
            } else {
                dataInputStream = new DataInputStream(inputStream);
            }
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n != -17957139 || n2 != 1 && n2 != 2) {
                throw new IOException("Invalid keystore format");
            }
            if (n2 == 1) {
                certificateFactory = CertificateFactory.getInstance("X509");
            } else {
                hashtable2 = new Hashtable<String, CertificateFactory>(3);
            }
            this.entries.clear();
            int n3 = dataInputStream.readInt();
            for (int i = 0; i < n3; ++i) {
                String string;
                int n4 = dataInputStream.readInt();
                if (n4 == 1) {
                    object = new KeyEntry();
                    string = dataInputStream.readUTF();
                    ((KeyEntry)object).date = new Date(dataInputStream.readLong());
                    ((KeyEntry)object).protectedPrivKey = IOUtils.readFully((InputStream)dataInputStream, (int)dataInputStream.readInt(), (boolean)true);
                    int n5 = dataInputStream.readInt();
                    if (n5 > 0) {
                        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n5 > 10 ? 10 : n5);
                        for (int j = 0; j < n5; ++j) {
                            if (n2 == 2) {
                                String string2 = dataInputStream.readUTF();
                                if (hashtable2.containsKey(string2)) {
                                    certificateFactory = (CertificateFactory)hashtable2.get(string2);
                                } else {
                                    certificateFactory = CertificateFactory.getInstance(string2);
                                    hashtable2.put(string2, certificateFactory);
                                }
                            }
                            byArray = IOUtils.readFully((InputStream)dataInputStream, (int)dataInputStream.readInt(), (boolean)true);
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            arrayList.add(certificateFactory.generateCertificate(byteArrayInputStream));
                            byteArrayInputStream.close();
                        }
                        ((KeyEntry)object).chain = arrayList.toArray(new Certificate[n5]);
                    }
                    this.entries.put(string, object);
                    continue;
                }
                if (n4 == 2) {
                    object = new TrustedCertEntry();
                    string = dataInputStream.readUTF();
                    ((TrustedCertEntry)object).date = new Date(dataInputStream.readLong());
                    if (n2 == 2) {
                        String string3 = dataInputStream.readUTF();
                        if (hashtable2.containsKey(string3)) {
                            certificateFactory = (CertificateFactory)hashtable2.get(string3);
                        } else {
                            certificateFactory = CertificateFactory.getInstance(string3);
                            hashtable2.put(string3, certificateFactory);
                        }
                    }
                    byArray = IOUtils.readFully((InputStream)dataInputStream, (int)dataInputStream.readInt(), (boolean)true);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ((TrustedCertEntry)object).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                    byteArrayInputStream.close();
                    this.entries.put(string, object);
                    continue;
                }
                throw new IOException("Unrecognized keystore entry");
            }
            if (cArray != null) {
                byte[] byArray2 = messageDigest.digest();
                byte[] byArray3 = new byte[byArray2.length];
                dataInputStream.readFully(byArray3);
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray3[i]) continue;
                    object = new UnrecoverableKeyException("Password verification failed");
                    throw (IOException)new IOException("Keystore was tampered with, or password was incorrect").initCause((Throwable)object);
                }
            }
        }
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
        }
        messageDigest.update(byArray);
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    public static final class CaseExactJKS
    extends JavaKeyStore {
        @Override
        String convertAlias(String string) {
            return string;
        }
    }

    public static final class JKS
    extends JavaKeyStore {
        @Override
        String convertAlias(String string) {
            return string.toLowerCase();
        }
    }

    private static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;

        private KeyEntry() {
        }
    }

    private static class TrustedCertEntry {
        Date date;
        Certificate cert;

        private TrustedCertEntry() {
        }
    }
}

