/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.rsa.PSSParameters;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KeyUtil;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    protected transient byte[] encodedParams;
    private static volatile Map<String, String> aliasOidsTable;
    public static final ObjectIdentifier MD2_oid;
    public static final ObjectIdentifier MD5_oid;
    public static final ObjectIdentifier SHA_oid;
    public static final ObjectIdentifier SHA224_oid;
    public static final ObjectIdentifier SHA256_oid;
    public static final ObjectIdentifier SHA384_oid;
    public static final ObjectIdentifier SHA512_oid;
    public static final ObjectIdentifier SHA512_224_oid;
    public static final ObjectIdentifier SHA512_256_oid;
    public static final ObjectIdentifier RSAEncryption_oid;
    public static final ObjectIdentifier RSASSA_PSS_oid;
    public static final ObjectIdentifier specifiedWithECDSA_oid;
    public static final ObjectIdentifier MGF1_oid;
    public static final ObjectIdentifier DSA_oid;
    public static final ObjectIdentifier EC_oid;

    @Deprecated
    public AlgorithmId() {
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier) {
        this.algid = objectIdentifier;
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, AlgorithmParameters algorithmParameters) {
        this.algid = objectIdentifier;
        this.algParams = algorithmParameters;
        if (this.algParams != null) {
            try {
                this.encodedParams = this.algParams.getEncoded();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.algid = objectIdentifier;
        if (derValue != null) {
            this.encodedParams = derValue.toByteArray();
            this.decodeParams();
        }
    }

    protected void decodeParams() throws IOException {
        String string = this.getName();
        if (string.equals("DSA") || string.equals("Diffie-Hellman")) {
            string = this.algid.toString();
        }
        try {
            this.algParams = AlgorithmParameters.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.algParams = null;
            return;
        }
        this.algParams.init((byte[])this.encodedParams.clone());
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.algid);
        if (this.algParams != null && this.encodedParams == null) {
            this.encodedParams = this.algParams.getEncoded();
        }
        if (this.encodedParams == null) {
            if (!this.algid.equals(RSASSA_PSS_oid)) {
                derOutputStream.putNull();
            }
        } else {
            derOutputStream.write(this.encodedParams);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public final byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.derEncode(derOutputStream);
        return derOutputStream.toByteArray();
    }

    public final ObjectIdentifier getOID() {
        return this.algid;
    }

    public String getName() {
        String string = this.algid.toString();
        KnownOIDs knownOIDs = KnownOIDs.findMatch(string);
        if (knownOIDs == KnownOIDs.SpecifiedSHA2withECDSA && this.encodedParams != null) {
            try {
                AlgorithmId algorithmId = AlgorithmId.parse(new DerValue(this.encodedParams));
                String string2 = algorithmId.getName();
                return string2.replace("-", "") + "withECDSA";
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (knownOIDs != null) {
            return knownOIDs.stdName();
        }
        String string3 = AlgorithmId.aliasOidsTable().get(string);
        if (string3 != null) {
            return string3;
        }
        return this.algid.toString();
    }

    public AlgorithmParameters getParameters() {
        return this.algParams;
    }

    public byte[] getEncodedParams() {
        return this.encodedParams == null || this.algid.equals(specifiedWithECDSA_oid) ? null : (byte[])this.encodedParams.clone();
    }

    public boolean equals(AlgorithmId algorithmId) {
        return this.algid.equals((Object)algorithmId.algid) && Arrays.equals(this.encodedParams, algorithmId.encodedParams);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AlgorithmId) {
            return this.equals((AlgorithmId)object);
        }
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier objectIdentifier) {
        return this.algid.equals((Object)objectIdentifier);
    }

    public int hashCode() {
        int n = this.algid.hashCode();
        n = 31 * n + Arrays.hashCode(this.encodedParams);
        return n;
    }

    protected String paramsToString() {
        if (this.encodedParams == null) {
            return "";
        }
        if (this.algParams != null) {
            return ", " + this.algParams.toString();
        }
        return ", params unparsed";
    }

    public String toString() {
        return this.getName() + this.paramsToString();
    }

    public static AlgorithmId parse(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (derValue.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            derValue2 = null;
        } else {
            derValue2 = derInputStream.getDerValue();
            if (derValue2.tag == 5) {
                if (derValue2.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                derValue2 = null;
            }
            if (derInputStream.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        return new AlgorithmId(objectIdentifier, derValue2);
    }

    @Deprecated
    public static AlgorithmId getAlgorithmId(String string) throws NoSuchAlgorithmException {
        return AlgorithmId.get(string);
    }

    public static AlgorithmId get(String string) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier;
        try {
            objectIdentifier = AlgorithmId.algOID(string);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException("Invalid ObjectIdentifier " + string);
        }
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier);
    }

    public static AlgorithmId get(AlgorithmParameters algorithmParameters) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier;
        String string = algorithmParameters.getAlgorithm();
        try {
            objectIdentifier = AlgorithmId.algOID(string);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException("Invalid ObjectIdentifier " + string);
        }
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier, algorithmParameters);
    }

    private static ObjectIdentifier algOID(String string) throws IOException {
        KnownOIDs knownOIDs;
        if (string.startsWith("OID.")) {
            string = string.substring("OID.".length());
        }
        if ((knownOIDs = KnownOIDs.findMatch(string)) != null) {
            return ObjectIdentifier.of(knownOIDs);
        }
        if (string.indexOf(".") == -1) {
            string = string.toUpperCase(Locale.ENGLISH);
            String string2 = AlgorithmId.aliasOidsTable().get(string);
            if (string2 != null) {
                return ObjectIdentifier.of(string2);
            }
            return null;
        }
        return ObjectIdentifier.of(string);
    }

    private static ObjectIdentifier oid(int ... nArray) {
        return ObjectIdentifier.newInternal(nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> aliasOidsTable() {
        Map<String, String> map = aliasOidsTable;
        if (map != null) return map;
        Class<AlgorithmId> clazz = AlgorithmId.class;
        synchronized (AlgorithmId.class) {
            map = aliasOidsTable;
            if (map != null) return map;
            aliasOidsTable = map = AlgorithmId.collectOIDAliases();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map;
        }
    }

    private static boolean isKnownProvider(Provider provider) {
        String string = provider.getName();
        String string2 = provider.getClass().getName();
        if (string != null && string2 != null) {
            return string2.equals("java.base") && (string.equals("SUN") || string.equals("SunRsaSign") || string.equals("SunJCE") || string.equals("SunJSSE")) || string2.equals("sun.security.ec") && string.equals("SunEC") || string2.equals("sun.security.mscapi") && string.equals("SunMSCAPI") || string2.equals("sun.security.pkcs11") && string.startsWith("SunPKCS11");
        }
        return false;
    }

    private static ConcurrentHashMap<String, String> collectOIDAliases() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        block0: for (Provider provider : Security.getProviders()) {
            if (AlgorithmId.isKnownProvider(provider)) continue;
            for (Object object : provider.keySet()) {
                int n;
                String string = (String)object;
                String string2 = string.toUpperCase(Locale.ENGLISH);
                if (!string2.startsWith("ALG.ALIAS") || (n = string2.indexOf("OID.", 0)) == -1) continue;
                if ((n += "OID.".length()) == string.length()) continue block0;
                String string3 = string.substring(n);
                String string4 = provider.getProperty(string);
                if (string4 != null) {
                    string4 = string4.toUpperCase(Locale.ENGLISH);
                }
                if (KnownOIDs.findMatch(string4) == null) {
                    concurrentHashMap.putIfAbsent(string4, string3);
                }
                if (KnownOIDs.findMatch(string3) != null) continue;
                concurrentHashMap.putIfAbsent(string3, string4);
            }
        }
        return concurrentHashMap;
    }

    public static String makeSigAlg(String string, String string2) {
        string = string.replace("-", "");
        if (string2.equalsIgnoreCase("EC")) {
            string2 = "ECDSA";
        }
        return string + "with" + string2;
    }

    public static String getEncAlgFromSigAlg(String string) {
        int n;
        string = string.toUpperCase(Locale.ENGLISH);
        int n2 = string.indexOf("WITH");
        String string2 = null;
        if (n2 > 0 && (string2 = (n = string.indexOf("AND", n2 + 4)) > 0 ? string.substring(n2 + 4, n) : string.substring(n2 + 4)).equalsIgnoreCase("ECDSA")) {
            string2 = "EC";
        }
        return string2;
    }

    public static String getDigAlgFromSigAlg(String string) {
        int n = (string = string.toUpperCase(Locale.ENGLISH)).indexOf("WITH");
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static void checkKeyAndSigAlgMatch(String string, String string2) {
        String string3 = string2.toUpperCase(Locale.US);
        if (string3.endsWith("WITHRSA") && !string.equalsIgnoreCase("RSA") || string3.endsWith("WITHECDSA") && !string.equalsIgnoreCase("EC") || string3.endsWith("WITHDSA") && !string.equalsIgnoreCase("DSA")) {
            throw new IllegalArgumentException("key algorithm not compatible with signature algorithm");
        }
    }

    public static String getDefaultSigAlgForKey(PrivateKey privateKey) {
        switch (privateKey.getAlgorithm().toUpperCase(Locale.ENGLISH)) {
            case "EC": {
                return AlgorithmId.ecStrength(KeyUtil.getKeySize(privateKey)) + "withECDSA";
            }
            case "DSA": {
                return AlgorithmId.ifcFfcStrength(KeyUtil.getKeySize(privateKey)) + "withDSA";
            }
            case "RSA": {
                return AlgorithmId.ifcFfcStrength(KeyUtil.getKeySize(privateKey)) + "withRSA";
            }
            case "RSASSA-PSS": {
                return "RSASSA-PSS";
            }
        }
        return null;
    }

    public static AlgorithmId getWithParameterSpec(String string, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException {
        if (algorithmParameterSpec == null) {
            return AlgorithmId.get(string);
        }
        if (algorithmParameterSpec == PSSParamsHolder.PSS_256_SPEC) {
            return PSSParamsHolder.PSS_256_ID;
        }
        if (algorithmParameterSpec == PSSParamsHolder.PSS_384_SPEC) {
            return PSSParamsHolder.PSS_384_ID;
        }
        if (algorithmParameterSpec == PSSParamsHolder.PSS_512_SPEC) {
            return PSSParamsHolder.PSS_512_ID;
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(algorithmParameterSpec);
            return AlgorithmId.get(algorithmParameters);
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    public static PSSParameterSpec getDefaultAlgorithmParameterSpec(String string, PrivateKey privateKey) {
        if (string.equalsIgnoreCase("RSASSA-PSS")) {
            switch (AlgorithmId.ifcFfcStrength(KeyUtil.getKeySize(privateKey))) {
                case "SHA256": {
                    return PSSParamsHolder.PSS_256_SPEC;
                }
                case "SHA384": {
                    return PSSParamsHolder.PSS_384_SPEC;
                }
                case "SHA512": {
                    return PSSParamsHolder.PSS_512_SPEC;
                }
            }
            throw new AssertionError((Object)"Should not happen");
        }
        return null;
    }

    private static String ecStrength(int n) {
        if (n >= 512) {
            return "SHA512";
        }
        if (n >= 384) {
            return "SHA384";
        }
        return "SHA256";
    }

    private static String ifcFfcStrength(int n) {
        if (n > 7680) {
            return "SHA512";
        }
        if (n > 3072) {
            return "SHA384";
        }
        return "SHA256";
    }

    static {
        MD2_oid = ObjectIdentifier.of(KnownOIDs.MD2);
        MD5_oid = ObjectIdentifier.of(KnownOIDs.MD5);
        SHA_oid = ObjectIdentifier.of(KnownOIDs.SHA_1);
        SHA224_oid = ObjectIdentifier.of(KnownOIDs.SHA_224);
        SHA256_oid = ObjectIdentifier.of(KnownOIDs.SHA_256);
        SHA384_oid = ObjectIdentifier.of(KnownOIDs.SHA_384);
        SHA512_oid = ObjectIdentifier.of(KnownOIDs.SHA_512);
        SHA512_224_oid = ObjectIdentifier.of(KnownOIDs.SHA_512$224);
        SHA512_256_oid = ObjectIdentifier.of(KnownOIDs.SHA_512$256);
        RSAEncryption_oid = ObjectIdentifier.of(KnownOIDs.RSA);
        RSASSA_PSS_oid = ObjectIdentifier.of(KnownOIDs.RSASSA_PSS);
        specifiedWithECDSA_oid = ObjectIdentifier.of(KnownOIDs.SpecifiedSHA2withECDSA);
        MGF1_oid = ObjectIdentifier.of(KnownOIDs.MGF1);
        DSA_oid = ObjectIdentifier.of(KnownOIDs.DSA);
        EC_oid = ObjectIdentifier.of(KnownOIDs.EC);
    }

    private static class PSSParamsHolder {
        static final PSSParameterSpec PSS_256_SPEC = new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1);
        static final PSSParameterSpec PSS_384_SPEC = new PSSParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec("SHA-384"), 48, 1);
        static final PSSParameterSpec PSS_512_SPEC = new PSSParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), 64, 1);
        static final AlgorithmId PSS_256_ID;
        static final AlgorithmId PSS_384_ID;
        static final AlgorithmId PSS_512_ID;

        private PSSParamsHolder() {
        }

        static {
            try {
                PSS_256_ID = new AlgorithmId(RSASSA_PSS_oid, new DerValue(PSSParameters.getEncoded(PSS_256_SPEC)));
                PSS_384_ID = new AlgorithmId(RSASSA_PSS_oid, new DerValue(PSSParameters.getEncoded(PSS_384_SPEC)));
                PSS_512_ID = new AlgorithmId(RSASSA_PSS_oid, new DerValue(PSSParameters.getEncoded(PSS_512_SPEC)));
            }
            catch (IOException iOException) {
                throw new AssertionError("Should not happen", iOException);
            }
        }
    }
}

