/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.Action;

public class CompositeAction
extends AbstractAction {
    private final Action[] actions;
    private final boolean stopOnError;

    public CompositeAction(List<Action> actions2, boolean stopOnError) {
        this.actions = new Action[actions2.size()];
        actions2.toArray(this.actions);
        this.stopOnError = stopOnError;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IOException ex) {
            LOGGER.warn("Exception during file rollover.", (Throwable)ex);
        }
    }

    @Override
    public boolean execute() throws IOException {
        if (this.stopOnError) {
            Action[] actionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                if (!action.execute()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        boolean status = true;
        IOException exception = null;
        Action[] actionArray = this.actions;
        int n = this.actions.length;
        int n3 = 0;
        while (n3 < n) {
            block7: {
                Action action = actionArray[n3];
                try {
                    status &= action.execute();
                }
                catch (IOException ex) {
                    status = false;
                    if (exception != null) break block7;
                    exception = ex;
                }
            }
            ++n3;
        }
        if (exception != null) {
            throw exception;
        }
        return status;
    }

    public String toString() {
        return String.valueOf(CompositeAction.class.getSimpleName()) + Arrays.toString(this.actions);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }
}

