/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Code
extends Attribute {
    private int max_stack;
    private int max_locals;
    private byte[] code;
    private CodeException[] exception_table;
    private Attribute[] attributes;

    public Code(Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(int name_index, int length, DataInput file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        int code_length = file.readInt();
        this.code = new byte[code_length];
        file.readFully(this.code);
        int exception_table_length = file.readUnsignedShort();
        this.exception_table = new CodeException[exception_table_length];
        int i = 0;
        while (i < exception_table_length) {
            this.exception_table[i] = new CodeException(file);
            ++i;
        }
        int attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        int i2 = 0;
        while (i2 < attributes_count) {
            this.attributes[i2] = Attribute.readAttribute(file, constant_pool);
            ++i2;
        }
        super.setLength(length);
    }

    public Code(int name_index, int length, int max_stack, int max_locals, byte[] code, CodeException[] exception_table, Attribute[] attributes, ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.code = code != null ? code : new byte[]{};
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(Visitor v) {
        v.visitCode(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.max_stack);
        file.writeShort(this.max_locals);
        file.writeInt(this.code.length);
        file.write(this.code, 0, this.code.length);
        file.writeShort(this.exception_table.length);
        Node[] nodeArray = this.exception_table;
        int n = this.exception_table.length;
        int n2 = 0;
        while (n2 < n) {
            CodeException exception = nodeArray[n2];
            exception.dump(file);
            ++n2;
        }
        file.writeShort(this.attributes.length);
        nodeArray = this.attributes;
        n = this.attributes.length;
        n2 = 0;
        while (n2 < n) {
            Node attribute = nodeArray[n2];
            ((Attribute)attribute).dump(file);
            ++n2;
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof LineNumberTable) {
                return (LineNumberTable)attribute;
            }
            ++n2;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof LocalVariableTable) {
                return (LocalVariableTable)attribute;
            }
            ++n2;
        }
        return null;
    }

    public byte[] getCode() {
        return this.code;
    }

    public CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    private int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exception_table == null ? 0 : this.exception_table.length) + 2;
    }

    private int calculateLength() {
        int len = 0;
        if (this.attributes != null) {
            Attribute[] attributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                len += attribute.getLength() + 6;
                ++n2;
            }
        }
        return len + this.getInternalLength();
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    public void setCode(byte[] code) {
        this.code = code != null ? code : new byte[]{};
        super.setLength(this.calculateLength());
    }

    public void setExceptionTable(CodeException[] exception_table) {
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        super.setLength(this.calculateLength());
    }

    public void setMaxLocals(int max_locals) {
        this.max_locals = max_locals;
    }

    public void setMaxStack(int max_stack) {
        this.max_stack = max_stack;
    }

    public String toString(boolean verbose) {
        int n;
        int n2;
        Node[] nodeArray;
        StringBuilder buf = new StringBuilder(100);
        buf.append("Code(max_stack = ").append(this.max_stack).append(", max_locals = ").append(this.max_locals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, verbose));
        if (this.exception_table.length > 0) {
            buf.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            nodeArray = this.exception_table;
            n2 = this.exception_table.length;
            n = 0;
            while (n < n2) {
                Node exception = nodeArray[n];
                buf.append(((CodeException)exception).toString(super.getConstantPool(), verbose)).append("\n");
                ++n;
            }
        }
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s) = ");
            nodeArray = this.attributes;
            n2 = this.attributes.length;
            n = 0;
            while (n < n2) {
                Node attribute = nodeArray[n];
                buf.append("\n").append(attribute);
                ++n;
            }
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        Code c = (Code)this.clone();
        if (this.code != null) {
            c.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, c.code, 0, this.code.length);
        }
        c.setConstantPool(_constant_pool);
        c.exception_table = new CodeException[this.exception_table.length];
        int i = 0;
        while (i < this.exception_table.length) {
            c.exception_table[i] = this.exception_table[i].copy();
            ++i;
        }
        c.attributes = new Attribute[this.attributes.length];
        i = 0;
        while (i < this.attributes.length) {
            c.attributes[i] = this.attributes[i].copy(_constant_pool);
            ++i;
        }
        return c;
    }
}

