/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.barcode;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.doc.util.DcfDocumentUtil;
import nlc.lib.barcode.DcfAbstractBarcodeContext;
import nlc.lib.barcode.DcfBarcodeRenderer;
import nlc.lib.barcode.DcfBarcodeUtil;

public class DcfJan
extends DcfAbstractBarcodeContext
implements DcfBarcodeRenderer {
    public static final int LEFT_ODD = 1;
    public static final int LEFT_EVEN = 2;
    public static final double NAROW_BAR_WIDTH = 0.33;
    public static final double NAROW_BAR_HEIGHT = 22.86;
    public static final double GARD_BAR_HEIGHT = 26.0;

    protected String getPattern(char char_, int parityMode) throws Exception {
        String pattern = null;
        switch (char_) {
            case '0': {
                pattern = "3211";
                break;
            }
            case '1': {
                pattern = "2221";
                break;
            }
            case '2': {
                pattern = "2122";
                break;
            }
            case '3': {
                pattern = "1411";
                break;
            }
            case '4': {
                pattern = "1132";
                break;
            }
            case '5': {
                pattern = "1231";
                break;
            }
            case '6': {
                pattern = "1114";
                break;
            }
            case '7': {
                pattern = "1312";
                break;
            }
            case '8': {
                pattern = "1213";
                break;
            }
            case '9': {
                pattern = "3112";
                break;
            }
            default: {
                throw new Exception("char=" + char_);
            }
        }
        if (parityMode == 2) {
            StringBuilder sb = new StringBuilder(pattern);
            sb.reverse();
            pattern = sb.toString();
        }
        return pattern;
    }

    protected String getParityCode(char char_) throws Exception {
        String resStr = null;
        switch (char_) {
            case '0': {
                resStr = "OOOOOO";
                break;
            }
            case '1': {
                resStr = "OOEOEE";
                break;
            }
            case '2': {
                resStr = "OOEEOE";
                break;
            }
            case '3': {
                resStr = "OOEEEO";
                break;
            }
            case '4': {
                resStr = "OEOOEE";
                break;
            }
            case '5': {
                resStr = "OEEOOE";
                break;
            }
            case '6': {
                resStr = "OEEEOO";
                break;
            }
            case '7': {
                resStr = "OEOEOE";
                break;
            }
            case '8': {
                resStr = "OEOEEO";
                break;
            }
            case '9': {
                resStr = "OEEOEO";
                break;
            }
            default: {
                throw new Exception("char_=" + char_);
            }
        }
        return resStr;
    }

    @Override
    public double[] getSize(String value) throws Exception {
        return null;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String value) throws Exception {
        int j;
        String pattern;
        int num = 0;
        try {
            num = Integer.parseInt(value);
            value = BcStringUtil.fillPrefix(num, 12, '0');
        }
        catch (Exception ex) {
            throw new Exception("JAN \u306e\u5024\u306b '" + value + "' \u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        String leftCode = null;
        String rightCode = null;
        String parityMode = null;
        switch (value.length()) {
            case 12: {
                parityMode = this.getParityCode(value.charAt(0));
                leftCode = value.substring(1, 7);
                rightCode = String.valueOf(value.substring(7, 12)) + Integer.toString(DcfBarcodeUtil.calcMod10_3(value));
                break;
            }
            case 7: {
                parityMode = this.getParityCode(value.charAt(0));
                leftCode = value.substring(1, 5);
                rightCode = String.valueOf(value.substring(5, 7)) + Integer.toString(DcfBarcodeUtil.calcMod10_3(value));
                break;
            }
            default: {
                throw new Exception("\u6841\u6570\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002 value=" + value);
            }
        }
        char char_ = '\u0000';
        int widthCnt = 0;
        double tX = bx;
        boolean isBlack = false;
        double narowBarWidth = DcfDocumentUtil.mmToPixel_deprecated1(0.33);
        double narowBarHeight = DcfDocumentUtil.mmToPixel_deprecated1(22.86) / 1.8;
        double gardBarHeight = DcfDocumentUtil.mmToPixel_deprecated1(26.0) / 1.8;
        Font font = new Font("Dialog", 0, 32);
        double strGap1 = 10.0;
        double strGap2 = 34.0;
        g2d.setFont(font);
        g2d.setColor(Color.black);
        g2d.drawString(value.substring(0, 1), (float)tX, (float)(by + narowBarHeight + strGap2));
        Rectangle2D.Double rectangle = new Rectangle2D.Double(tX += narowBarWidth * 6.0, by, narowBarWidth * 1.0, gardBarHeight);
        g2d.fill(rectangle);
        tX += narowBarWidth * 1.0;
        rectangle = new Rectangle2D.Double(tX += narowBarWidth * 1.0, by, narowBarWidth * 1.0, gardBarHeight);
        g2d.fill(rectangle);
        tX += narowBarWidth * 1.0;
        int i = 0;
        while (i < leftCode.length()) {
            g2d.drawString(leftCode.substring(i, i + 1), (float)(tX + strGap1), (float)(by + narowBarHeight + strGap2));
            char_ = leftCode.charAt(i);
            pattern = null;
            pattern = parityMode.substring(i, i + 1).equals("E") ? this.getPattern(char_, 2) : this.getPattern(char_, 1);
            isBlack = true;
            j = 0;
            while (j < pattern.length()) {
                widthCnt = Integer.parseInt(pattern.substring(j, j + 1));
                boolean bl = isBlack = !isBlack;
                if (isBlack) {
                    rectangle = new Rectangle2D.Double(tX, by, narowBarWidth * (double)widthCnt, narowBarHeight);
                    g2d.fill(rectangle);
                }
                tX += narowBarWidth * (double)widthCnt;
                ++j;
            }
            ++i;
        }
        rectangle = new Rectangle2D.Double(tX += narowBarWidth * 1.0, by, narowBarWidth * 1.0, gardBarHeight);
        g2d.fill(rectangle);
        tX += narowBarWidth * 1.0;
        rectangle = new Rectangle2D.Double(tX += narowBarWidth * 1.0, by, narowBarWidth * 1.0, gardBarHeight);
        g2d.fill(rectangle);
        tX += narowBarWidth * 1.0;
        tX += narowBarWidth * 1.0;
        i = 0;
        while (i < rightCode.length()) {
            g2d.drawString(rightCode.substring(i, i + 1), (float)(tX + strGap1), (float)(by + narowBarHeight + strGap2));
            char_ = rightCode.charAt(i);
            pattern = this.getPattern(char_, 1);
            isBlack = false;
            j = 0;
            while (j < pattern.length()) {
                widthCnt = Integer.parseInt(pattern.substring(j, j + 1));
                boolean bl = isBlack = !isBlack;
                if (isBlack) {
                    rectangle = new Rectangle2D.Double(tX, by, narowBarWidth * (double)widthCnt, narowBarHeight);
                    g2d.fill(rectangle);
                }
                tX += narowBarWidth * (double)widthCnt;
                ++j;
            }
            ++i;
        }
        rectangle = new Rectangle2D.Double(tX, by, narowBarWidth * 1.0, gardBarHeight);
        g2d.fill(rectangle);
        tX += narowBarWidth * 1.0;
        rectangle = new Rectangle2D.Double(tX += narowBarWidth * 1.0, by, narowBarWidth * 1.0, gardBarHeight);
        g2d.fill(rectangle);
    }
}

