/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.servlet;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.wbfw.common.WbfwConstants;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.web.server.WbsContainer;
import jp.co.extreme.web.server.WbsResourceHolder;
import jp.co.extreme.web.session.WbsHttpSession;
import jp.co.extreme.web.session.WbsSessionManager;

public class WbsHttpServletRequest
extends HttpServletRequestWrapper {
    private WbsHttpSession httpSession;

    public WbsHttpServletRequest(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean create) {
        String sessionId;
        if (this.httpSession != null) {
            return this.httpSession;
        }
        WbsContainer webContainer = WbsResourceHolder.getInstance().webContainer;
        WbsSessionManager sessionManager = webContainer.getHttpSessionManager();
        Cookie cookie = WbfwUtil.getCookie((HttpServletRequest)this, WbfwConstants.CookieName.sessionId.name());
        if (cookie != null && !BcStringUtil.isEmpty(sessionId = cookie.getValue())) {
            this.httpSession = sessionManager.getSession(sessionId);
        }
        if (!create) {
            return this.httpSession;
        }
        WbsHttpServletRequest wbsHttpServletRequest = this;
        synchronized (wbsHttpServletRequest) {
            if (this.httpSession != null) {
                return this.httpSession;
            }
            if (this.httpSession == null) {
                try {
                    BcLogUtil.debug("sessionManager=" + sessionManager);
                    BcLogUtil.debug("webContainer.getSiteContextDefault()=" + webContainer.getSiteContextDefault());
                    this.httpSession = sessionManager.createSession(this.getServletContext(), webContainer.getSiteContextDefault().sessionTimeout);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return this.httpSession;
    }
}

