/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.server;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.net.BcURI;
import jp.co.extreme.base.util.BcConditionElement;
import jp.co.extreme.rmi.common.RmiMethodContext;
import jp.co.extreme.web.server.WbsArgument;

public class WbsSiteContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4059209188109484119L;
    public int siteId;
    public int dataSourceId;
    public List<File> resourceDirList = new ArrayList<File>();
    public Properties smptProperties;
    public String mailSenderUserName;
    public String mailSenderPassword;
    public String mailSenderAddress;
    public String mailSenderPersonal;
    public String mailDestination;
    public String mailSubjectPrefix;
    public String theme;
    public String siteName;
    public String catchphrase;
    public String copyright;
    public String homePath;
    public Map<String, String> propertyMap = new HashMap<String, String>();
    public int sessionTimeout;
    public int sessionValidationInterval = 60;
    public List<BcConditionElement> aliasList = new ArrayList<BcConditionElement>();
    public Map<String, String> aliasMap = new HashMap<String, String>();
    public String urlBase;
    private File siteDir;
    private File dtsDir;
    public Map<String, RmiMethodContext> servletPathMap = new HashMap<String, RmiMethodContext>();
    public static final int CONFIRM = 11;
    public static final int WARNING = 21;
    public static final int ERROR = 31;

    public void addAlias(BcConditionElement alias) {
        this.aliasList.add(alias);
        this.aliasMap.put(alias.name, alias.value);
    }

    public String getUrlBase(HttpServletRequest httpReq) throws Exception {
        ServletContext servletContext;
        if (!BcStringUtil.isEmpty(this.urlBase)) {
            return this.urlBase;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(httpReq.getScheme()) + "://" + httpReq.getServerName());
        if (httpReq.getServerPort() != 80) {
            sb.append(":");
            sb.append(httpReq.getServerPort());
        }
        if (!BcStringUtil.isEmpty((servletContext = httpReq.getServletContext()).getContextPath())) {
            sb.append(servletContext.getContextPath());
            sb.append("/");
        }
        this.urlBase = sb.toString();
        return this.urlBase;
    }

    public String toRealPath(WbsArgument wcbArg, String vPath) throws Exception {
        File file = new File(vPath);
        if (file.isAbsolute()) {
            return file.getPath();
        }
        HttpServletRequest httpReq = wcbArg.getRequest();
        String contextPathAfter = null;
        String elem1 = null;
        String elem1After = null;
        if (BcStringUtil.isEmpty(vPath)) {
            contextPathAfter = BcStringUtil.replace((CharSequence)httpReq.getRequestURI(), httpReq.getContextPath(), "").toString();
        } else {
            BcURI uri = BcNetUtil.parseUri(vPath);
            contextPathAfter = httpReq.getContextPath().equals("/") ? uri.path : uri.path.substring(httpReq.getContextPath().length());
            String tmpStr = httpReq.getContextPath();
            tmpStr = BcFileUtil.deleteTopSlash(tmpStr);
            contextPathAfter = BcStringUtil.replace((CharSequence)contextPathAfter, tmpStr, "").toString();
            if (!BcStringUtil.isEmpty(contextPathAfter = BcFileUtil.deleteTopSlash(contextPathAfter))) {
                int tmpIdx = contextPathAfter.indexOf("/");
                if (tmpIdx >= 0) {
                    elem1 = contextPathAfter.substring(0, tmpIdx);
                    elem1After = contextPathAfter.substring(tmpIdx + 1);
                } else {
                    elem1 = contextPathAfter;
                }
            }
        }
        String realPath = null;
        String aliasValue = this.aliasMap.get(elem1);
        if (!BcStringUtil.isEmpty(aliasValue)) {
            realPath = BcStringUtil.replace((CharSequence)(String.valueOf(aliasValue) + "/" + elem1After), "\\", "/").toString();
        }
        return realPath;
    }

    public String createSessionQuery(WbsArgument wcbArg) throws Exception {
        if (BcStringUtil.isEmpty(wcbArg.getRequest().getRequestedSessionId())) {
            return "";
        }
        return "sid=" + wcbArg.getRequest().getRequestedSessionId();
    }

    public File getSiteDir() throws Exception {
        if (this.siteDir == null) {
            AfbApplication application = AfbApplication.getInstance();
            String dataDirStr = application.toReal("${APP}data/");
            String code = "site_" + BcStringUtil.fillPrefix(this.siteId, 8);
            this.siteDir = new File(dataDirStr, code);
        }
        return this.siteDir;
    }

    public String getDataSourceName() throws Exception {
        String dataSourceName = "main";
        return dataSourceName;
    }
}

