/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.task;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.task.TskCallableUnit;
import jp.co.extreme.task.TskTaskEvent;
import jp.co.extreme.task.TskTaskMonitor;

public class TskTaskManager
extends BcLoggableObject
implements BcEventHandler<TskTaskEvent> {
    private static Map<String, TskCallableUnit> callableUnitMap = new ConcurrentHashMap<String, TskCallableUnit>();
    private TskTaskMonitor taskMonitor;

    private TskTaskManager() {
    }

    public static TskTaskManager getInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, TskCallableUnit> getMap() {
        return callableUnitMap;
    }

    public void addCallableUnit(TskCallableUnit callableUnit) throws Exception {
        callableUnitMap.put(callableUnit.getId(), callableUnit);
        callableUnit.callable.addEventHandler(TskTaskManager.getInstance());
        if (this.taskMonitor != null) {
            this.taskMonitor.addCallableUnit(callableUnit);
        }
        if (callableUnit.future == null) {
            callableUnit.future = callableUnit.executorService.submit(callableUnit.callable);
            callableUnit.executorService.shutdown();
        }
    }

    @Override
    public void handle(TskTaskEvent event) throws Exception {
        TskAbstractCallable callable;
        TskCallableUnit callableUnit;
        if (event.getEventType() == TskTaskEvent.EventType.Finished && (callableUnit = callableUnitMap.remove(Integer.toString((callable = (TskAbstractCallable)event.getSource()).hashCode()))) != null) {
            this.getLogger().debug("Finished:callableUnit.id=" + callableUnit.getId());
            callableUnit.callable.removeEventHandler(TskTaskManager.getInstance());
        }
    }

    public TskTaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public void setTaskMonitor(TskTaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    /* synthetic */ TskTaskManager(TskTaskManager tskTaskManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final TskTaskManager instance = new TskTaskManager(null);

        private SingletonHolder() {
        }
    }
}

