/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing.sounds;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class SwgJarDataSource
extends PullDataSource {
    protected JarURLConnection jarURLConnection;
    protected ContentDescriptor contentDescriptor;
    protected JarPullSourceStream[] jarPullSourceStreams;
    protected boolean connected;

    public SwgJarDataSource(URL url) throws IOException {
        this.setLocator(new MediaLocator(url));
        this.connected = false;
    }

    public PullSourceStream[] getStreams() {
        return this.jarPullSourceStreams;
    }

    public void connect() throws IOException {
        this.jarURLConnection = (JarURLConnection)this.getLocator().getURL().openConnection();
        this.jarURLConnection.connect();
        this.connected = true;
        JarFile jf = this.jarURLConnection.getJarFile();
        JarEntry je = jf.getJarEntry(this.jarURLConnection.getEntryName());
        String mimeType = this.jarURLConnection.getContentType();
        if (mimeType == null) {
            mimeType = "UnknownContent";
        }
        this.contentDescriptor = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName((String)mimeType));
        this.jarPullSourceStreams = new JarPullSourceStream[1];
        this.jarPullSourceStreams[0] = new JarPullSourceStream(jf, je, this.contentDescriptor);
    }

    public String getContentType() {
        return this.contentDescriptor.getContentType();
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.jarPullSourceStreams[0].close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.connected = false;
        }
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlName) {
        return null;
    }

    protected class JarPullSourceStream
    implements PullSourceStream,
    Seekable,
    Closeable {
        protected final JarFile jarFile;
        protected final JarEntry jarEntry;
        protected final ContentDescriptor type;
        protected InputStream stream;
        protected long position;

        public JarPullSourceStream(JarFile jarFile, JarEntry jarEntry, ContentDescriptor type) throws IOException {
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
            this.type = type;
            this.stream = jarFile.getInputStream(jarEntry);
        }

        public ContentDescriptor getContentDescriptor() {
            return this.type;
        }

        public long getContentLength() {
            return this.jarEntry.getSize();
        }

        public boolean endOfStream() {
            return this.position < this.getContentLength();
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String controlType) {
            return null;
        }

        public boolean willReadBlock() {
            if (this.endOfStream()) {
                return true;
            }
            try {
                return this.stream.available() == 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            int read = this.stream.read(buffer, offset, length);
            this.position += (long)read;
            return read;
        }

        public long seek(long where) {
            try {
                if (where < this.position) {
                    this.stream.close();
                    this.stream = this.jarFile.getInputStream(this.jarEntry);
                    this.position = 0L;
                }
                long skip = where - this.position;
                while (skip > 0L) {
                    long skipped = this.stream.skip(skip);
                    skip -= skipped;
                    this.position += skipped;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return this.position;
        }

        public long tell() {
            return this.position;
        }

        public boolean isRandomAccess() {
            return true;
        }

        @Override
        public void close() throws IOException {
            try {
                this.stream.close();
            }
            finally {
                this.jarFile.close();
            }
        }
    }
}

