/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf4.model.ScfPropertyElement;
import jp.co.extreme.sql.context.SqlContext;

public class ScfAbstractPropertyDAO
extends OrmAbstractDAO<ScfPropertyElement> {
    protected String column_key = "key_";
    protected String column_index = "index_";
    protected String column_value = "value_";

    public ScfAbstractPropertyDAO() {
        super(new ScfPropertyElement[0]);
    }

    public void putPropertyElement(DtsSession dtsSession, ScfPropertyElement propertyElement) throws Exception {
        this.getPersistenceProxy().putEntitys_3(dtsSession, this.getTableName(), propertyElement);
    }

    public void putPropertyElement(DtsSession dtsSession, String key, int index, CharSequence value) throws Exception {
        ScfPropertyElement propertyElement = new ScfPropertyElement();
        propertyElement.key = key;
        propertyElement.index = index;
        propertyElement.value = BcStringUtil.toString(value);
        this.putPropertyElement(dtsSession, propertyElement);
    }

    public void putPropertyElement(DtsSession dtsSession, String key, String value) throws Exception {
        this.putPropertyElement(dtsSession, key, 1, value);
    }

    public ScfPropertyElement getPropertyElement(DtsSession dtsSession, String key, int index) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getViewName() + " WHERE " + this.column_key + sqlContext.toCondition_string("=", key) + " AND " + this.column_index + "=" + index;
        return (ScfPropertyElement)this.getEntity(dtsSession, query);
    }

    public String getValue(DtsSession dtsSession, String key, int index) throws Exception {
        ScfPropertyElement propertyElement = this.getPropertyElement(dtsSession, key, index);
        if (propertyElement != null) {
            return propertyElement.value;
        }
        return null;
    }

    public String getValue(DtsSession dtsSession, String key) throws Exception {
        return this.getValue(dtsSession, key, 1);
    }

    public List<ScfPropertyElement> getPropertyElementList(DtsSession dtsSession) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getViewName() + " ORDER BY " + this.column_key + ", " + this.column_index;
        return this.getEntityList(dtsSession, query);
    }
}

