/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.server;

import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;

public class ScfServerLogger
implements BcLogger {
    private String handleId;
    private Map<Socket, ObjectOutputStream> socketMap = new HashMap<Socket, ObjectOutputStream>();
    private BcLogConstants.LogLevel logLevel = BcLogConstants.LogLevel.INFO;
    private BcLogger bindLogger;

    public String getHandleId() {
        return this.handleId;
    }

    public ScfServerLogger(String handleId) throws Exception {
        this.handleId = handleId;
    }

    public void addSocket(Socket socket) throws Exception {
        BcLogUtil.debug("ScfServerLogger.addSocket:socket.getInetAddress()=" + socket.getInetAddress());
        ObjectOutputStream objos = new ObjectOutputStream(socket.getOutputStream());
        objos.flush();
        this.socketMap.put(socket, objos);
    }

    public boolean removeSocket(Socket socket) throws Exception {
        BcLogUtil.debug("removeSocket:" + socket.hashCode());
        return this.socketMap.remove(socket) != null;
    }

    protected void sendData(int command, byte[] dataBytes) throws Exception {
        Set<Map.Entry<Socket, ObjectOutputStream>> entrySet = this.socketMap.entrySet();
        for (Map.Entry<Socket, ObjectOutputStream> mapEntry : entrySet) {
            Socket socket = mapEntry.getKey();
            ObjectOutputStream objos = mapEntry.getValue();
            try {
                this.sendData(socket, objos, command, dataBytes);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    protected void sendData(Socket socket, ObjectOutputStream objos, int command, byte[] dataBytes) throws Exception {
        objos.flush();
        if (socket.isClosed()) {
            return;
        }
        try {
            objos.writeObject(command);
            objos.flush();
            objos.reset();
            objos.writeObject(dataBytes);
            objos.flush();
            objos.reset();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            this.removeSocket(socket);
        }
    }

    protected void sendData(int command, Object data) {
        try {
            byte[] dataBytes = ScfServerLogger.toByteArray(data);
            this.sendData(command, dataBytes);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public void sendData(BcLogConstants.LogLevel logLevelWk, Object log) {
        if (logLevelWk.id <= this.logLevel.id) {
            this.sendData(logLevelWk.id, (Object)BcLogUtil.convertMessage(log));
        }
    }

    public static byte[] toByteArray(Object data) throws Exception {
        byte[] bytes = null;
        bytes = data != null ? data.toString().getBytes(BcConstants.charset) : new byte[]{};
        return bytes;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void setLogLevel(BcLogConstants.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public BcLogConstants.LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void fatal(Object log) {
        BcLogUtil.fatal(log);
        this.sendData(BcLogConstants.LogLevel.FATAL, log);
    }

    @Override
    public void error(Object log) {
        BcLogUtil.error(log);
        this.sendData(BcLogConstants.LogLevel.ERROR, log);
    }

    @Override
    public void warning(Object log) {
        BcLogUtil.warning(log);
        this.sendData(BcLogConstants.LogLevel.WARN, log);
    }

    @Override
    public void info(Object log) {
        BcLogUtil.info(log);
        this.sendData(BcLogConstants.LogLevel.INFO, log);
    }

    @Override
    public void debug(Object log) {
        BcLogUtil.debug(log);
        this.sendData(BcLogConstants.LogLevel.DEBUG, log);
    }

    @Override
    public void trace(Object log) {
        BcLogUtil.trace(log);
        this.sendData(BcLogConstants.LogLevel.TRACE, log);
    }

    @Override
    public void bind(BcLogger bindLogger) {
        this.bindLogger = bindLogger;
    }

    public void destruct() throws Exception {
        Set<Map.Entry<Socket, ObjectOutputStream>> entrySet = this.socketMap.entrySet();
        for (Map.Entry<Socket, ObjectOutputStream> mapEntry : entrySet) {
            Socket socket = mapEntry.getKey();
            try {
                socket.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        this.socketMap.clear();
        this.socketMap = null;
    }
}

