/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.pdf;

import java.awt.Color;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.math.BcMath;
import jp.co.extreme.doc.util.DcfConstants;
import jp.co.extreme.doc.util.DcfDocumentUtil;
import jp.co.extreme.doc.util.DcfPageReader;
import jp.co.extreme.pdf.PdfOutlineTree;
import jp.co.extreme.pdf.PdfProducer;
import jp.co.extreme.pdf.font.PdfMincyo;
import jp.co.extreme.pdf.font.PdfMincyoBold;
import jp.co.extreme.pdf.object.PdfInformation;
import jp.co.extreme.pdf.object.PdfOutlineEntry;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfOutlineNode;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;
import nlc.lib.doc.shape.DcfAbstractShape;
import nlc.lib.doc.shape.DcfArcShape;
import nlc.lib.doc.shape.DcfEllipseShape;
import nlc.lib.doc.shape.DcfImageShape;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfRectangleShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;
import nlc.lib.doc.shape.barcode.DcfAbstractBarcodeShape;

public class PdfBookConverter
extends BcLoggableObject {
    protected Map<String, PdfOutlineEntry> depthMap = new HashMap<String, PdfOutlineEntry>();

    public synchronized void createPdf(PdfInformation pdfInfo, DcfPageReader pageReader, OutputStream os) throws Exception {
        if (pageReader.getPageCount() <= 0) {
            return;
        }
        PdfProducer producer = new PdfProducer();
        producer.beginDoc(os);
        int i = 0;
        while (i < pageReader.getPageCount()) {
            if (DcfBook.class.isAssignableFrom(pageReader.getClass())) {
                DcfBook dcfBook = (DcfBook)pageReader;
                this.drawPage(producer, i, dcfBook.getPage(i), dcfBook.rootNode);
            } else {
                this.drawPage(producer, i, pageReader.getPage(i), null);
            }
            ++i;
        }
        pageReader.close();
        pdfInfo.setCreator("Ex-PDF Creator Ver 1.0 beta");
        producer.setAuthor(pdfInfo.getAuthor());
        producer.setCreator(pdfInfo.getCreator());
        producer.useOutline();
        int length = producer.endDoc();
    }

    public synchronized void createPdf(PdfInformation pdfInfo, DcfPageReader pageReader, File destFile) throws Exception {
        BcFileUtil.makeParent(destFile);
        try (FileOutputStream os = new FileOutputStream(destFile);){
            this.createPdf(pdfInfo, pageReader, os);
        }
    }

    protected double toPdfX(DcfPage dcfPage, double tx) throws Exception {
        DcfPageFormat pageFormat = dcfPage.getPageFormat();
        return DcfDocumentUtil.inch72ToPixel(pageFormat.getImageableX()) + tx;
    }

    protected double toPdfY(DcfPage dcfPage, double ty) throws Exception {
        DcfPageFormat pageFormat = dcfPage.getPageFormat();
        return DcfDocumentUtil.inch72ToPixel(dcfPage.getPageFormat().getHeight()) - (pageFormat.getImageableY() + ty);
    }

    protected void drawPage(PdfProducer producer, int pageSeq, DcfPage dcfPage, DcfOutlineNode rootNode) throws Exception {
        if (pageSeq > 0) {
            producer.newPage();
        }
        producer.setPageWidth((int)DcfDocumentUtil.inch72ToPixel(dcfPage.getPageFormat().getWidth()));
        producer.setPageHeight((int)DcfDocumentUtil.inch72ToPixel(dcfPage.getPageFormat().getHeight()));
        producer.setTitle("page " + (pageSeq + 1));
        producer.getContents().setLineWidth(0.6);
        int i = 0;
        while (i < dcfPage.getGroupCount()) {
            DcfShapeGroup shapeGroup = dcfPage.getGroup(i);
            this.drawGroup(producer, dcfPage, 0.0, 0.0, shapeGroup);
            ++i;
        }
        if (rootNode != null) {
            PdfOutlineTree outlineTree = producer.getOutlines();
            PdfOutlineEntry outlineEntryRoot = outlineTree.getRoot();
            this.outlineTrans(outlineTree, pageSeq, rootNode, dcfPage);
        }
    }

    protected void outlineTrans(PdfOutlineTree outlineTree, int pageSeq, DcfOutlineNode outlineNode, DcfPage dcfPage) throws Exception {
        if (outlineNode.pageSeq == pageSeq) {
            PdfOutlineEntry paOutlineEntry = this.depthMap.get(Integer.toString(outlineNode.getLevel() - 1));
            if (paOutlineEntry == null) {
                paOutlineEntry = outlineTree.getRoot();
            }
            double pdfX = this.toPdfX(dcfPage, dcfPage.getGroup("ph").getX() + outlineNode.x);
            double pdfY = this.toPdfY(dcfPage, dcfPage.getGroup("ph").getY() + outlineNode.y);
            PdfOutlineEntry outlineEntry = outlineTree.addEntry(paOutlineEntry, outlineNode.getUserObject().toString(), (int)pdfX, (int)pdfY, outlineNode.isOpen);
            this.depthMap.put(Integer.toString(outlineNode.getLevel()), outlineEntry);
        }
        int i = 0;
        while (i < outlineNode.getChildCount()) {
            DcfOutlineNode outlineNode2 = (DcfOutlineNode)outlineNode.getChildAt(i);
            this.outlineTrans(outlineTree, pageSeq, outlineNode2, dcfPage);
            ++i;
        }
    }

    protected void drawSahep(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfShape shape) throws Exception {
        DcfAbstractShape ellipseShape;
        if (DcfShapeGroup.class.isAssignableFrom(shape.getClass())) {
            DcfShapeGroup shapeGroup2 = (DcfShapeGroup)shape;
            this.drawGroup(producer, dcfPage, bx, by, shapeGroup2);
        } else if (DcfRectangleShape.class.isAssignableFrom(shape.getClass())) {
            DcfRectangleShape rectangleShape = (DcfRectangleShape)shape;
            if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
                DcfTextShape textShape = (DcfTextShape)shape;
                this.drawTextShape(producer, dcfPage, bx, by, textShape);
            } else if (DcfImageShape.class.isAssignableFrom(shape.getClass())) {
                DcfImageShape imageShape = (DcfImageShape)shape;
                this.drawImage(producer, dcfPage, bx, by, imageShape);
            }
        } else if (DcfLineShape.class.isAssignableFrom(shape.getClass())) {
            DcfLineShape lineShape = (DcfLineShape)shape;
            this.drawLine(producer, dcfPage, bx, by, lineShape);
            this.drawLineByEx(producer, dcfPage, bx, by, lineShape.getLine().x1, lineShape.getLine().y1, lineShape.getLine().x2, lineShape.getLine().y2, lineShape.lineWidth, lineShape.lineType, lineShape.lineColor);
        } else if (DcfEllipseShape.class.isAssignableFrom(shape.getClass())) {
            ellipseShape = (DcfEllipseShape)shape;
            this.drawEllipse(producer, dcfPage, bx, by, (DcfEllipseShape)ellipseShape);
        }
        if (DcfArcShape.class.isAssignableFrom(shape.getClass())) {
            ellipseShape = (DcfArcShape)shape;
        }
        if (DcfAbstractBarcodeShape.class.isAssignableFrom(shape.getClass())) {
            DcfAbstractBarcodeShape barcodeShape = (DcfAbstractBarcodeShape)shape;
            this.drawBarcodeShape(producer, dcfPage, bx, by, barcodeShape);
        }
    }

    protected void drawGroup(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfShapeGroup shapeGroup) throws Exception {
        int i = 0;
        while (i < shapeGroup.getShapeCount()) {
            DcfShape shape = shapeGroup.getShape(i);
            this.drawSahep(producer, dcfPage, bx + shapeGroup.getX(), by + shapeGroup.getY(), shape);
            ++i;
        }
    }

    protected void drawTextShape(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfTextShape textShape) throws Exception {
        int i;
        if (!BcStringUtil.isEmpty(textShape.value)) {
            Color color = textShape.textColor != null ? textShape.textColor : Color.black;
            producer.getContents().setRgbFillColor(color.getRed(), color.getGreen(), color.getBlue());
            producer.getContents().setRgbStrokeColor(color.getRed(), color.getGreen(), color.getBlue());
            if (textShape.textOrientation == 2) {
                String pdfFont = this.getPdfFontClassName(textShape);
                TextLayout textLayout = DcfDocumentUtil.createDefaultTextLayout(textShape.font, null);
                double ascent = textLayout.getAscent();
                double descent = textLayout.getDescent();
                double advance = textLayout.getAdvance();
                double strHeight = (ascent + descent) * (double)textShape.value.length();
                double tX = 0.0;
                double tY = 0.0;
                tX = textShape.horizontalAlign == 0 ? textShape.getX() + (textShape.getRectangle().width - advance) / 2.0 : (textShape.horizontalAlign == 4 ? textShape.getX() + textShape.getRectangle().width - advance - 4.0 : textShape.getX() + 4.0);
                tY = textShape.verticalAlign == 0 ? textShape.getY() + (textShape.getRectangle().height - strHeight) / 2.0 : (textShape.verticalAlign == 3 ? textShape.getY() + textShape.getRectangle().height - strHeight : textShape.getY() + 1.0);
                double pdfX1 = 0.0;
                double pdfY1 = 0.0;
                i = 0;
                while (i < textShape.value.length()) {
                    if (!((ascent + descent) * (double)(i + 1) > textShape.getRectangle().height)) {
                        pdfX1 = this.toPdfX(dcfPage, bx + tX);
                        pdfY1 = this.toPdfY(dcfPage, by + tY + (ascent + descent) * (double)(i + 1));
                        producer.getContents().textOut(pdfX1, pdfY1, textShape.value.substring(i, i + 1), pdfFont, textShape.font.getSize());
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                this.drawMultiFontText(producer, dcfPage, bx, by, textShape);
            }
        }
        if (!textShape.isFill) {
            if (textShape.lineWidth > 0.0 && textShape.lineColor != null) {
                double pdfX = this.toPdfX(dcfPage, bx + textShape.getX());
                double pdfY = this.toPdfY(dcfPage, by + textShape.getY() + textShape.getRectangle().height);
                producer.getContents().setRgbFillColor(textShape.lineColor.getRed(), textShape.lineColor.getGreen(), textShape.lineColor.getBlue());
                producer.getContents().drawRect(pdfX, pdfY, textShape.getRectangle().width, textShape.getRectangle().height);
            }
        } else if (textShape.lineColor != null) {
            double pdfX = this.toPdfX(dcfPage, bx + textShape.getX());
            double pdfY = this.toPdfY(dcfPage, by + textShape.getY() + textShape.getRectangle().height);
            this.setLineAttribute(producer, textShape.lineWidth, textShape.lineType, textShape.lineColor);
            producer.getContents().fillRect(pdfX, pdfY, textShape.getRectangle().width, textShape.getRectangle().height);
        }
        if (textShape.hatchingDot > 0.0) {
            double rowHeight = textShape.getRectangle().height;
            double tmpX = 0.0;
            double tmpY = rowHeight;
            double hsX = bx + tmpX;
            double hsY = by + tmpY - rowHeight;
            double hsW = textShape.getRectangle().width;
            double hsH = rowHeight;
            double rx = hsW / textShape.hatchingConcentration + 1.0;
            double ry = hsH / textShape.hatchingConcentration + 1.0;
            Color color1 = Color.BLACK;
            if (textShape.hatchingColor != null) {
                color1 = textShape.hatchingColor;
            }
            producer.getContents().setRgbFillColor(color1.getRed(), color1.getGreen(), color1.getBlue());
            i = 0;
            while ((double)i < rx) {
                double px = hsX + (double)i * textShape.hatchingConcentration;
                int j = 0;
                while ((double)j < ry) {
                    if (BcMath.isEven(i) == BcMath.isEven(j)) {
                        double py = hsY + (double)j * textShape.hatchingConcentration;
                        double pdfX = this.toPdfX(dcfPage, bx + textShape.getX() + px);
                        double pdfY = this.toPdfY(dcfPage, by + textShape.getY() + py);
                        producer.getContents().fillRect(pdfX, pdfY, textShape.hatchingDot, textShape.hatchingDot);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void drawMultiFontText(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfTextShape textShape) throws Exception {
        if (textShape.getRectangle().width - 2.0 <= 0.0) {
            return;
        }
        if (textShape.getRectangle().height <= 0.0) {
            return;
        }
        ArrayList<String> strList = new ArrayList<String>();
        BcStringUtil.lineSeparetor(textShape.value, strList);
        String pdfFont = this.getPdfFontClassName(textShape);
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        TextLayout textLayout = DcfDocumentUtil.createDefaultTextLayout(textShape.font, null);
        AttributedString attributedString = null;
        LineBreakMeasurer lineBreakMeasurer = null;
        double ascent = textLayout.getAscent();
        double descent = textLayout.getDescent();
        double pX = 0.0;
        double pY = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        pY = textShape.verticalAlign == 0 ? textShape.getY() + (textShape.getRectangle().height - (double)strList.size() * (ascent + descent)) / 2.0 : (textShape.verticalAlign == 3 ? textShape.getY() + (textShape.getRectangle().height - (double)strList.size() * (ascent + descent)) : textShape.getY() + 1.0);
        int i = 0;
        while (i < strList.size()) {
            String str = (String)strList.get(i);
            int rowCount = 0;
            int len = str.length();
            if (len <= 0) {
                ++rowCount;
                pY += ascent + descent;
            } else {
                attributedString = new AttributedString(str);
                attributedString.addAttribute(TextAttribute.FONT, textShape.font, 0, len);
                fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
                lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
                lineBreakMeasurer.setPosition(0);
                while (lineBreakMeasurer.getPosition() < len) {
                    if ((ascent + descent) * (double)(++rowCount) > textShape.getRectangle().height + 1.0) break;
                    int pos = lineBreakMeasurer.getPosition();
                    textLayout = lineBreakMeasurer.nextLayout((float)textShape.getRectangle().width - 2.0f);
                    pX = textShape.horizontalAlign == 0 ? textShape.getX() + (textShape.getRectangle().width - textLayout.getBounds().getWidth()) / 2.0 : (textShape.horizontalAlign == 4 ? textShape.getX() + (textShape.getRectangle().width - textLayout.getBounds().getWidth() - 4.0) : textShape.getX() + 4.0);
                    x1 = this.toPdfX(dcfPage, bx + pX);
                    y1 = this.toPdfY(dcfPage, by + (pY += ascent));
                    producer.getContents().textOut(x1, y1, str.substring(pos, lineBreakMeasurer.getPosition()), pdfFont, (double)textShape.font.getSize() * 0.941);
                    pY += descent;
                }
            }
            ++i;
        }
    }

    protected void drawEllipse(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfEllipseShape ellipseShape) throws Exception {
        Ellipse2D.Double ellipse = ellipseShape.getEllipse();
        Color color = Color.black;
        producer.getContents().saveGraphicsState();
        producer.getContents().setRgbFillColor(color.getRed(), color.getGreen(), color.getBlue());
        PathIterator pathIterator = ellipse.getPathIterator(new AffineTransform());
        double[] dvArray = new double[6];
        int cnt = 0;
        while (!pathIterator.isDone()) {
            pathIterator.next();
            ++cnt;
            int res = pathIterator.currentSegment(dvArray);
            if (res == 4) break;
            this.conv(producer, dcfPage, bx, by, dvArray);
            if (cnt == 1) {
                producer.getContents().moveTo(dvArray[0], dvArray[1]);
            }
            producer.getContents().curveTo(dvArray);
        }
        producer.getContents().closeAndStrokePath();
        producer.getContents().restoreGraphicsState();
    }

    protected void conv(PdfProducer producer, DcfPage dcfPage, double bx, double by, double[] dvArray) throws Exception {
        dvArray[0] = this.toPdfX(dcfPage, bx + dvArray[0]);
        dvArray[1] = this.toPdfY(dcfPage, by + dvArray[1]);
        dvArray[2] = this.toPdfX(dcfPage, bx + dvArray[2]);
        dvArray[3] = this.toPdfY(dcfPage, by + dvArray[3]);
        dvArray[4] = this.toPdfX(dcfPage, bx + dvArray[4]);
        dvArray[5] = this.toPdfY(dcfPage, by + dvArray[5]);
    }

    protected void setLineAttribute(PdfProducer producer, double lineWidth, String lineType, Color lineColor) throws Exception {
        producer.getContents().setLineWidth(lineWidth);
        if (DcfConstants.LineType.dotted01.equals(lineType)) {
            producer.getContents().setDash(3, 3, 0);
        } else {
            producer.getContents().setDash(0, 0, 0);
        }
        if (lineColor != null) {
            producer.getContents().setRgbStrokeColor(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue());
        }
    }

    protected void drawLine(PdfProducer producer, double pdfX1, double pdfY1, double pdfX2, double pdfY2, double lineWidth, String lineType, Color lineColor) throws Exception {
        if (lineWidth <= 0.0) {
            return;
        }
        if (lineColor == null) {
            lineColor = Color.black;
        }
        this.setLineAttribute(producer, lineWidth, lineType, lineColor);
        producer.getContents().drawLine(pdfX1, pdfY1, pdfX2, pdfY2, lineWidth);
    }

    protected void drawLineByEx(PdfProducer producer, DcfPage dcfPage, double bx, double by, double exX1, double exY1, double exX2, double exY2, double lineWidth, String lineType, Color lineColor) throws Exception {
        double pdfX1 = this.toPdfX(dcfPage, bx + exX1);
        double pdfY1 = this.toPdfY(dcfPage, by + exY1);
        double pdfX2 = this.toPdfX(dcfPage, bx + exX2);
        double pdfY2 = this.toPdfY(dcfPage, by + exY2);
        this.drawLine(producer, pdfX1, pdfY1, pdfX2, pdfY2, lineWidth, lineType, lineColor);
    }

    protected void drawLine(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfLineShape lineShape) throws Exception {
        this.drawLineByEx(producer, dcfPage, bx, by, lineShape.getLine().x1, lineShape.getLine().y1, lineShape.getLine().x2, lineShape.getLine().y2, lineShape.lineWidth, lineShape.lineType, lineShape.lineColor);
    }

    protected String getPdfFontClassName(DcfTextShape textShape) {
        String pdfFont = PdfMincyo.class.getName();
        if ((textShape.font.getStyle() & 1) != 0) {
            pdfFont = PdfMincyoBold.class.getName();
        }
        textShape.font.getStyle();
        return pdfFont;
    }

    protected void drawImage(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfImageShape imageShape) throws Exception {
        producer.getContents().drawImage();
    }

    protected void drawBarcodeShape(PdfProducer producer, DcfPage dcfPage, double bx, double by, DcfAbstractBarcodeShape barcodeShape) throws Exception {
    }
}

