/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xsod.model.XsodMerchandise;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XsodMerchandiseDAO
extends OrmAbstractDAO<XsodMerchandise> {
    public static final int MODE_default = 1;

    private XsodMerchandiseDAO() {
        super(new XsodMerchandise[0]);
        this.setTableName("xsod_merchandise");
    }

    public static XsodMerchandiseDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, String merchandiseCode) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (!BcStringUtil.isEmpty(merchandiseCode)) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "code" + sqlContext.toCondition_string("=", merchandiseCode));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "code");
        }
        return selectQuery;
    }

    public List<XsodMerchandise> getList(DtsSession dtsSession, String merchandiseCode) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "mchd";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, merchandiseCode);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("query=" + query);
        return this.getEntityList(dtsSession, query);
    }

    public XsodMerchandise getByCode(DtsSession dtsSession, String merchandiseCode) throws Exception {
        if (BcStringUtil.isEmpty(merchandiseCode)) {
            return null;
        }
        List<XsodMerchandise> entityList = this.getList(dtsSession, merchandiseCode);
        return BcCollectionUtil.getFirst(entityList);
    }

    public int deleteByCode(DtsSession dtsSession, String merchandiseCode) throws Exception {
        if (BcStringUtil.isEmpty(merchandiseCode)) {
            return 0;
        }
        XsodMerchandise merchandise = new XsodMerchandise();
        merchandise.code = merchandiseCode;
        int deleteCount = this.getPersistenceProxy().deleteEntity(dtsSession, this.getTableName(), merchandise);
        return deleteCount;
    }

    /* synthetic */ XsodMerchandiseDAO(XsodMerchandiseDAO xsodMerchandiseDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodMerchandiseDAO instance = new XsodMerchandiseDAO(null);

        private SingletonHolder() {
        }
    }
}

