/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.io.File;
import java.util.concurrent.Future;
import jp.co.extreme.app.common.AfbConstants;
import jp.co.extreme.base.util.BcProcessExecutor;
import jp.co.extreme.etc.util.EtcLockManger;
import jp.co.extreme.module.ffmpeg.FfmpegHelper;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilIndexGroup;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.task.TskAbstractCallable2;

public class XfilSegmentFileCreateTask
extends TskAbstractCallable2 {
    public Future future;

    public Object taskProcess() throws Exception {
        XfilUriEntity uriEntity;
        long exceptEntityId = -1L;
        while ((uriEntity = XfilServerUtil.getInstance().segmentTargetQueue.poll()) != null) {
            XfilUriEntity preEntity = EtcLockManger.getInstance().check(uriEntity, uriEntity.id);
            if (preEntity == null) {
                block7: {
                    try {
                        try {
                            this.createSegmentFile(uriEntity);
                        }
                        catch (Exception ex) {
                            this.getLogger().error(ex);
                            XfilServerUtil.getInstance().addUriEntityError(uriEntity);
                            EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                        throw throwable;
                    }
                    EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                }
                exceptEntityId = -1L;
                continue;
            }
            exceptEntityId = preEntity.id;
        }
        this.future = null;
        return null;
    }

    protected void createSegmentFile(XfilUriEntity uriEntity) throws Exception {
        long free;
        File sourceFile = new File(uriEntity.directory, uriEntity.name);
        this.getLogger().info("createSegmentFile:uriEntity.name=" + uriEntity.name + " exists=" + sourceFile.exists());
        if (!sourceFile.exists()) {
            this.getLogger().warning("Not exists.");
            return;
        }
        if (FfmpegHelper.getInstance().getResult().hasError()) {
            this.getLogger().error(FfmpegHelper.getInstance().getResult().getErrorList());
            return;
        }
        XfilIndexGroup indexGroup = XfilServerUtil.getInstance().getIndexGroupMap(null).get(uriEntity.indexGroupId);
        File segmentDir = XfilServerUtil.getInstance().getSegmentDir(uriEntity.indexGroupId, null);
        long total = segmentDir.getTotalSpace();
        double usage = total - (free = segmentDir.getUsableSpace());
        double usageRate = usage / (double)total * 100.0;
        if (usageRate >= indexGroup.storageUsageLimit.doubleValue()) {
            this.getLogger().warning("usageRate=" + usageRate + " storageUsageLimit=" + indexGroup.storageUsageLimit);
            XfilServerUtil.getInstance().addUriEntityError(uriEntity);
            return;
        }
        File m3u8File = XfilUtil.getM3u8(uriEntity, segmentDir);
        this.getLogger().debug("m3u8File=" + m3u8File.getPath());
        if (!m3u8File.exists()) {
            BcProcessExecutor.BcProcessResult processResult = FfmpegHelper.getInstance().createHls(sourceFile, m3u8File);
            int cfr_ignored_0 = processResult.exitValue;
            int cfr_ignored_1 = AfbConstants.ExitCode.OK.code;
        }
    }
}

