/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.task.TskAbstractCallable2;
import jp.co.extreme.task.TskTaskEvent;

public abstract class BcTaskGroup<T extends TskAbstractCallable2>
extends BcLoggableObject
implements BcEventHandler<TskTaskEvent> {
    private int min;
    private int max;
    private List<T> taskList = new ArrayList<T>();

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public synchronized T addTask() throws Exception {
        int i = 0;
        while (i < this.max) {
            TskAbstractCallable2 task;
            if (this.taskList.size() <= i) {
                this.taskList.add(null);
            }
            if ((task = (TskAbstractCallable2)this.taskList.get(i)) == null) {
                task = this.createTask(i);
                task.addEventHandler(this);
                this.taskList.set(i, task);
                return (T)task;
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean tryStop(T task) throws Exception {
        int index = this.taskList.indexOf(task);
        boolean bool = false;
        if (index >= this.min) {
            this.taskList.set(index, null);
            bool = true;
        }
        return bool;
    }

    abstract T createTask(int var1) throws Exception;

    @Override
    public void handle(TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            TskAbstractCallable callable = (TskAbstractCallable)event.getSource();
            int index = this.taskList.indexOf(callable);
            if (index >= 0) {
                this.taskList.set(index, null);
            } else {
                this.getLogger().error("Remove failed. hashCode=" + callable.hashCode());
            }
        }
    }
}

