/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.common;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.co.extreme.app.common.AfbConstants;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcProcessExecutor;
import jp.co.extreme.module.ffmpeg.FfmpegHelper;
import jp.co.extreme.module.ffmpeg.FfpegParam;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.model.MovieInfo;
import jp.co.extreme.module.xfil.model.XfilCrawler;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureCondition;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureParameter;

public final class XfilCaptureUtil {
    private XfilCaptureUtil() {
    }

    public static Object[] executeFfmpeg(FfmpegHelper ffmpegHelper, FfpegParam ffpegParam) throws Exception {
        BcProcessExecutor.BcProcessResult processResult = ffmpegHelper.createImage(ffpegParam);
        ArrayList<File> fileList = null;
        if (processResult.exitValue == AfbConstants.ExitCode.OK.code) {
            fileList = new ArrayList<File>();
            fileList.add(new File(ffpegParam.outputPath));
        }
        Object[] res = new Object[]{processResult, fileList};
        return res;
    }

    public static void setParam(XfilVideoCaptureParameter videoCaptureParam, FfpegParam ffpegParam) throws Exception {
        ffpegParam.width = videoCaptureParam.width;
        ffpegParam.height = videoCaptureParam.height;
    }

    public static XfilVideoCaptureParameter adjustment(XfilVideoCaptureParameter param1, MovieInfo movieInfo) throws Exception {
        XfilVideoCaptureParameter param2 = BcCloneUtil.createClone(param1);
        Rectangle2D.Double awtRectangle = AwtImageUtil.calcKeepRatioSize(movieInfo.width, movieInfo.height, param2.width, param2.height);
        param2.width = (int)awtRectangle.width;
        param2.height = (int)awtRectangle.height;
        long mainDuration = movieInfo.durationMillis - param2.headMargin - param2.tailMargin;
        if (mainDuration <= param2.headMargin + param2.tailMargin) {
            mainDuration = movieInfo.durationMillis;
            param2.headMargin = 0L;
            param2.tailMargin = 0L;
        }
        param2.capturingCount = (int)(mainDuration / param2.interval);
        if (param2.capturingCount > param2.capturingCountMax) {
            param2.capturingCount = param2.capturingCountMax;
            param2.interval = mainDuration / (long)param2.capturingCount;
        }
        if (param2.capturingCount < param2.capturingCountMin) {
            param2.capturingCount = param2.capturingCountMin;
            param2.interval = mainDuration / (long)param2.capturingCount;
        }
        return param2;
    }

    public static List<Long> calcStartTime(XfilVideoCaptureParameter screenCaptureParam) throws Exception {
        ArrayList<Long> startTimeMillisList = new ArrayList<Long>();
        int i = 0;
        while (i < screenCaptureParam.capturingCount) {
            long startTimeMillis = screenCaptureParam.headMargin + screenCaptureParam.interval * (long)i;
            startTimeMillisList.add(startTimeMillis);
            ++i;
        }
        return startTimeMillisList;
    }

    public static XfilVideoCaptureParameter convert(XfilVideoCaptureCondition videoCaptureCondition) throws Exception {
        XfilVideoCaptureParameter videoCaptureParam = new XfilVideoCaptureParameter();
        videoCaptureParam.width = videoCaptureCondition.capturingWidth;
        videoCaptureParam.height = videoCaptureCondition.capturingHeight;
        videoCaptureParam.headMargin = videoCaptureCondition.headMarginSec * 1000;
        videoCaptureParam.tailMargin = videoCaptureCondition.tailMarginSec * 1000;
        videoCaptureParam.intervalMin = 180000L;
        videoCaptureParam.capturingCountMax = videoCaptureCondition.capturingCountMax;
        videoCaptureParam.capturingCountMin = 3;
        videoCaptureParam.interval = videoCaptureCondition.intervalSec * 1000;
        videoCaptureParam.elapsedTime = videoCaptureCondition.elapsedTime;
        videoCaptureParam.elapsedTimeHorizontalPositionId = videoCaptureCondition.elapsedTimeHorizontalPositionId;
        videoCaptureParam.elapsedTimeVerticalPositionId = videoCaptureCondition.elapsedTimeVerticalPositionId;
        return videoCaptureParam;
    }

    public static XfilVideoCaptureCondition createVideoCaptureConditionDefault() {
        XfilVideoCaptureCondition videoCaptureCondition = new XfilVideoCaptureCondition();
        videoCaptureCondition.capturingWidth = XfilConstants.thumbnailResolution.width;
        videoCaptureCondition.capturingHeight = XfilConstants.thumbnailResolution.height;
        videoCaptureCondition.intervalSec = 10;
        videoCaptureCondition.headMarginSec = 10;
        videoCaptureCondition.tailMarginSec = 10;
        videoCaptureCondition.capturingCountMax = 10;
        videoCaptureCondition.elapsedTime = false;
        videoCaptureCondition.elapsedTimeHorizontalPositionId = 0;
        videoCaptureCondition.elapsedTimeVerticalPositionId = 3;
        return videoCaptureCondition;
    }

    public static XfilVideoCaptureCondition convVideoCaptureCondition(XfilCrawler crawler) {
        XfilVideoCaptureCondition videoCaptureCondition = new XfilVideoCaptureCondition();
        videoCaptureCondition.capturingWidth = crawler.vcCapturingWidth;
        videoCaptureCondition.capturingHeight = crawler.vcCapturingHeight;
        videoCaptureCondition.intervalSec = crawler.vcIntervalSec;
        videoCaptureCondition.headMarginSec = crawler.vcHeadMarginSec;
        videoCaptureCondition.tailMarginSec = crawler.vcTailMarginSec;
        videoCaptureCondition.capturingCountMax = crawler.vcCapturingCountMax;
        videoCaptureCondition.elapsedTime = crawler.vcElapsedTime;
        videoCaptureCondition.elapsedTimeHorizontalPositionId = crawler.vcElapsedTimeHorizontalPositionId;
        videoCaptureCondition.elapsedTimeVerticalPositionId = crawler.vcElapsedTimeVerticalPositionId;
        return videoCaptureCondition;
    }

    public static XfilCrawler createCrawlerDefault() {
        String dateTimeStr;
        XfilCrawler crawler = new XfilCrawler();
        crawler.fileExtention = BcCsvUtil.toCsv(XfilConstants.getMovieExtentionList());
        XfilVideoCaptureCondition videoCaptureCondition = XfilCaptureUtil.createVideoCaptureConditionDefault();
        crawler.vcCapturingWidth = videoCaptureCondition.capturingWidth;
        crawler.vcCapturingHeight = videoCaptureCondition.capturingHeight;
        crawler.vcIntervalSec = videoCaptureCondition.intervalSec;
        crawler.vcHeadMarginSec = videoCaptureCondition.headMarginSec;
        crawler.vcTailMarginSec = videoCaptureCondition.tailMarginSec;
        crawler.vcCapturingCountMax = videoCaptureCondition.capturingCountMax;
        crawler.vcElapsedTime = videoCaptureCondition.elapsedTime;
        crawler.vcElapsedTimeHorizontalPositionId = videoCaptureCondition.elapsedTimeHorizontalPositionId;
        crawler.vcElapsedTimeVerticalPositionId = videoCaptureCondition.elapsedTimeVerticalPositionId;
        Calendar now = BcTimeUtil.createCalendar();
        crawler.name = dateTimeStr = BcTimeUtil.toString(now, "yyyy/MM/dd HH:mm:ss");
        return crawler;
    }

    public static FfmpegHelper.Resolution toResolution(int width, int height) {
        FfmpegHelper.Resolution[] resolutionArray = FfmpegHelper.Resolution.values();
        int n = resolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FfmpegHelper.Resolution resolution = resolutionArray[n2];
            if (resolution.width == width && resolution.height == height) {
                return resolution;
            }
            ++n2;
        }
        return null;
    }
}

