/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcCloneUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.server.XdtsServerUtil;
import jp.co.extreme.module.xdts.server.XsysResultSetCopyTask;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.task.TskAbstractCallable;

public class XdtsRowCopyTask
extends TskAbstractCallable<BcResult> {
    @Override
    public BcResult taskProcess() throws Exception {
        BcResult result = new BcResult();
        return result;
    }

    public void copyRow(SqlConnection sqlConn1, SqlConnection sqlConn2, Collection<XdtsSchemaObject> schemaObjectCollection, XdtsProcessCondition processCondition) throws Exception {
        File errorFile = new File(processCondition.errorFilePath);
        this.getLogger().info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        OutputStreamWriter errorWriter = null;
        errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, false), BcConstants.charset.name());
        if (processCondition.commitMode == XdtsConstants.CommitMode.AUTO) {
            sqlConn2.setAutoCommit(true);
        }
        this.copyRow_L2(sqlConn1, sqlConn2, schemaObjectCollection, processCondition, errorWriter);
        if (processCondition.commitMode == XdtsConstants.CommitMode.FINAL) {
            sqlConn2.commit();
        }
        sqlConn2.setAutoCommit(false);
    }

    public void copyRow_L2(SqlConnection sqlConn1, SqlConnection sqlConn2, Collection<XdtsSchemaObject> schemaObjectCollection, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        for (XdtsSchemaObject schemaObject : schemaObjectCollection) {
            SqlContext sqlContext1 = sqlConn1.getSqlContext();
            MmdModel mmdModel1 = sqlContext1.createModelMetaData(sqlConn1, schemaObject.name1);
            this.copyRow_L3(sqlConn1, sqlConn2, mmdModel1, processCondition, errorWriter);
            if (processCondition.commitMode != XdtsConstants.CommitMode.TABLE) continue;
            sqlConn2.commit();
        }
    }

    public void copyRow_L3(SqlConnection sqlConn1, SqlConnection sqlConn2, MmdModel mmdModel1, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        SqlContext sqlContext1 = sqlConn1.getSqlContext();
        MmdModel mmdModel2 = this.createTablePre(sqlContext1, mmdModel1, sqlConn2.getSqlContext(), sqlConn2, processCondition);
        if (mmdModel2.getFieldCount() <= 0) {
            String msg = String.valueOf(XdtsWords.getInstance().Not_copied_because_the_number_of_columns_is_zero) + " [" + mmdModel1.tableName + "]";
            this.getLogger().warning(msg);
            return;
        }
        boolean existTable = XdtsServerUtil.getInstance().dropTable(sqlConn2, mmdModel2.tableName, processCondition.recreateTable, processCondition.truncateTable, processCondition.deleteRecord);
        if (!existTable) {
            this.createTable(processCondition, mmdModel2, sqlConn2, errorWriter);
            this.getLogger().info("\u30e2\u30c7\u30eb\u30e1\u30bf\u30c7\u30fc\u30bf\u3092JDBC\u60c5\u5831\u304b\u3089\u518d\u69cb\u7bc9");
            mmdModel2 = sqlContext1.createModelMetaData(sqlConn1, mmdModel2.tableName);
        }
        this.copyRow_L4(sqlConn1, mmdModel1, sqlConn2, mmdModel2, processCondition.copyRowUnit, processCondition.ignoreException, errorWriter);
        if (processCondition.recreateTable) {
            this.createIndex(sqlConn2, mmdModel2, processCondition, errorWriter);
        }
    }

    public long copyRow_L4(SqlConnection sqlConn1, MmdModel mmdModel1, SqlConnection sqlConn2, MmdModel mmdModel2, long rowCountUnit, boolean ignoreException, Writer errorWriter) throws Exception {
        SqlContext sqlContext1 = sqlConn1.getSqlContext();
        SqlSelectQuery selectQuery = XdtsSqlConditionUtil.createSelectQuery(sqlContext1, mmdModel1);
        MmdIndex primaryIndex = mmdModel1.getPrimaryIndex();
        long rowCount = sqlContext1.getRowCount(sqlConn1, mmdModel2.tableName);
        this.getLogger().info("rowCount=" + rowCount);
        long roopCnt = 1L;
        if (primaryIndex != null) {
            List<String> orderByList = XdtsSqlConditionUtil.createOrderByList(primaryIndex);
            selectQuery.getOrderByList().addAll(orderByList);
            if (rowCountUnit > 0L) {
                roopCnt = rowCount / rowCountUnit;
                if (rowCount % rowCountUnit > 0L) {
                    ++roopCnt;
                }
            }
        }
        long updateCountSum = 0L;
        int i = 0;
        while ((long)i < roopCnt) {
            if (primaryIndex != null && roopCnt > 1L) {
                selectQuery.rowLimit = rowCountUnit;
                selectQuery.rowOffset = (long)i * rowCountUnit + 1L;
            }
            String query = sqlContext1.buildSelectQuery(selectQuery);
            this.getLogger().info("selectQuery=" + query);
            Throwable throwable = null;
            Object var21_20 = null;
            try (SqlStatement stmt = sqlConn1.createStatement();){
                SqlResultSet rs = stmt.executeQuery(query);
                long updateCount = this.copyRow_L5(rs, sqlConn2, mmdModel2, ignoreException, errorWriter);
                this.getLogger().info("updateCount=" + updateCount + " updateCountSum=" + (updateCountSum += updateCount));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
        return updateCountSum;
    }

    public long copyRow_L5(SqlResultSet rs, SqlConnection sqlConn2, MmdModel mmdModel2, boolean ignoreException, Writer errorWriter) throws Exception {
        XsysResultSetCopyTask resultSetCopyTask = new XsysResultSetCopyTask();
        resultSetCopyTask.setLogger(this.getLogger());
        resultSetCopyTask.setResultSet(rs);
        resultSetCopyTask.setCondition(sqlConn2, mmdModel2, ignoreException, errorWriter);
        resultSetCopyTask.taskProcess();
        return resultSetCopyTask.updateCount;
    }

    public MmdModel createTablePre(SqlContext sqlContext1, MmdModel mmdModel1, SqlContext sqlContext2, SqlConnection sqlConn2, XdtsProcessCondition processCondition) throws Exception {
        MmdModel mmdModel2 = null;
        boolean recreateTable = false;
        if (processCondition.recreateTable) {
            recreateTable = processCondition.recreateTable;
        } else if (sqlContext2.existTable(sqlConn2, mmdModel1.tableName)) {
            this.getLogger().info("\u8907\u5199\u5148\u306e\u65e2\u5b58\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u3092\u53d6\u5f97 tableName=" + mmdModel1.tableName);
            mmdModel2 = sqlContext2.createModelMetaData(sqlConn2, mmdModel1.tableName);
            this.getLogger().debug(MmdUtil.createInfo(mmdModel2));
            ArrayList<String> removeFieldNameList1 = new ArrayList<String>();
            ArrayList<String> removeFieldNameList2 = new ArrayList<String>();
            int i = 0;
            while (i < mmdModel1.getFieldCount()) {
                MmdField mmdField2;
                MmdField mmdField = mmdModel1.getField(i);
                String columnName2 = BcStringUtil.toLowerCase(mmdField.columnName);
                if (sqlContext2.isReservedWord(mmdField.columnName)) {
                    columnName2 = BcStringUtil.toLowerCase(XdtsUtil.renameReservedName(mmdField.columnName));
                }
                if ((mmdField2 = mmdModel2.getFieldByColumnName(columnName2)) == null) {
                    removeFieldNameList1.add(BcStringUtil.toLowerCase(mmdField.columnName));
                } else {
                    removeFieldNameList2.add(columnName2);
                }
                ++i;
            }
            XdtsUtil.removeField(mmdModel1, removeFieldNameList1, true, this.getLogger());
            ArrayList<String> removeFieldNameList3 = new ArrayList<String>();
            int i2 = 0;
            while (i2 < mmdModel2.getFieldCount()) {
                MmdField mmdField = mmdModel2.getField(i2);
                if (!removeFieldNameList2.contains(mmdField.columnName.toLowerCase())) {
                    removeFieldNameList3.add(mmdField.columnName.toLowerCase());
                }
                ++i2;
            }
            XdtsUtil.removeField(mmdModel2, removeFieldNameList3, true, this.getLogger());
            XdtsUtil.renumbeField(mmdModel2, removeFieldNameList2);
        } else {
            recreateTable = true;
        }
        if (recreateTable) {
            this.getLogger().info("\u8907\u5199\u5143\u30c6\u30fc\u30d6\u30eb\u3092\u5143\u306b\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb\u306e\u5b9a\u7fa9\u3092\u4f5c\u6210\u3002");
            mmdModel2 = BcCloneUtil.createClone(mmdModel1);
            List<String> removeFieldNameList = XdtsUtil.createRemoveFieldNameList(sqlContext2, mmdModel2, processCondition.definitionCondition);
            XdtsUtil.removeField(mmdModel1, removeFieldNameList, true, this.getLogger());
            XdtsUtil.removeField(mmdModel2, removeFieldNameList, true, this.getLogger());
        }
        if (sqlContext1.getDatabaseProduct() == SqlConstants.DatabaseProduct.MySQL) {
            int i = 0;
            while (i < mmdModel2.getFieldCount()) {
                MmdField mmdField = mmdModel2.getField(i);
                switch (mmdField.sqlTypeId) {
                    case 91: 
                    case 92: 
                    case 93: {
                        if (mmdField.nullable == BcConstants.Existence.TRUE.value) break;
                        mmdField.nullable = BcConstants.Existence.TRUE.value;
                        this.getLogger().warning(String.format("MySQL\u304b\u3089\u306e\u8907\u5199\u306e\u5834\u5408\u3001\u65e5\u4ed8\u578b\u306fNULL\u8a31\u53ef\u3068\u3057\u307e\u3059\u3002\uff08\u5217\u540d=%S\uff09", mmdField.tableColumnName));
                    }
                }
                ++i;
            }
        }
        return mmdModel2;
    }

    public void createTable(XdtsProcessCondition processCondition, MmdModel mmdModel, SqlConnection sqlConn2, Writer errorWriter) throws Exception {
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        this.getLogger().info(String.format("Creating table... '%s'", mmdModel.tableName));
        String query = sqlContext2.createCreateTableQuery(mmdModel, false, processCondition.definitionCondition);
        this.getLogger().info("query=" + query);
        int cnt = SqlUtil.executeUpdate(sqlConn2, query);
    }

    public void createIndex(SqlConnection sqlConn, MmdModel mmdModel, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        block2: {
            this.getLogger().info(String.format("Creating index... '%s'", mmdModel.tableName));
            SqlContext sqlContext = sqlConn.getSqlContext();
            try {
                int n = sqlContext.createIndex(sqlConn, mmdModel, this.getLogger());
            }
            catch (Exception ex) {
                String stackTrace = BcLogUtil.getStackTrace(ex);
                errorWriter.append(stackTrace);
                if (processCondition.ignoreException) break block2;
                throw ex;
            }
        }
    }
}

