/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.scf4.swg.HswgExportWizerd;

public class XdtsTableToolPane
extends FxBorderPane {
    Button exportButton;
    TableModel tableModel;
    BcTableColumnModel tableColumnModel;

    public XdtsTableToolPane() throws Exception {
        this.exportButton = new Button(BcWords.getInstance().export);
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        HBox hBox = new HBox(8.0);
        this.exportButton.setOnAction(this.actionEventHandler);
        hBox.getChildren().add((Object)this.exportButton);
        hBox.setAlignment(Pos.CENTER);
        this.setCenter((Node)hBox);
    }

    public void setDataModel(TableModel tableModel, BcTableColumnModel tableColumnModel) throws Exception {
        this.tableModel = tableModel;
        this.tableColumnModel = tableColumnModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.exportButton) {
            String filePath = System.getProperty(BcJavaConstants.SysKey.user_home.value);
            this.export(this.tableModel, this.tableColumnModel, filePath);
        }
    }

    public void export(final TableModel tableModel, final BcTableColumnModel tableColumnModel, final String filePath) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HswgExportWizerd exportWizerd = new HswgExportWizerd();
                    exportWizerd.setData(tableModel, tableColumnModel);
                    exportWizerd.setDestFile(new File(filePath));
                    exportWizerd.start(null);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }
}

