/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.lib.html.lightbox.LightboxCreator;
import jp.co.extreme.lib.html.mdc.MdcCreator;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.model.Wbs1PersonBasic;
import jp.co.extreme.module.wbs1.server.Wbs1ServerUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1MarchandiseFormWCB;
import jp.co.extreme.module.xsod.common.EtcImageCash;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.dao.XsodCategoryDAO;
import jp.co.extreme.module.xsod.dao.XsodMerchandiseDAO;
import jp.co.extreme.module.xsod.model.XsodCategory;
import jp.co.extreme.module.xsod.model.XsodCondition;
import jp.co.extreme.module.xsod.model.XsodMerchandise;
import jp.co.extreme.module.xsys.validation.XsysFieldKeyCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class Wbs1MarchandiseListWCB
extends Wbs1AbstractWCB {
    public static final String HRPK_marchandiseCategoryCode = XsysFieldKeyCreator.getInstance().createKey(XsodCondition.class.getSimpleName(), "marchandiseCategoryCode");
    private EtcImageCash imageCash = new EtcImageCash();

    @Override
    protected StringBuilder createBodyScript(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = super.createBodyScript(wcbArg);
        File file = WbfwUtil.getFile(wcbArg, "json_test_1.js");
        sb.append((CharSequence)BcFileUtil.readAsStringBuilder(file));
        return sb;
    }

    public void marchandiseList(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            StringBuilder content = this.createContent_L2(wcbArg, dtsSession);
            StringBuilder sb = this.getBaseHtml(wcbArg);
            sb = this.replace(wcbArg, "\u5546\u54c1\u30ea\u30b9\u30c8", null, sb);
            sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
            WbfwUtil.outputHtml(wcbArg, sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected StringBuilder createContent_L2(WbsArgument wcbArg, DtsSession dtsSession) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        XsodCondition xsodCondition = new XsodCondition();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, xsodCondition);
        BcLogUtil.debug("xsodCondition.marchandiseCategoryCode=" + xsodCondition.marchandiseCategoryCode);
        StringBuilder sb = new StringBuilder();
        ArrayList<XsodMerchandise> merchandiseList = new ArrayList<XsodMerchandise>();
        StringBuilder category = this.createCategory(dtsSession, xsodCondition, merchandiseList);
        category = MdlCreator.getInstance().grid_portfolio(category, true);
        sb.append((CharSequence)category);
        StringBuilder list = this.createListHtml(wcbArg, merchandiseList);
        list = MdlCreator.getInstance().grid_portfolio(list, true);
        sb.append((CharSequence)list);
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1MarchandiseFormWCB.Method.form);
        String onclickAction = WbfJslUtil.locationHref(href);
        String addButton = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().add, onclickAction);
        sb.append((CharSequence)this.getHtmlBuilder().div(addButton.toString(), HtmlConstants.HtmlAlign.center, -1));
        return sb;
    }

    protected StringBuilder createCategory(DtsSession dtsSession, XsodCondition xsodCondition, List<XsodMerchandise> merchandiseList) throws Exception {
        int setId = 1;
        List<XsodCategory> categoryList1 = XsodCategoryDAO.getInstance().getList(dtsSession, setId, null);
        LinkedHashMap<String, XsodCategory> map1 = new LinkedHashMap<String, XsodCategory>();
        int i = 0;
        while (i < categoryList1.size()) {
            XsodCategory category = categoryList1.get(i);
            map1.put(category.code, category);
            ++i;
        }
        XsodCategory category = new XsodCategory();
        XsodUtil.setName(category, this.getLangCode(), "\u5168\u5546\u54c1");
        map1.put(category.code, category);
        DefaultMutableTreeNode treeNodeRoot = this.createTree(categoryList1);
        StringBuilder marchandiseCodes1 = null;
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < treeNodeRoot.getChildCount()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeNodeRoot.getChildAt(i2);
            XsodCategory category2 = (XsodCategory)map1.get(treeNode.getUserObject());
            String categoryName = XsodUtil.getName(category2, this.getLangCode(), true);
            if (i2 > 0) {
                sb.append(" | ");
            }
            if (category2.code.equals(xsodCondition.marchandiseCategoryCode)) {
                marchandiseCodes1 = Wbs1MarchandiseListWCB.getMarchandiseCodes(map1, treeNode);
                sb.append(categoryName);
            } else {
                String href = Method.marchandiseList + "?" + HRPK_marchandiseCategoryCode + "=" + category2.code;
                sb.append((CharSequence)MdlCreator.getInstance().navigationLink(href, false, categoryName, null));
            }
            ++i2;
        }
        BcLogUtil.debug("category1.merchandise_codes=" + marchandiseCodes1);
        List<String> merchandiseCodeList = EtcEnumStrUtil.toValueList(marchandiseCodes1.toString());
        int i3 = 0;
        while (i3 < merchandiseCodeList.size()) {
            String merchandiseCode = merchandiseCodeList.get(i3);
            XsodMerchandise merchandise = XsodMerchandiseDAO.getInstance().getByCode(dtsSession, merchandiseCode);
            if (merchandise != null) {
                merchandiseList.add(merchandise);
            } else {
                BcLogUtil.warning("\u5b58\u5728\u3057\u307e\u305b\u3093\u3002merchandiseCode=" + merchandiseCode);
            }
            ++i3;
        }
        return sb;
    }

    protected StringBuilder createListHtml(WbsArgument wcbArg, List<XsodMerchandise> merchandiseList) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcLogUtil.debug("merchandiseList.size()=" + merchandiseList.size());
        int i = 0;
        while (i < merchandiseList.size()) {
            XsodMerchandise merchandise = merchandiseList.get(i);
            sb.append((CharSequence)this.createElement(wcbArg, merchandise));
            sb.append(this.getHtmlBuilder().lineSep);
            ++i;
        }
        return sb;
    }

    protected StringBuilder createElement(WbsArgument wcbArg, XsodMerchandise merchandise) throws Exception {
        StringBuilder sb = new StringBuilder();
        String href1 = Method.marchandiseImage + "?" + (Object)((Object)Parm.imageId) + "=" + merchandise.imageFileName;
        String href2 = Method.marchandiseThumbnail + "?" + (Object)((Object)Parm.thumbnailId) + "=" + merchandise.imageFileName;
        String merchandiseName = XsodUtil.getName(merchandise, this.getLangCode(), true);
        sb.append((CharSequence)LightboxCreator.getInstance().popupImage(this.getHtmlBuilder(), href1, href2, null, merchandiseName));
        sb.append((CharSequence)MdlCreator.getInstance().card_title(merchandiseName));
        StringBuilder actions2 = new StringBuilder();
        Wbs1PersonBasic userPersonBasic = XwebUtil.getLoginPersonBasic(wcbArg, false);
        if (userPersonBasic != null) {
            String paramKey = XsysFieldKeyCreator.getInstance().createKey(XsodMerchandise.class, "code");
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1MarchandiseFormWCB.Method.form)) + "?" + paramKey + "=" + merchandise.code;
            String onclickAction = WbfJslUtil.locationHref(href);
            String editButton = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().edit, onclickAction);
            actions2.append(editButton);
        }
        if (XwebUtil.isAdmin(wcbArg)) {
            String button1 = MdcCreator.getInstance().button(HtmlConstants.HtmlButtonType.submit, "\u30ab\u30fc\u30c8\u306b\u5165\u308c\u308b", null, "cart", null, merchandise.code, false);
            actions2.append(button1);
        }
        if (!BcStringUtil.isEmpty(actions2)) {
            sb.append(MdcCreator.getInstance().cardActions(actions2.toString()));
        }
        sb = MdlCreator.getInstance().grid_cell_shadow(4, sb);
        return sb;
    }

    protected DefaultMutableTreeNode createTree(List<XsodCategory> categoryList) throws Exception {
        ArrayList<Map.Entry<Comparable, Comparable>> entryList = new ArrayList<Map.Entry<Comparable, Comparable>>();
        int i = 0;
        while (i < categoryList.size()) {
            XsodCategory category = categoryList.get(i);
            entryList.add(new AbstractMap.SimpleEntry<String, String>(category.code, category.parent_code));
            ++i;
        }
        DefaultMutableTreeNode treeNode = XsodUtil.createTree(entryList, (Comparable)((Object)"ROOT"));
        return treeNode;
    }

    public static StringBuilder getMarchandiseCodes(Map<String, XsodCategory> categoryMap, DefaultMutableTreeNode treeNode) {
        StringBuilder sb = new StringBuilder();
        List<Object> userObjectList = XsodUtil.toUserObjectList(treeNode);
        int i = 0;
        while (i < userObjectList.size()) {
            Object userObject = userObjectList.get(i);
            XsodCategory category = categoryMap.get(userObject);
            BcLogUtil.debug("category.namses[0]=" + category.names[0] + " merchandiseCodes=" + category.merchandiseCodes);
            BcStringUtil.appendExceptEmpty(sb, ",", category.merchandiseCodes);
            ++i;
        }
        return sb;
    }

    public void marchandiseImage(WbsArgument wcbArg) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String imageId = requestParameter.getAsString(Parm.imageId.name());
        BcLogUtil.debug("imageId=" + imageId);
        File dir = Wbs1ServerUtil.getInstance().getmMarchandiseIamgeDir();
        File file = new File(dir, imageId);
        BufferedImage bufferedImage = this.imageCash.getImage((Comparable)((Object)imageId), file);
        if (bufferedImage != null) {
            ImageIO.write((RenderedImage)bufferedImage, BcFileUtil.getExtention(file), (OutputStream)wcbArg.getResponse().getOutputStream());
        } else {
            wcbArg.getResponse().sendError(404);
        }
    }

    public void marchandiseThumbnail(WbsArgument wcbArg) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String thumbnailId = requestParameter.getAsString(Parm.thumbnailId.name());
        BcLogUtil.debug("thumbnailId=" + thumbnailId);
        File dir = Wbs1ServerUtil.getInstance().getmMarchandiseIamgeDir();
        File file = new File(dir, thumbnailId);
        BufferedImage bufferedImage = this.imageCash.getThumbnail((Comparable)((Object)thumbnailId), file);
        if (bufferedImage != null) {
            ImageIO.write((RenderedImage)bufferedImage, BcFileUtil.getExtention(file), (OutputStream)wcbArg.getResponse().getOutputStream());
        } else {
            wcbArg.getResponse().sendError(404);
        }
    }

    public static enum Method implements WbxPath
    {
        marchandiseList("marchandiseList"),
        marchandiseImage("marchandiseImage"),
        marchandiseThumbnail("marchandiseThumbnail");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1MarchandiseListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum Parm {
        imageId,
        thumbnailId;

    }
}

