/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.html;

import javax.servlet.http.HttpSession;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.scf4.model.ScfMenuContext;
import jp.co.extreme.swing.SwgTreeView;
import jp.co.extreme.swing.tree.BcTreeNode;
import jp.co.extreme.swing.tree.BcTreeUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import nlc.lib.tree.LbTreeModel;

public class WbfwListMenuHtmlBuilder {
    protected HtmlBuilder htmlBuilder = new HtmlBuilder();

    public StringBuilder treeMenuL1(WbsArgument wcbArg, SwgTreeView treeView, BcTreeNode treeNode) throws Exception {
        TreePath tmpTreePath;
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        HttpSession httpSession = wcbArg.getRequest().getSession(false);
        LbTreeModel treeModel = (LbTreeModel)treeView.getModel();
        String treeNodeIdStr = requestParameter.getAsString("treeNodeId");
        int selectedNodeId = -1;
        if (!BcStringUtil.isEmpty(treeNodeIdStr)) {
            selectedNodeId = BcNumberUtil.parseInt(treeNodeIdStr, -1);
            httpSession.setAttribute("preTreeNodeId", (Object)new Integer(selectedNodeId));
        } else {
            Integer tmpInt = (Integer)httpSession.getAttribute("preTreeNodeId");
            if (tmpInt != null) {
                selectedNodeId = tmpInt;
            }
        }
        BcTreeNode selectedTreeNode = BcTreeUtil.getNodeById(treeNode, selectedNodeId);
        if (selectedTreeNode != null && (tmpTreePath = new TreePath(treeModel.getPathToRoot(selectedTreeNode))).getPathCount() == 2) {
            BcTreeUtil.collapseAll(treeView);
        }
        StringBuilder sb = new StringBuilder(1024);
        TreePath treePath = new TreePath(treeModel.getPathToRoot(treeNode));
        this.treeMenuL2Pre(wcbArg, treeView, treeNode, treePath, selectedNodeId);
        if (treeView.isCollapsed(new TreePath(treeModel.getPathToRoot(treeNode)))) {
            treeView.expandPath(new TreePath(treeModel.getPathToRoot(treeNode)));
        }
        sb.append((CharSequence)this.treeMenuL2Main(wcbArg, treeView, treeNode, treePath, selectedNodeId));
        return sb;
    }

    protected void treeMenuL2Pre(WbsArgument wcbArg, SwgTreeView treeView, BcTreeNode treeNode, TreePath treePath, int selectedNodeId) throws Exception {
        LbTreeModel treeModel = (LbTreeModel)treeView.getModel();
        if (treeNode.transId == selectedNodeId) {
            if (treeView.isExpanded(treePath)) {
                treeView.collapsePath(treePath);
            } else {
                treeView.expandPath(treePath);
            }
        }
        int i = 0;
        while (i < treeNode.getChildCount()) {
            BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
            TreePath childTreePath = new TreePath(treeModel.getPathToRoot(childNode));
            this.treeMenuL2Pre(wcbArg, treeView, childNode, childTreePath, selectedNodeId);
            ++i;
        }
    }

    protected StringBuilder treeMenuL2Main(WbsArgument wcbArg, SwgTreeView treeView, BcTreeNode treeNode, TreePath treePath, int selectedNodeId) throws Exception {
        LbTreeModel treeModel = (LbTreeModel)treeView.getModel();
        StringBuilder sb = new StringBuilder(1024);
        sb.append((CharSequence)this.treeMenuL3(wcbArg, treeView, treeNode, selectedNodeId));
        if (!treeNode.isLeaf() && treeView.isExpanded(treePath)) {
            TreeNode[] treeNodes = treeModel.getPathToRoot(treeNode);
            if (treeNodes.length == 1) {
                sb.append(this.htmlBuilder.ul_start());
            } else if (treeNodes.length == 2) {
                sb.append(this.htmlBuilder.ul_start());
            }
            int i = 0;
            while (i < treeNode.getChildCount()) {
                BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
                TreePath childTreePath = new TreePath(treeModel.getPathToRoot(childNode));
                sb.append((CharSequence)this.treeMenuL2Main(wcbArg, treeView, childNode, childTreePath, selectedNodeId));
                ++i;
            }
            if (treeNodes.length == 1) {
                sb.append(this.htmlBuilder.ul_end());
            } else if (treeNodes.length == 2) {
                sb.append(this.htmlBuilder.ul_end());
            }
        }
        return sb;
    }

    protected StringBuilder treeMenuL3(WbsArgument wcbArg, SwgTreeView treeView, BcTreeNode treeNode, int selectedNodeId) throws Exception {
        LbTreeModel treeModel = (LbTreeModel)treeView.getModel();
        TreePath treePath = new TreePath(treeModel.getPathToRoot(treeNode));
        ScfMenuContext menuContext = (ScfMenuContext)treeNode.getUserObject();
        TreeNode[] treeNodes = treeModel.getPathToRoot(treeNode);
        StringBuilder sb = new StringBuilder(256);
        String cssClass = "";
        if (treeNodes.length != 1) {
            if (treeNodes.length == 2) {
                sb.append(this.htmlBuilder.li_start());
                cssClass = treeView.isExpanded(treePath) ? menuContext.getOpenCssClassName() : menuContext.getCloseCssClassName();
            } else if (treeNodes.length == 3) {
                sb.append(this.htmlBuilder.li_start());
                cssClass = treeNode.transId == selectedNodeId ? menuContext.getOpenCssClassName() : menuContext.getCloseCssClassName();
            }
            if (!BcStringUtil.isEmpty(menuContext.getUrl())) {
                if (!BcStringUtil.isEmpty(menuContext.getMenuImage())) {
                    sb.append((CharSequence)HtmlUtil.linkMenuWithImage(menuContext.getUrl(), null, null, cssClass, menuContext.getMenuImage(), menuContext.getMenuName()));
                } else {
                    sb.append((CharSequence)HtmlUtil.link2(menuContext.getUrl(), null, null, cssClass, menuContext.getMenuName()));
                }
            } else {
                sb.append(menuContext.getMenuName());
            }
            sb.append(this.htmlBuilder.li_end());
            sb.append("\n");
        }
        return sb;
    }
}

