/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.rsmn.fx;

import javafx.scene.Node;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.rsmn.model.RsmnMonitorResult;
import jp.co.extreme.module.rsmn.rmo.RsmnMonitorRMO;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;

class RsmnDatasourceMonitorPane
extends FxDecoratePane {
    protected FxFlowPane centerPane = new FxFlowPane(11);
    protected FxNumberField availableCountField = new FxNumberField();
    protected FxNumberField lendingCountField = new FxNumberField();
    BcThread thread;

    public RsmnDatasourceMonitorPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.availableCountField.setEditable(false);
        this.availableCountField.setPrefColumnCount(10);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("\u5229\u7528\u53ef\u80fd"), new Node[]{this.availableCountField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.lendingCountField.setEditable(false);
        this.lendingCountField.setPrefColumnCount(10);
        nodeUnit = new FxNodeUnit((Node)new FxLabel("\u8cb8\u51fa\u4e2d"), new Node[]{this.lendingCountField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
        this.thread = new InnerThread();
        this.thread.startThread();
    }

    protected void getData() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(RsmnMonitorRMO.class.getName());
        rmiReq.setMethodName("getDatasourceInfo");
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        RsmnMonitorResult monitorResult = (RsmnMonitorResult)rmiRes.getData();
        this.availableCountField.setValue(monitorResult.availableCount);
        this.lendingCountField.setValue(monitorResult.lendingCount);
    }

    class InnerThread
    extends BcThread {
        public InnerThread() {
            this.setPriority(1);
        }

        @Override
        protected void run2() throws Exception {
            try {
                RsmnDatasourceMonitorPane.this.getData();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

