/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.conp.wcb;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.conp.dao.ConpGameDAO;
import jp.co.extreme.module.conp.dao.ConpPlayerDAO;
import jp.co.extreme.module.conp.dao.ConpScoreDAO;
import jp.co.extreme.module.conp.dao.ConpTournamentDAO;
import jp.co.extreme.module.conp.model.ConpGame;
import jp.co.extreme.module.conp.model.ConpPlayer;
import jp.co.extreme.module.conp.model.ConpScore;
import jp.co.extreme.module.conp.model.ConpTournament;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.WbsHtmlTableCreator;
import jp.co.extreme.module.xweb.common.HtmlTableModelForBcTable;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class ConpTestWCB
extends Wbs1AbstractWCB {
    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        int tournamentId = 1;
        ConpTournament tournament = (ConpTournament)ConpTournamentDAO.getInstance().getById(dtsSessionSite, tournamentId);
        StringBuilder sb = this.tournament(wcbArg, dtsSessionSite, tournament);
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    protected StringBuilder tournament(WbsArgument wcbArg, DtsSession dtsSessionSite, ConpTournament tournament) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().p(tournament.name, true));
        List gameList = ConpGameDAO.getInstance().getListByTournamentId(dtsSessionSite, tournament.id);
        BcTableModel tableModel = new BcTableModel();
        ArrayList<Long> playerIdList = new ArrayList<Long>();
        int i = 0;
        while (i < gameList.size()) {
            ConpGame game = (ConpGame)gameList.get(i);
            List scoreList = ConpScoreDAO.getInstance().getListByGameId(dtsSessionSite, game.id);
            ArrayList row = new ArrayList();
            int j = 0;
            while (j < scoreList.size()) {
                ConpScore score = (ConpScore)scoreList.get(j);
                int columnId = playerIdList.indexOf(score.playerId);
                this.getLogger().debug("columnId=" + columnId);
                if (columnId < 0) {
                    ConpPlayer player = (ConpPlayer)ConpPlayerDAO.getInstance().getById(dtsSessionSite, score.playerId);
                    playerIdList.add(player.id);
                    BcTableColumn tableColum = new BcTableColumn();
                    tableColum.setHeaderValue(player);
                    tableModel.addColumn(tableColum);
                    columnId = tableModel.getColumnCount() - 1;
                }
                BcCollectionUtil.setElement(row, columnId, score);
                ++j;
            }
            tableModel.addRow(row);
            ++i;
        }
        BcTableUtil.adjustToColmnCount(tableModel, null);
        ArrayList<Integer> row = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < tableModel.getColumnCount()) {
            int sum = 0;
            int j = 0;
            while (j < tableModel.getRowCount()) {
                ConpScore score = (ConpScore)tableModel.getValueAt(j, i2);
                if (score != null) {
                    sum += score.score;
                }
                ++j;
            }
            row.add(sum);
            ++i2;
        }
        tableModel.addRow(row);
        sb.append(this.createScoreTable(wcbArg, tableModel));
        return sb;
    }

    protected String createScoreTable(WbsArgument wcbArg, BcTableModel tableModel) throws Exception {
        InnerHtmlTableModel htmlTableModel = new InnerHtmlTableModel();
        htmlTableModel.setTableModel(tableModel);
        InnerHtmlTableCreator htmlTableCreator = new InnerHtmlTableCreator(wcbArg);
        htmlTableCreator.setTableModel(htmlTableModel);
        return htmlTableCreator.create(wcbArg);
    }

    class InnerHtmlTableCreator
    extends WbsHtmlTableCreator {
        WbsArgument wcbArg;

        public InnerHtmlTableCreator(WbsArgument wcbArg) {
            this.wcbArg = wcbArg;
        }
    }

    class InnerHtmlTableModel
    extends HtmlTableModelForBcTable {
        InnerHtmlTableModel() {
        }

        @Override
        public int getRowCount() throws Exception {
            return this.getTableModel().getRowCount() - 1;
        }

        @Override
        public String getHeaderValue(int columnId) throws Exception {
            BcTableColumn tableColumn = (BcTableColumn)this.getTableModel().getTableColumnModel().getColumn(columnId);
            ConpPlayer player = (ConpPlayer)tableColumn.getHeaderValue();
            return player.name;
        }

        @Override
        public String getCellValue(int rowId, int columnId) throws Exception {
            ConpScore score = (ConpScore)this.getTableModel().getValueAt(rowId, columnId);
            String cellValue = null;
            if (score != null) {
                cellValue = BcStringUtil.toString(score.score);
            }
            return cellValue;
        }

        @Override
        public String getFooterValue(int columnId) throws Exception {
            int rowId = this.getTableModel().getRowCount() - 1;
            Number number = (Number)this.getTableModel().getValueAt(rowId, columnId);
            return number.toString();
        }
    }

    public static enum Method implements WbxPath
    {
        form("score");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return ConpTestWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

