/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.html.mdc;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.lib.html.mdl.MdlConstants;
import jp.co.extreme.lib.html.mdl.MdlCreator;

public class MdcConstants {
    static HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    public static final int ICON_SIZE_18 = 18;
    public static final int ICON_SIZE_24 = 24;
    public static final int ICON_SIZE_36 = 36;
    public static final int ICON_SIZE_48 = 48;

    private MdcConstants() {
    }

    public static String icon(MdcIcon mdcIcon, int size, MdlConstants.MdlColor color, MdlConstants.MdlColorNum colorNum) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        String iconsClass = "material-icons";
        if (size > 0) {
            iconsClass = String.valueOf(iconsClass) + " md-" + size;
        }
        String colorText = MdlCreator.getInstance().colorText(color, colorNum);
        globalAttribute.clazz = BcStringUtil.toSsv(iconsClass, colorText);
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)htmlBuilder.span_start(globalAttribute));
        BcStringUtil.append(sb, mdcIcon.name());
        sb.append(htmlBuilder.span_end(true));
        return sb.toString();
    }

    public static String icon(MdcIcon icon, int size) throws Exception {
        return MdcConstants.icon(icon, size, MdlConstants.MdlColor.pink, MdlConstants.MdlColorNum.n100);
    }

    public static enum MdcClass {
        mdc_button("mdc-button"),
        mdc_button__raised("mdc-button--raised"),
        mdc_card("mdc-card"),
        mdc_card__action("mdc-card__action"),
        mdc_card__actions("mdc-card__actions"),
        mdc_card__action__button("mdc-card__action--button"),
        mdc_text_field("mdc-text-field"),
        mdc_text_field__dense("mdc-text-field--dense"),
        mdc_text_field__outlined("mdc-text-field--outlined"),
        mdc_text_field__icon("mdc-text-field__icon"),
        mdc_text_field__icon__leading("mdc-text-field__icon--leading"),
        mdc_text_field__icon__trailing("mdc-text-field__icon--trailing"),
        mdc_text_field__with_leading_icon("mdc-text-field--with-leading-icon"),
        mdc_text_field__with_trailing_icon("mdc-text-field--with-trailing-icon"),
        mdc_text_field_helper_line("mdc-text-field-helper-line"),
        mdc_text_field_helper_text("mdc-text-field-helper-text"),
        mdc_text_field_helper_text__persistent("mdc-text-field-helper-text--persistent"),
        mdc_text_field_character_counter("mdc-text-field-character-counter"),
        mdc_notched_outline("mdc-notched-outline"),
        mdc_notched_outline__leading("mdc-notched-outline__leading"),
        mdc_notched_outline__notch("mdc-notched-outline__notch"),
        mdc_notched_outline__trailing("mdc-notched-outline__trailing"),
        mdc_floating_label("mdc-floating-label"),
        mdc_line_ripple("mdc-line-ripple");

        public final String value;

        private MdcClass(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum MdcIcon {
        email,
        error,
        face,
        help,
        home,
        login,
        logout,
        menu,
        password,
        person,
        place,
        search,
        security,
        settings;

    }
}

