/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.http;

import jp.co.extreme.base.core.BcStringUtil;

public class HttpConstants {
    public static final String BOUNDARY = "boundary";
    public static final String MOBILE_ENCODING = "Windows-31J";
    public static final String USER_AGENT_docomo = "DoCoMo";
    public static final String USER_AGENT_vodafone = "Vodafone";
    public static final String USER_AGENT_jPhone = "J-PHONE";
    public static final String USER_AGENT_softBank = "SoftBank";
    public static final String USER_AGENT_motorola = "MOT";
    public static final String USER_AGENT_kddi = "KDDI";
    public static final String USER_AGENT_upBrower = "UP.Browser";
    public static String[] MOBILE_USER_AGENT = new String[]{"DoCoMo", "Vodafone", "J-PHONE", "SoftBank", "MOT", "KDDI", "UP.Browser"};

    private HttpConstants() {
    }

    public static boolean isMobile(String userAgent) throws Exception {
        if (BcStringUtil.isEmpty(userAgent)) {
            return false;
        }
        boolean mobile = false;
        int i = 0;
        while (i < MOBILE_USER_AGENT.length) {
            if (userAgent.startsWith(MOBILE_USER_AGENT[i])) {
                mobile = true;
                break;
            }
            ++i;
        }
        return mobile;
    }

    public final class ContentType {
        public static final String text_plain = "text/plain";
        public static final String text_html = "text/html";
        public static final String text_css = "text/css";
        public static final String text_javascript = "text/javascript";
        public static final String application_zip = "application/zip";
        public static final String application_x_lzh = "application/x-lzh";
        public static final String application_x_tar = "application/x-tar";
        public static final String image_jpeg = "image/jpeg";
        public static final String image_png = "image/png";
        public static final String image_gif = "image/gif";
        public static final String image_bmp = "image/bmp";
        public static final String audio_mpeg = "audio/mpeg";
        public static final String audio_mp4 = "audio/mp4";
        public static final String video_mpeg = "video/mpeg";
        public static final String multipart_form_data = "multipart/form-data";
        public static final String application_x_www_form_urlencoded = "application/x-www-form-urlencoded";
        public static final String application_octet_stream = "application/octet-stream";
        public static final String application_pdf = "application/pdf";
        public static final String application_vnd_ms_excel = "application/vnd.ms-excel";
        public static final String application_vnd_ms_powerpoint = "application/vnd.ms-powerpoint";
        public static final String application_msword = "application/msword";
    }

    public final class Header {
        public static final String Content_Type = "Content-Type";
        public static final String Date = "Date";
        public static final String Expires = "Expires";
        public static final String Cache_Control = "Cache-Control";
        public static final String Content_Encoding = "Content-Encoding";
        public static final String Content_Location = "Content-Location";
        public static final String Server = "Server";
        public static final String Content_Length = "Content-Length";
        public static final String X_XSS_Protection = "X-XSS-Protection";
        public static final String ETag = "ETag";
        public static final String Content_Disposition = "Content-Disposition";
    }

    public final class Method {
        public static final String GET = "GET";
        public static final String POST = "POST";
        public static final String HEAD = "HEAD";
        public static final String PUT = "PUT";
        public static final String DELETE = "DELETE";
        public static final String TRACE = "TRACE";
    }

    public static enum RequestHeader {
        Accept("Accept"),
        Accept_Charset("Accept-Charset"),
        Accept_Encoding("Accept-Encoding"),
        Accept_Language("Accept-Language"),
        Cookie("Cookie"),
        Connection("Connection"),
        Host("Host"),
        Keep_Alive("Keep-Alive"),
        Range("Range"),
        Referer("Referer"),
        User_Agent("User-Agent"),
        X_Forwarded_For("X-Forwarded-For");

        public final String value;

        private RequestHeader(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public final class UserAgent {
        public static final String Chrome_36 = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.125 Safari/537.36";
        public static final String Safari_5 = "Mozilla/5.0 (Windows; U; Windows NT 5.1; ja-JP) AppleWebKit/533.18.1 (KHTML, like Gecko) Version/5.0 Safari/533.16";
        public static final String Firefox_30 = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:30.0) Gecko/20100101 Firefox/30.0";
        public static final String Opera_22 = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.153 Safari/537.36 OPR/22.0.1471.70";
        public static final String IE_11 = "Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko";
    }
}

