/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.comm;

import java.util.Map;
import java.util.Properties;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.comm.CommSerialConstants;
import jp.co.extreme.comm.CommSerialParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommSerialUtil {
    private CommSerialUtil() {
    }

    public static String getEvenText(int evType) {
        switch (evType) {
            case 10: {
                return "Break interrupt";
            }
            case 6: {
                return "Carrier detect";
            }
            case 3: {
                return "Clear to send";
            }
            case 4: {
                return "Data set ready";
            }
            case 9: {
                return "Framing error";
            }
            case 2: {
                return "Output buffer is empty";
            }
            case 8: {
                return "Parity error";
            }
            case 5: {
                return "Ring indicator";
            }
        }
        return "unknown event:" + evType;
    }

    public static void setSerialParameters(CommSerialParameters serialParameters, Map map) throws Exception {
        serialParameters.setPortName(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.portName.name())));
        serialParameters.setBaudRate(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.baudRate.name())));
        serialParameters.setDataBits(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.dataBits.name())));
        serialParameters.setStopBits(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.stopBits.name())));
        serialParameters.setParity(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.parity.name())));
        serialParameters.setFlowControlIn(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.flowControlIn.name())));
        serialParameters.setFlowControlOut(BcStringUtil.toString(map.get(CommSerialConstants.SerialPortProperty.flowControlOut.name())));
    }

    public static CommSerialParameters createSerialParameters(Map map) throws Exception {
        CommSerialParameters serialParameters = new CommSerialParameters();
        CommSerialUtil.setSerialParameters(serialParameters, map);
        return serialParameters;
    }

    public static void toSerialParameters(Properties props, CommSerialParameters serialParameters) throws Exception {
        serialParameters.setPortName((String)props.get("portName"));
        serialParameters.setBaudRate((String)props.get("baudRate"));
        serialParameters.setDataBits((String)props.get("dataBits"));
        serialParameters.setStopBits((String)props.get("stopBits"));
        serialParameters.setParity((String)props.get("parity"));
        serialParameters.setFlowControlIn((String)props.get("flowControlIn"));
        serialParameters.setFlowControlOut((String)props.get("flowControlOut"));
    }

    public static void toProperties(CommSerialParameters serialParameters, Properties props) {
        props.put("portName", serialParameters.getPortName());
        props.put("baudRate", serialParameters.getBaudRateString());
        props.put("dataBits", serialParameters.getDataBitsString());
        props.put("stopBits", serialParameters.getStopBitsString());
        props.put("parity", serialParameters.getParityString());
        props.put("flowControlIn", serialParameters.getFlowControlInString());
        props.put("flowControlOut", serialParameters.getFlowControlOutString());
    }

    public static void parseSerialPort(Node domNode, CommSerialParameters serialParam) throws Exception {
        NodeList domNodeList = domNode.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            String textVal;
            Node domNode2 = domNodeList.item(i);
            if (domNode2.getNodeName().equals("portName")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setPortName(textVal);
            } else if (domNode2.getNodeName().equals("baudRate")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setBaudRate(textVal);
            } else if (domNode2.getNodeName().equals("dataBits")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setDataBits(textVal);
            } else if (domNode2.getNodeName().equals("stopBits")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setStopBits(textVal);
            } else if (domNode2.getNodeName().equals("parity")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setParity(textVal);
            } else if (domNode2.getNodeName().equals("flowControlIn")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setFlowControlIn(textVal);
            } else if (domNode2.getNodeName().equals("flowControlOut")) {
                textVal = BcXmlUtil.getValue(domNode2, 3, "");
                serialParam.setFlowControlOut(textVal);
            }
            ++i;
        }
    }

    public static Node createSerialPortNodes(CommSerialParameters serialParam, Node parentNode) throws Exception {
        Document domDoc = parentNode.getOwnerDocument();
        Node node1 = BcXmlUtil.getFirstNode(parentNode, "serialPort");
        if (node1 == null) {
            node1 = domDoc.createElement("serialPort");
        }
        BcXmlUtil.deleteAllChild(node1);
        parentNode.appendChild(node1);
        BcXmlUtil.setTextValue(node1, "portName", serialParam.getPortName());
        BcXmlUtil.setTextValue(node1, "baudRate", serialParam.getBaudRateString());
        BcXmlUtil.setTextValue(node1, "dataBits", serialParam.getDataBitsString());
        BcXmlUtil.setTextValue(node1, "stopBits", serialParam.getStopBitsString());
        BcXmlUtil.setTextValue(node1, "parity", serialParam.getParityString());
        BcXmlUtil.setTextValue(node1, "flowControlIn", serialParam.getFlowControlInString());
        BcXmlUtil.setTextValue(node1, "flowControlOut", serialParam.getFlowControlOutString());
        return node1;
    }
}

