/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.DEREncodedKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoReference;
import com.sun.org.apache.xml.internal.security.keys.content.KeyName;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.MgmtData;
import com.sun.org.apache.xml.internal.security.keys.content.PGPData;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.content.SPKIData;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfo
extends SignatureElementProxy {
    private static final Logger LOG = LoggerFactory.getLogger(KeyInfo.class);
    private List<X509Data> x509Datas;
    private static final List<StorageResolver> nullList;
    private List<StorageResolver> storageResolvers = nullList;
    private List<KeyResolverSpi> internalKeyResolvers = new ArrayList<KeyResolverSpi>();
    private boolean secureValidation;

    public KeyInfo(Document document) {
        super(document);
        this.addReturnToSelf();
        String string = ElementProxy.getDefaultPrefix(this.getBaseNamespace());
        if (string != null && string.length() > 0) {
            this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, this.getBaseNamespace());
        }
    }

    public KeyInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
    }

    public void setSecureValidation(boolean bl) {
        this.secureValidation = bl;
    }

    public void setId(String string) {
        if (string != null) {
            this.setLocalIdAttribute("Id", string);
        }
    }

    public String getId() {
        return this.getLocalAttribute("Id");
    }

    public void addKeyName(String string) {
        this.add(new KeyName(this.getDocument(), string));
    }

    public void add(KeyName keyName) {
        this.appendSelf(keyName);
        this.addReturnToSelf();
    }

    public void addKeyValue(PublicKey publicKey) {
        this.add(new KeyValue(this.getDocument(), publicKey));
    }

    public void addKeyValue(Element element) {
        this.add(new KeyValue(this.getDocument(), element));
    }

    public void add(DSAKeyValue dSAKeyValue) {
        this.add(new KeyValue(this.getDocument(), dSAKeyValue));
    }

    public void add(RSAKeyValue rSAKeyValue) {
        this.add(new KeyValue(this.getDocument(), rSAKeyValue));
    }

    public void add(PublicKey publicKey) {
        this.add(new KeyValue(this.getDocument(), publicKey));
    }

    public void add(KeyValue keyValue) {
        this.appendSelf(keyValue);
        this.addReturnToSelf();
    }

    public void addMgmtData(String string) {
        this.add(new MgmtData(this.getDocument(), string));
    }

    public void add(MgmtData mgmtData) {
        this.appendSelf(mgmtData);
        this.addReturnToSelf();
    }

    public void add(PGPData pGPData) {
        this.appendSelf(pGPData);
        this.addReturnToSelf();
    }

    public void addRetrievalMethod(String string, Transforms transforms, String string2) {
        this.add(new RetrievalMethod(this.getDocument(), string, transforms, string2));
    }

    public void add(RetrievalMethod retrievalMethod) {
        this.appendSelf(retrievalMethod);
        this.addReturnToSelf();
    }

    public void add(SPKIData sPKIData) {
        this.appendSelf(sPKIData);
        this.addReturnToSelf();
    }

    public void add(X509Data x509Data) {
        if (this.x509Datas == null) {
            this.x509Datas = new ArrayList<X509Data>();
        }
        this.x509Datas.add(x509Data);
        this.appendSelf(x509Data);
        this.addReturnToSelf();
    }

    public void addDEREncodedKeyValue(PublicKey publicKey) throws XMLSecurityException {
        this.add(new DEREncodedKeyValue(this.getDocument(), publicKey));
    }

    public void add(DEREncodedKeyValue dEREncodedKeyValue) {
        this.appendSelf(dEREncodedKeyValue);
        this.addReturnToSelf();
    }

    public void addKeyInfoReference(String string) throws XMLSecurityException {
        this.add(new KeyInfoReference(this.getDocument(), string));
    }

    public void add(KeyInfoReference keyInfoReference) {
        this.appendSelf(keyInfoReference);
        this.addReturnToSelf();
    }

    public void addUnknownElement(Element element) {
        this.appendSelf(element);
        this.addReturnToSelf();
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        if (this.x509Datas != null) {
            return this.x509Datas.size();
        }
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthDEREncodedKeyValue() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "DEREncodedKeyValue");
    }

    public int lengthKeyInfoReference() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "KeyInfoReference");
    }

    public int lengthUnknownElement() {
        int n = 0;
        for (Node node = this.getElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++n;
        }
        return n;
    }

    public KeyName itemKeyName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "KeyName", n);
        if (element != null) {
            return new KeyName(element, this.baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "KeyValue", n);
        if (element != null) {
            return new KeyValue(element, this.baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "MgmtData", n);
        if (element != null) {
            return new MgmtData(element, this.baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "PGPData", n);
        if (element != null) {
            return new PGPData(element, this.baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "RetrievalMethod", n);
        if (element != null) {
            return new RetrievalMethod(element, this.baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "SPKIData", n);
        if (element != null) {
            return new SPKIData(element, this.baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int n) throws XMLSecurityException {
        if (this.x509Datas != null) {
            return this.x509Datas.get(n);
        }
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "X509Data", n);
        if (element != null) {
            return new X509Data(element, this.baseURI);
        }
        return null;
    }

    public DEREncodedKeyValue itemDEREncodedKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDs11Node(this.getFirstChild(), "DEREncodedKeyValue", n);
        if (element != null) {
            return new DEREncodedKeyValue(element, this.baseURI);
        }
        return null;
    }

    public KeyInfoReference itemKeyInfoReference(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDs11Node(this.getFirstChild(), "KeyInfoReference", n);
        if (element != null) {
            return new KeyInfoReference(element, this.baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        int n2 = 0;
        for (Node node = this.getElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++n2 != n) continue;
            return (Element)node;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public boolean containsDEREncodedKeyValue() {
        return this.lengthDEREncodedKeyValue() > 0;
    }

    public boolean containsKeyInfoReference() {
        return this.lengthKeyInfoReference() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey publicKey = this.getPublicKeyFromInternalResolvers();
        if (publicKey != null) {
            LOG.debug("I could find a key using the per-KeyInfo key resolvers");
            return publicKey;
        }
        LOG.debug("I couldn't find a key using the per-KeyInfo key resolvers");
        publicKey = this.getPublicKeyFromStaticResolvers();
        if (publicKey != null) {
            LOG.debug("I could find a key using the system-wide key resolvers");
            return publicKey;
        }
        LOG.debug("I couldn't find a key using the system-wide key resolvers");
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            String string = this.getBaseURI();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    PublicKey publicKey = keyResolverSpi.engineLookupAndResolvePublicKey((Element)node, string, storageResolver, this.secureValidation);
                    if (publicKey == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            LOG.debug("Try {}", keyResolverSpi.getClass().getName());
            String string = this.getBaseURI();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    PublicKey publicKey = keyResolverSpi.engineLookupAndResolvePublicKey((Element)node, string, storageResolver, this.secureValidation);
                    if (publicKey == null) continue;
                    return publicKey;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate x509Certificate = this.getX509CertificateFromInternalResolvers();
        if (x509Certificate != null) {
            LOG.debug("I could find a X509Certificate using the per-KeyInfo key resolvers");
            return x509Certificate;
        }
        LOG.debug("I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        x509Certificate = this.getX509CertificateFromStaticResolvers();
        if (x509Certificate != null) {
            LOG.debug("I could find a X509Certificate using the system-wide key resolvers");
            return x509Certificate;
        }
        LOG.debug("I couldn't find a X509Certificate using the system-wide key resolvers");
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        LOG.debug("Start getX509CertificateFromStaticResolvers() with {} resolvers", KeyResolver.length());
        String string = this.getBaseURI();
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            X509Certificate x509Certificate = this.applyCurrentResolver(string, keyResolverSpi);
            if (x509Certificate == null) continue;
            return x509Certificate;
        }
        return null;
    }

    private X509Certificate applyCurrentResolver(String string, KeyResolverSpi keyResolverSpi) throws KeyResolverException {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            for (StorageResolver storageResolver : this.storageResolvers) {
                X509Certificate x509Certificate = keyResolverSpi.engineLookupResolveX509Certificate((Element)node, string, storageResolver, this.secureValidation);
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        LOG.debug("Start getX509CertificateFromInternalResolvers() with {} resolvers", this.lengthInternalKeyResolver());
        String string = this.getBaseURI();
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            LOG.debug("Try {}", keyResolverSpi.getClass().getName());
            X509Certificate x509Certificate = this.applyCurrentResolver(string, keyResolverSpi);
            if (x509Certificate == null) continue;
            return x509Certificate;
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey secretKey = this.getSecretKeyFromInternalResolvers();
        if (secretKey != null) {
            LOG.debug("I could find a secret key using the per-KeyInfo key resolvers");
            return secretKey;
        }
        LOG.debug("I couldn't find a secret key using the per-KeyInfo key resolvers");
        secretKey = this.getSecretKeyFromStaticResolvers();
        if (secretKey != null) {
            LOG.debug("I could find a secret key using the system-wide key resolvers");
            return secretKey;
        }
        LOG.debug("I couldn't find a secret key using the system-wide key resolvers");
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            String string = this.getBaseURI();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    SecretKey secretKey = keyResolverSpi.engineLookupAndResolveSecretKey((Element)node, string, storageResolver, this.secureValidation);
                    if (secretKey == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            LOG.debug("Try {}", keyResolverSpi.getClass().getName());
            String string = this.getBaseURI();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                for (StorageResolver storageResolver : this.storageResolvers) {
                    SecretKey secretKey = keyResolverSpi.engineLookupAndResolveSecretKey((Element)node, string, storageResolver, this.secureValidation);
                    if (secretKey == null) continue;
                    return secretKey;
                }
            }
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws KeyResolverException {
        PrivateKey privateKey = this.getPrivateKeyFromInternalResolvers();
        if (privateKey != null) {
            LOG.debug("I could find a private key using the per-KeyInfo key resolvers");
            return privateKey;
        }
        LOG.debug("I couldn't find a secret key using the per-KeyInfo key resolvers");
        privateKey = this.getPrivateKeyFromStaticResolvers();
        if (privateKey != null) {
            LOG.debug("I could find a private key using the system-wide key resolvers");
            return privateKey;
        }
        LOG.debug("I couldn't find a private key using the system-wide key resolvers");
        return null;
    }

    PrivateKey getPrivateKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> iterator = KeyResolver.iterator();
        while (iterator.hasNext()) {
            KeyResolverSpi keyResolverSpi = iterator.next();
            String string = this.getBaseURI();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                PrivateKey privateKey;
                if (node.getNodeType() != 1 || (privateKey = keyResolverSpi.engineLookupAndResolvePrivateKey((Element)node, string, null, this.secureValidation)) == null) continue;
                return privateKey;
            }
        }
        return null;
    }

    PrivateKey getPrivateKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : this.internalKeyResolvers) {
            LOG.debug("Try {}", keyResolverSpi.getClass().getName());
            String string = this.getBaseURI();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                PrivateKey privateKey;
                if (node.getNodeType() != 1 || (privateKey = keyResolverSpi.engineLookupAndResolvePrivateKey((Element)node, string, null, this.secureValidation)) == null) continue;
                return privateKey;
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        this.internalKeyResolvers.add(keyResolverSpi);
    }

    int lengthInternalKeyResolver() {
        return this.internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int n) {
        return this.internalKeyResolvers.get(n);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (this.storageResolvers == nullList) {
            this.storageResolvers = new ArrayList<StorageResolver>();
        }
        this.storageResolvers.add(storageResolver);
    }

    @Override
    public String getBaseLocalName() {
        return "KeyInfo";
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(null);
        nullList = Collections.unmodifiableList(arrayList);
    }
}

