/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PackageReader
extends BandStructure {
    Package pkg;
    byte[] bytes;
    LimitedBuffer in;
    Package.Version packageVersion;
    int[] tagCount = new int[19];
    int numFiles;
    int numAttrDefs;
    int numInnerClasses;
    int numClasses;
    static final int MAGIC_BYTES = 4;
    Map<ConstantPool.Utf8Entry, ConstantPool.SignatureEntry> utf8Signatures;
    static final int NO_FLAGS_YET = 0;
    Comparator<ConstantPool.Entry> entryOutputOrder = new Comparator<ConstantPool.Entry>(){

        @Override
        public int compare(ConstantPool.Entry entry, ConstantPool.Entry entry2) {
            int n = PackageReader.this.getOutputIndex(entry);
            int n2 = PackageReader.this.getOutputIndex(entry2);
            if (n >= 0 && n2 >= 0) {
                return n - n2;
            }
            if (n == n2) {
                return entry.compareTo(entry2);
            }
            return n >= 0 ? -1 : 1;
        }
    };
    Code[] allCodes;
    List<Code> codesWithFlags;
    Map<Package.Class, Set<ConstantPool.Entry>> ldcRefMap = new HashMap<Package.Class, Set<ConstantPool.Entry>>();

    PackageReader(Package package_, InputStream inputStream) throws IOException {
        this.pkg = package_;
        this.in = new LimitedBuffer(inputStream);
    }

    void read() throws IOException {
        boolean bl = false;
        try {
            this.readFileHeader();
            this.readBandHeaders();
            this.readConstantPool();
            this.readAttrDefs();
            this.readInnerClasses();
            Package.Class[] classArray = this.readClasses();
            this.readByteCodes();
            this.readFiles();
            assert (this.archiveSize1 == 0L || this.in.atLimit());
            assert (this.archiveSize1 == 0L || this.in.getBytesServed() == this.archiveSize0 + this.archiveSize1);
            this.all_bands.doneDisbursing();
            for (int i = 0; i < classArray.length; ++i) {
                this.reconstructClass(classArray[i]);
            }
            bl = true;
        }
        catch (Exception exception) {
            Utils.log.warning("Error on input: " + exception, exception);
            if (this.verbose > 0) {
                Utils.log.info("Stream offsets: served=" + this.in.getBytesServed() + " buffered=" + this.in.buffered + " limit=" + this.in.limit);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("error unpacking", exception);
        }
    }

    void readFileHeader() throws IOException {
        this.readArchiveMagic();
        this.readArchiveHeader();
    }

    private int getMagicInt32() throws IOException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n |= this.archive_magic.getByte() & 0xFF;
        }
        return n;
    }

    void readArchiveMagic() throws IOException {
        this.in.setReadLimit(19L);
        this.archive_magic.expectLength(4);
        this.archive_magic.readFrom(this.in);
        int n = this.getMagicInt32();
        if (this.pkg.magic != n) {
            throw new IOException("Unexpected package magic number: got " + n + "; expected " + this.pkg.magic);
        }
        this.archive_magic.doneDisbursing();
    }

    void checkArchiveVersion() throws IOException {
        Package.Version version = null;
        for (Package.Version version2 : new Package.Version[]{Constants.JAVA8_PACKAGE_VERSION, Constants.JAVA7_PACKAGE_VERSION, Constants.JAVA6_PACKAGE_VERSION, Constants.JAVA5_PACKAGE_VERSION}) {
            if (!this.packageVersion.equals(version2)) continue;
            version = version2;
            break;
        }
        if (version == null) {
            String string = Constants.JAVA8_PACKAGE_VERSION.toString() + "OR" + Constants.JAVA7_PACKAGE_VERSION.toString() + " OR " + Constants.JAVA6_PACKAGE_VERSION.toString() + " OR " + Constants.JAVA5_PACKAGE_VERSION.toString();
            throw new IOException("Unexpected package minor version: got " + this.packageVersion.toString() + "; expected " + string);
        }
    }

    void readArchiveHeader() throws IOException {
        this.archive_header_0.expectLength(3);
        this.archive_header_0.readFrom(this.in);
        int n = this.archive_header_0.getInt();
        int n2 = this.archive_header_0.getInt();
        this.packageVersion = Package.Version.of(n2, n);
        this.checkArchiveVersion();
        this.initHighestClassVersion(Constants.JAVA7_MAX_CLASS_VERSION);
        this.archiveOptions = this.archive_header_0.getInt();
        this.archive_header_0.doneDisbursing();
        boolean bl = PackageReader.testBit(this.archiveOptions, 1);
        boolean bl2 = PackageReader.testBit(this.archiveOptions, 16);
        boolean bl3 = PackageReader.testBit(this.archiveOptions, 2);
        boolean bl4 = PackageReader.testBit(this.archiveOptions, 8);
        this.initAttrIndexLimit();
        this.archive_header_S.expectLength(bl2 ? 2 : 0);
        this.archive_header_S.readFrom(this.in);
        if (bl2) {
            long l = this.archive_header_S.getInt();
            long l2 = this.archive_header_S.getInt();
            this.archiveSize1 = (l << 32) + (l2 << 32 >>> 32);
            this.in.setReadLimit(this.archiveSize1);
        } else {
            this.archiveSize1 = 0L;
            this.in.setReadLimit(-1L);
        }
        this.archive_header_S.doneDisbursing();
        this.archiveSize0 = this.in.getBytesServed();
        int n3 = 10;
        if (bl2) {
            n3 += 5;
        }
        if (bl) {
            n3 += 2;
        }
        if (bl3) {
            n3 += 4;
        }
        if (bl4) {
            n3 += 4;
        }
        this.archive_header_1.expectLength(n3);
        this.archive_header_1.readFrom(this.in);
        if (bl2) {
            this.archiveNextCount = this.archive_header_1.getInt();
            this.pkg.default_modtime = this.archive_header_1.getInt();
            this.numFiles = this.archive_header_1.getInt();
        } else {
            this.archiveNextCount = 0;
            this.numFiles = 0;
        }
        if (bl) {
            this.band_headers.expectLength(this.archive_header_1.getInt());
            this.numAttrDefs = this.archive_header_1.getInt();
        } else {
            this.band_headers.expectLength(0);
            this.numAttrDefs = 0;
        }
        this.readConstantPoolCounts(bl3, bl4);
        this.numInnerClasses = this.archive_header_1.getInt();
        n = (short)this.archive_header_1.getInt();
        n2 = (short)this.archive_header_1.getInt();
        this.pkg.defaultClassVersion = Package.Version.of(n2, n);
        this.numClasses = this.archive_header_1.getInt();
        this.archive_header_1.doneDisbursing();
        if (PackageReader.testBit(this.archiveOptions, 32)) {
            this.pkg.default_options |= 1;
        }
    }

    void readBandHeaders() throws IOException {
        this.band_headers.readFrom(this.in);
        this.bandHeaderBytePos = 1;
        this.bandHeaderBytes = new byte[this.bandHeaderBytePos + this.band_headers.length()];
        for (int i = this.bandHeaderBytePos; i < this.bandHeaderBytes.length; ++i) {
            this.bandHeaderBytes[i] = (byte)this.band_headers.getByte();
        }
        this.band_headers.doneDisbursing();
    }

    /*
     * Unable to fully structure code
     */
    void readConstantPoolCounts(boolean var1_1, boolean var2_2) throws IOException {
        block6: for (var3_3 = 0; var3_3 < ConstantPool.TAGS_IN_ORDER.length; ++var3_3) {
            var4_4 = ConstantPool.TAGS_IN_ORDER[var3_3];
            if (var1_1) ** GOTO lbl-1000
            switch (var4_4) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block6;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!var2_2) {
                        switch (var4_4) {
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: {
                                continue block6;
                            }
                        }
                    }
                    this.tagCount[var4_4] = this.archive_header_1.getInt();
                }
            }
        }
    }

    @Override
    protected ConstantPool.Index getCPIndex(byte by) {
        return this.pkg.cp.getIndexByTag(by);
    }

    ConstantPool.Index initCPIndex(byte by, ConstantPool.Entry[] entryArray) {
        if (this.verbose > 3) {
            for (int i = 0; i < entryArray.length; ++i) {
                Utils.log.fine("cp.add " + entryArray[i]);
            }
        }
        ConstantPool.Index index = ConstantPool.makeIndex(ConstantPool.tagName(by), entryArray);
        if (this.verbose > 1) {
            Utils.log.fine("Read " + index);
        }
        this.pkg.cp.initIndexByTag(by, index);
        return index;
    }

    void checkLegacy(String string) {
        if (this.packageVersion.lessThan(Constants.JAVA7_PACKAGE_VERSION)) {
            throw new RuntimeException("unexpected band " + string);
        }
    }

    void readConstantPool() throws IOException {
        Object object;
        Object object2;
        int n;
        if (this.verbose > 0) {
            Utils.log.info("Reading CP");
        }
        for (n = 0; n < ConstantPool.TAGS_IN_ORDER.length; ++n) {
            byte by = ConstantPool.TAGS_IN_ORDER[n];
            int n2 = this.tagCount[by];
            if (n2 > 100000) {
                this.in.ensureLengthValid(n2);
            }
            object2 = new ConstantPool.Entry[n2];
            if (this.verbose > 0) {
                Utils.log.info("Reading " + ((ConstantPool.Entry[])object2).length + " " + ConstantPool.tagName(by) + " entries...");
            }
            switch (by) {
                case 1: {
                    this.readUtf8Bands((ConstantPool.Entry[])object2);
                    break;
                }
                case 3: {
                    this.cp_Int.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Int.readFrom(this.in);
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        int n3 = this.cp_Int.getInt();
                        object2[i] = ConstantPool.getLiteralEntry(Integer.valueOf(n3));
                    }
                    this.cp_Int.doneDisbursing();
                    break;
                }
                case 4: {
                    this.cp_Float.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Float.readFrom(this.in);
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        int n4 = this.cp_Float.getInt();
                        float f = Float.intBitsToFloat(n4);
                        object2[i] = ConstantPool.getLiteralEntry(Float.valueOf(f));
                    }
                    this.cp_Float.doneDisbursing();
                    break;
                }
                case 5: {
                    long l;
                    this.cp_Long_hi.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Long_hi.readFrom(this.in);
                    this.cp_Long_lo.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Long_lo.readFrom(this.in);
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        long l2 = this.cp_Long_hi.getInt();
                        long l3 = this.cp_Long_lo.getInt();
                        l = (l2 << 32) + (l3 << 32 >>> 32);
                        object2[i] = ConstantPool.getLiteralEntry(Long.valueOf(l));
                    }
                    this.cp_Long_hi.doneDisbursing();
                    this.cp_Long_lo.doneDisbursing();
                    break;
                }
                case 6: {
                    long l;
                    this.cp_Double_hi.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Double_hi.readFrom(this.in);
                    this.cp_Double_lo.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Double_lo.readFrom(this.in);
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        long l4 = this.cp_Double_hi.getInt();
                        long l5 = this.cp_Double_lo.getInt();
                        l = (l4 << 32) + (l5 << 32 >>> 32);
                        double d = Double.longBitsToDouble(l);
                        object2[i] = ConstantPool.getLiteralEntry(Double.valueOf(d));
                    }
                    this.cp_Double_hi.doneDisbursing();
                    this.cp_Double_lo.doneDisbursing();
                    break;
                }
                case 8: {
                    this.cp_String.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_String.readFrom(this.in);
                    this.cp_String.setIndex(this.getCPIndex((byte)1));
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        object2[i] = ConstantPool.getLiteralEntry(this.cp_String.getRef().stringValue());
                    }
                    this.cp_String.doneDisbursing();
                    break;
                }
                case 7: {
                    this.cp_Class.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Class.readFrom(this.in);
                    this.cp_Class.setIndex(this.getCPIndex((byte)1));
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        object2[i] = ConstantPool.getClassEntry(this.cp_Class.getRef().stringValue());
                    }
                    this.cp_Class.doneDisbursing();
                    break;
                }
                case 13: {
                    this.readSignatureBands((ConstantPool.Entry[])object2);
                    break;
                }
                case 12: {
                    this.cp_Descr_name.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Descr_name.readFrom(this.in);
                    this.cp_Descr_name.setIndex(this.getCPIndex((byte)1));
                    this.cp_Descr_type.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_Descr_type.readFrom(this.in);
                    this.cp_Descr_type.setIndex(this.getCPIndex((byte)13));
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        ConstantPool.Entry entry = this.cp_Descr_name.getRef();
                        ConstantPool.Entry entry2 = this.cp_Descr_type.getRef();
                        object2[i] = ConstantPool.getDescriptorEntry((ConstantPool.Utf8Entry)entry, (ConstantPool.SignatureEntry)entry2);
                    }
                    this.cp_Descr_name.doneDisbursing();
                    this.cp_Descr_type.doneDisbursing();
                    break;
                }
                case 9: {
                    this.readMemberRefs(by, (ConstantPool.Entry[])object2, this.cp_Field_class, this.cp_Field_desc);
                    break;
                }
                case 10: {
                    this.readMemberRefs(by, (ConstantPool.Entry[])object2, this.cp_Method_class, this.cp_Method_desc);
                    break;
                }
                case 11: {
                    this.readMemberRefs(by, (ConstantPool.Entry[])object2, this.cp_Imethod_class, this.cp_Imethod_desc);
                    break;
                }
                case 15: {
                    if (((ConstantPool.Entry[])object2).length > 0) {
                        this.checkLegacy(this.cp_MethodHandle_refkind.name());
                    }
                    this.cp_MethodHandle_refkind.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_MethodHandle_refkind.readFrom(this.in);
                    this.cp_MethodHandle_member.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_MethodHandle_member.readFrom(this.in);
                    this.cp_MethodHandle_member.setIndex(this.getCPIndex((byte)52));
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        byte by2 = (byte)this.cp_MethodHandle_refkind.getInt();
                        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)this.cp_MethodHandle_member.getRef();
                        object2[i] = ConstantPool.getMethodHandleEntry(by2, memberEntry);
                    }
                    this.cp_MethodHandle_refkind.doneDisbursing();
                    this.cp_MethodHandle_member.doneDisbursing();
                    break;
                }
                case 16: {
                    if (((ConstantPool.Entry[])object2).length > 0) {
                        this.checkLegacy(this.cp_MethodType.name());
                    }
                    this.cp_MethodType.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_MethodType.readFrom(this.in);
                    this.cp_MethodType.setIndex(this.getCPIndex((byte)13));
                    for (int i = 0; i < ((ConstantPool.Entry[])object2).length; ++i) {
                        ConstantPool.SignatureEntry signatureEntry = (ConstantPool.SignatureEntry)this.cp_MethodType.getRef();
                        object2[i] = ConstantPool.getMethodTypeEntry(signatureEntry);
                    }
                    this.cp_MethodType.doneDisbursing();
                    break;
                }
                case 18: {
                    if (((ConstantPool.Entry[])object2).length > 0) {
                        this.checkLegacy(this.cp_InvokeDynamic_spec.name());
                    }
                    this.cp_InvokeDynamic_spec.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_InvokeDynamic_spec.readFrom(this.in);
                    this.cp_InvokeDynamic_spec.setIndex(this.getCPIndex((byte)17));
                    this.cp_InvokeDynamic_desc.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_InvokeDynamic_desc.readFrom(this.in);
                    this.cp_InvokeDynamic_desc.setIndex(this.getCPIndex((byte)12));
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        ConstantPool.BootstrapMethodEntry bootstrapMethodEntry = (ConstantPool.BootstrapMethodEntry)this.cp_InvokeDynamic_spec.getRef();
                        ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)this.cp_InvokeDynamic_desc.getRef();
                        object2[i] = ConstantPool.getInvokeDynamicEntry(bootstrapMethodEntry, descriptorEntry);
                    }
                    this.cp_InvokeDynamic_spec.doneDisbursing();
                    this.cp_InvokeDynamic_desc.doneDisbursing();
                    break;
                }
                case 17: {
                    if (((ConstantPool.Entry[])object2).length > 0) {
                        this.checkLegacy(this.cp_BootstrapMethod_ref.name());
                    }
                    this.cp_BootstrapMethod_ref.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_BootstrapMethod_ref.readFrom(this.in);
                    this.cp_BootstrapMethod_ref.setIndex(this.getCPIndex((byte)15));
                    this.cp_BootstrapMethod_arg_count.expectLength(((ConstantPool.Entry[])object2).length);
                    this.cp_BootstrapMethod_arg_count.readFrom(this.in);
                    int n5 = this.cp_BootstrapMethod_arg_count.getIntTotal();
                    this.cp_BootstrapMethod_arg.expectLength(n5);
                    this.cp_BootstrapMethod_arg.readFrom(this.in);
                    this.cp_BootstrapMethod_arg.setIndex(this.getCPIndex((byte)51));
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        ConstantPool.MethodHandleEntry methodHandleEntry = (ConstantPool.MethodHandleEntry)this.cp_BootstrapMethod_ref.getRef();
                        int n6 = this.cp_BootstrapMethod_arg_count.getInt();
                        ConstantPool.Entry[] entryArray = new ConstantPool.Entry[n6];
                        for (int j = 0; j < n6; ++j) {
                            entryArray[j] = this.cp_BootstrapMethod_arg.getRef();
                        }
                        object2[i] = ConstantPool.getBootstrapMethodEntry(methodHandleEntry, entryArray);
                    }
                    this.cp_BootstrapMethod_ref.doneDisbursing();
                    this.cp_BootstrapMethod_arg_count.doneDisbursing();
                    this.cp_BootstrapMethod_arg.doneDisbursing();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unexpected CP tag in package");
                }
            }
            object = this.initCPIndex(by, (ConstantPool.Entry[])object2);
            if (!this.optDumpBands) continue;
            try (PrintStream printStream = new PrintStream(PackageReader.getDumpStream((ConstantPool.Index)object, ".idx"));){
                PackageReader.printArrayTo(printStream, ((ConstantPool.Index)object).cpMap, 0, ((ConstantPool.Index)object).cpMap.length);
                continue;
            }
        }
        this.cp_bands.doneDisbursing();
        if (this.optDumpBands || this.verbose > 1) {
            for (n = 50; n < 54; n = (byte)(n + 1)) {
                ConstantPool.Index index = this.pkg.cp.getIndexByTag((byte)n);
                if (index == null || index.isEmpty()) continue;
                ConstantPool.Entry[] entryArray = index.cpMap;
                if (this.verbose > 1) {
                    Utils.log.info("Index group " + ConstantPool.tagName(n) + " contains " + entryArray.length + " entries.");
                }
                if (!this.optDumpBands) continue;
                object2 = new PrintStream(PackageReader.getDumpStream(index.debugName, n, ".gidx", index));
                object = null;
                try {
                    PackageReader.printArrayTo((PrintStream)object2, entryArray, 0, entryArray.length, true);
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((PrintStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((PrintStream)object2).close();
                        }
                    }
                }
            }
        }
        this.setBandIndexes();
    }

    void readUtf8Bands(ConstantPool.Entry[] entryArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = entryArray.length;
        if (n5 == 0) {
            return;
        }
        this.cp_Utf8_prefix.expectLength(Math.max(0, n5 - 2));
        this.cp_Utf8_prefix.readFrom(this.in);
        this.cp_Utf8_suffix.expectLength(Math.max(0, n5 - 1));
        this.cp_Utf8_suffix.readFrom(this.in);
        char[][] cArrayArray = new char[n5][];
        int n6 = 0;
        this.cp_Utf8_chars.expectLength(this.cp_Utf8_suffix.getIntTotal());
        this.cp_Utf8_chars.readFrom(this.in);
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = n3 = n4 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            if (n3 == 0 && n4 >= 1) {
                ++n6;
                continue;
            }
            cArrayArray[n4] = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.cp_Utf8_chars.getInt();
                assert (n == (char)n);
                cArrayArray[n4][n2] = (char)n;
            }
        }
        this.cp_Utf8_chars.doneDisbursing();
        n4 = 0;
        this.cp_Utf8_big_suffix.expectLength(n6);
        this.cp_Utf8_big_suffix.readFrom(this.in);
        this.cp_Utf8_suffix.resetForSecondPass();
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n3 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            int n8 = n = n3 < 2 ? 0 : this.cp_Utf8_prefix.getInt();
            if (n2 == 0 && n3 >= 1) {
                assert (cArrayArray[n3] == null);
                n2 = this.cp_Utf8_big_suffix.getInt();
            } else assert (cArrayArray[n3] != null);
            if (n4 >= n + n2) continue;
            n4 = n + n2;
        }
        char[] cArray = new char[n4];
        this.cp_Utf8_suffix.resetForSecondPass();
        this.cp_Utf8_big_suffix.resetForSecondPass();
        for (n2 = 0; n2 < n5; ++n2) {
            if (n2 < 1 || (n = this.cp_Utf8_suffix.getInt()) != 0) continue;
            n = this.cp_Utf8_big_suffix.getInt();
            cArrayArray[n2] = new char[n];
            if (n == 0) continue;
            BandStructure.IntBand intBand = this.cp_Utf8_big_chars.newIntBand("(Utf8_big_" + n2 + ")");
            intBand.expectLength(n);
            intBand.readFrom(this.in);
            for (int i = 0; i < n; ++i) {
                int n9 = intBand.getInt();
                assert (n9 == (char)n9);
                cArrayArray[n2][i] = (char)n9;
            }
            intBand.doneDisbursing();
        }
        this.cp_Utf8_big_chars.doneDisbursing();
        this.cp_Utf8_prefix.resetForSecondPass();
        this.cp_Utf8_suffix.resetForSecondPass();
        this.cp_Utf8_big_suffix.resetForSecondPass();
        for (n2 = 0; n2 < n5; ++n2) {
            int n10;
            n = n2 < 2 ? 0 : this.cp_Utf8_prefix.getInt();
            int n11 = n10 = n2 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            if (n10 == 0 && n2 >= 1) {
                n10 = this.cp_Utf8_big_suffix.getInt();
            }
            System.arraycopy(cArrayArray[n2], 0, cArray, n, n10);
            entryArray[n2] = ConstantPool.getUtf8Entry(new String(cArray, 0, n + n10));
        }
        this.cp_Utf8_prefix.doneDisbursing();
        this.cp_Utf8_suffix.doneDisbursing();
        this.cp_Utf8_big_suffix.doneDisbursing();
    }

    void readSignatureBands(ConstantPool.Entry[] entryArray) throws IOException {
        ConstantPool.Utf8Entry utf8Entry;
        int n;
        this.cp_Signature_form.expectLength(entryArray.length);
        this.cp_Signature_form.readFrom(this.in);
        this.cp_Signature_form.setIndex(this.getCPIndex((byte)1));
        int[] nArray = new int[entryArray.length];
        for (n = 0; n < entryArray.length; ++n) {
            utf8Entry = (ConstantPool.Utf8Entry)this.cp_Signature_form.getRef();
            nArray[n] = ConstantPool.countClassParts(utf8Entry);
        }
        this.cp_Signature_form.resetForSecondPass();
        this.cp_Signature_classes.expectLength(PackageReader.getIntTotal(nArray));
        this.cp_Signature_classes.readFrom(this.in);
        this.cp_Signature_classes.setIndex(this.getCPIndex((byte)7));
        this.utf8Signatures = new HashMap<ConstantPool.Utf8Entry, ConstantPool.SignatureEntry>();
        for (n = 0; n < entryArray.length; ++n) {
            utf8Entry = (ConstantPool.Utf8Entry)this.cp_Signature_form.getRef();
            ConstantPool.ClassEntry[] classEntryArray = new ConstantPool.ClassEntry[nArray[n]];
            for (int i = 0; i < classEntryArray.length; ++i) {
                classEntryArray[i] = (ConstantPool.ClassEntry)this.cp_Signature_classes.getRef();
            }
            ConstantPool.SignatureEntry signatureEntry = ConstantPool.getSignatureEntry(utf8Entry, classEntryArray);
            entryArray[n] = signatureEntry;
            this.utf8Signatures.put(signatureEntry.asUtf8Entry(), signatureEntry);
        }
        this.cp_Signature_form.doneDisbursing();
        this.cp_Signature_classes.doneDisbursing();
    }

    void readMemberRefs(byte by, ConstantPool.Entry[] entryArray, BandStructure.CPRefBand cPRefBand, BandStructure.CPRefBand cPRefBand2) throws IOException {
        cPRefBand.expectLength(entryArray.length);
        cPRefBand.readFrom(this.in);
        cPRefBand.setIndex(this.getCPIndex((byte)7));
        cPRefBand2.expectLength(entryArray.length);
        cPRefBand2.readFrom(this.in);
        cPRefBand2.setIndex(this.getCPIndex((byte)12));
        for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)cPRefBand.getRef();
            ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)cPRefBand2.getRef();
            entryArray[i] = ConstantPool.getMemberEntry(by, classEntry, descriptorEntry);
        }
        cPRefBand.doneDisbursing();
        cPRefBand2.doneDisbursing();
    }

    void readFiles() throws IOException {
        if (this.verbose > 0) {
            Utils.log.info("  ...building " + this.numFiles + " files...");
        }
        this.file_name.expectLength(this.numFiles);
        this.file_size_lo.expectLength(this.numFiles);
        int n = this.archiveOptions;
        boolean bl = PackageReader.testBit(n, 256);
        boolean bl2 = PackageReader.testBit(n, 64);
        boolean bl3 = PackageReader.testBit(n, 128);
        if (bl) {
            this.file_size_hi.expectLength(this.numFiles);
        }
        if (bl2) {
            this.file_modtime.expectLength(this.numFiles);
        }
        if (bl3) {
            this.file_options.expectLength(this.numFiles);
        }
        this.file_name.readFrom(this.in);
        this.file_size_hi.readFrom(this.in);
        this.file_size_lo.readFrom(this.in);
        this.file_modtime.readFrom(this.in);
        this.file_options.readFrom(this.in);
        this.file_bits.setInputStreamFrom(this.in);
        Iterator<Package.Class> iterator = this.pkg.getClasses().iterator();
        long l = 0L;
        long[] lArray = new long[this.numFiles];
        for (int i = 0; i < this.numFiles; ++i) {
            long l2 = (long)this.file_size_lo.getInt() << 32 >>> 32;
            if (bl) {
                l2 += (long)this.file_size_hi.getInt() << 32;
            }
            lArray[i] = l2;
            l += l2;
        }
        assert (this.in.getReadLimit() == -1L || this.in.getReadLimit() == l);
        byte[] byArray = new byte[65536];
        for (int i = 0; i < this.numFiles; ++i) {
            int n2;
            ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.file_name.getRef();
            long l3 = lArray[i];
            Package package_ = this.pkg;
            package_.getClass();
            Package.File file = package_.new Package.File(utf8Entry);
            file.modtime = this.pkg.default_modtime;
            file.options = this.pkg.default_options;
            if (bl2) {
                file.modtime += this.file_modtime.getInt();
            }
            if (bl3) {
                file.options |= this.file_options.getInt();
            }
            if (this.verbose > 1) {
                Utils.log.fine("Reading " + l3 + " bytes of " + utf8Entry.stringValue());
            }
            for (long j = l3; j > 0L; j -= (long)n2) {
                n2 = byArray.length;
                if ((long)n2 > j) {
                    n2 = (int)j;
                }
                if ((n2 = this.file_bits.getInputStream().read(byArray, 0, n2)) < 0) {
                    throw new EOFException();
                }
                file.addBytes(byArray, 0, n2);
            }
            this.pkg.addFile(file);
            if (!file.isClassStub()) continue;
            assert (file.getFileLength() == 0L);
            Package.Class clazz = iterator.next();
            clazz.initFile(file);
        }
        while (iterator.hasNext()) {
            Package.Class clazz = iterator.next();
            clazz.initFile(null);
            clazz.file.modtime = this.pkg.default_modtime;
        }
        this.file_name.doneDisbursing();
        this.file_size_hi.doneDisbursing();
        this.file_size_lo.doneDisbursing();
        this.file_modtime.doneDisbursing();
        this.file_options.doneDisbursing();
        this.file_bits.doneDisbursing();
        this.file_bands.doneDisbursing();
        if (this.archiveSize1 != 0L && !this.in.atLimit()) {
            throw new RuntimeException("Predicted archive_size " + this.archiveSize1 + " != " + (this.in.getBytesServed() - this.archiveSize0));
        }
    }

    void readAttrDefs() throws IOException {
        this.attr_definition_headers.expectLength(this.numAttrDefs);
        this.attr_definition_name.expectLength(this.numAttrDefs);
        this.attr_definition_layout.expectLength(this.numAttrDefs);
        this.attr_definition_headers.readFrom(this.in);
        this.attr_definition_name.readFrom(this.in);
        this.attr_definition_layout.readFrom(this.in);
        try (PrintStream printStream = !this.optDumpBands ? null : new PrintStream(PackageReader.getDumpStream(this.attr_definition_headers, ".def"));){
            for (int i = 0; i < this.numAttrDefs; ++i) {
                int n = this.attr_definition_headers.getByte();
                ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.attr_definition_name.getRef();
                ConstantPool.Utf8Entry utf8Entry2 = (ConstantPool.Utf8Entry)this.attr_definition_layout.getRef();
                int n2 = n & 3;
                int n3 = (n >> 2) - 1;
                Attribute.Layout layout = new Attribute.Layout(n2, utf8Entry.stringValue(), utf8Entry2.stringValue());
                String string = layout.layoutForClassVersion(this.getHighestClassVersion());
                if (!string.equals(layout.layout())) {
                    throw new IOException("Bad attribute layout in archive: " + layout.layout());
                }
                this.setAttributeLayoutIndex(layout, n3);
                if (printStream == null) continue;
                printStream.println(n3 + " " + layout);
            }
        }
        this.attr_definition_headers.doneDisbursing();
        this.attr_definition_name.doneDisbursing();
        this.attr_definition_layout.doneDisbursing();
        this.makeNewAttributeBands();
        this.attr_definition_bands.doneDisbursing();
    }

    void readInnerClasses() throws IOException {
        int n;
        int n2;
        this.ic_this_class.expectLength(this.numInnerClasses);
        this.ic_this_class.readFrom(this.in);
        this.ic_flags.expectLength(this.numInnerClasses);
        this.ic_flags.readFrom(this.in);
        int n3 = 0;
        for (int i = 0; i < this.numInnerClasses; ++i) {
            n2 = this.ic_flags.getInt();
            int n4 = n = (n2 & 0x10000) != 0 ? 1 : 0;
            if (n == 0) continue;
            ++n3;
        }
        this.ic_outer_class.expectLength(n3);
        this.ic_outer_class.readFrom(this.in);
        this.ic_name.expectLength(n3);
        this.ic_name.readFrom(this.in);
        this.ic_flags.resetForSecondPass();
        ArrayList<Package.InnerClass> arrayList = new ArrayList<Package.InnerClass>(this.numInnerClasses);
        for (n2 = 0; n2 < this.numInnerClasses; ++n2) {
            Object object;
            ConstantPool.Utf8Entry utf8Entry;
            ConstantPool.ClassEntry classEntry;
            n = this.ic_flags.getInt();
            boolean bl = (n & 0x10000) != 0;
            n &= 0xFFFEFFFF;
            ConstantPool.ClassEntry classEntry2 = (ConstantPool.ClassEntry)this.ic_this_class.getRef();
            if (bl) {
                classEntry = (ConstantPool.ClassEntry)this.ic_outer_class.getRef();
                utf8Entry = (ConstantPool.Utf8Entry)this.ic_name.getRef();
            } else {
                object = classEntry2.stringValue();
                String[] stringArray = Package.parseInnerClassName((String)object);
                assert (stringArray != null);
                String string = stringArray[0];
                String string2 = stringArray[2];
                classEntry = string == null ? null : ConstantPool.getClassEntry(string);
                utf8Entry = string2 == null ? null : ConstantPool.getUtf8Entry(string2);
            }
            object = new Package.InnerClass(classEntry2, classEntry, utf8Entry, n);
            assert (bl || ((Package.InnerClass)object).predictable);
            arrayList.add((Package.InnerClass)object);
        }
        this.ic_flags.doneDisbursing();
        this.ic_this_class.doneDisbursing();
        this.ic_outer_class.doneDisbursing();
        this.ic_name.doneDisbursing();
        this.pkg.setAllInnerClasses(arrayList);
        this.ic_bands.doneDisbursing();
    }

    void readLocalInnerClasses(Package.Class clazz) throws IOException {
        int n = this.class_InnerClasses_N.getInt();
        ArrayList<Package.InnerClass> arrayList = new ArrayList<Package.InnerClass>(n);
        for (int i = 0; i < n; ++i) {
            Comparable<Package.InnerClass> comparable;
            ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)this.class_InnerClasses_RC.getRef();
            int n2 = this.class_InnerClasses_F.getInt();
            if (n2 == 0) {
                comparable = this.pkg.getGlobalInnerClass(classEntry);
                assert (comparable != null);
                arrayList.add((Package.InnerClass)comparable);
                continue;
            }
            if (n2 == 65536) {
                n2 = 0;
            }
            comparable = (ConstantPool.ClassEntry)this.class_InnerClasses_outer_RCN.getRef();
            ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.class_InnerClasses_name_RUN.getRef();
            arrayList.add(new Package.InnerClass(classEntry, (ConstantPool.ClassEntry)comparable, utf8Entry, n2));
        }
        clazz.setInnerClasses(arrayList);
    }

    Package.Class[] readClasses() throws IOException {
        Package.Class[] classArray = new Package.Class[this.numClasses];
        if (this.verbose > 0) {
            Utils.log.info("  ...building " + classArray.length + " classes...");
        }
        this.class_this.expectLength(this.numClasses);
        this.class_super.expectLength(this.numClasses);
        this.class_interface_count.expectLength(this.numClasses);
        this.class_this.readFrom(this.in);
        this.class_super.readFrom(this.in);
        this.class_interface_count.readFrom(this.in);
        this.class_interface.expectLength(this.class_interface_count.getIntTotal());
        this.class_interface.readFrom(this.in);
        for (int i = 0; i < classArray.length; ++i) {
            Package.Class clazz;
            ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)this.class_this.getRef();
            ConstantPool.ClassEntry classEntry2 = (ConstantPool.ClassEntry)this.class_super.getRef();
            ConstantPool.ClassEntry[] classEntryArray = new ConstantPool.ClassEntry[this.class_interface_count.getInt()];
            for (int j = 0; j < classEntryArray.length; ++j) {
                classEntryArray[j] = (ConstantPool.ClassEntry)this.class_interface.getRef();
            }
            if (classEntry2 == classEntry) {
                classEntry2 = null;
            }
            Package package_ = this.pkg;
            package_.getClass();
            classArray[i] = clazz = package_.new Package.Class(0, classEntry, classEntry2, classEntryArray);
        }
        this.class_this.doneDisbursing();
        this.class_super.doneDisbursing();
        this.class_interface_count.doneDisbursing();
        this.class_interface.doneDisbursing();
        this.readMembers(classArray);
        this.countAndReadAttrs(0, Arrays.asList(classArray));
        this.pkg.trimToSize();
        this.readCodeHeaders();
        return classArray;
    }

    private int getOutputIndex(ConstantPool.Entry entry) {
        assert (entry.tag != 13);
        int n = this.pkg.cp.untypedIndexOf(entry);
        if (n >= 0) {
            return n;
        }
        if (entry.tag == 1) {
            ConstantPool.Entry entry2 = this.utf8Signatures.get(entry);
            return this.pkg.cp.untypedIndexOf(entry2);
        }
        return -1;
    }

    void reconstructClass(Package.Class clazz) {
        Attribute attribute;
        if (this.verbose > 1) {
            Utils.log.fine("reconstruct " + clazz);
        }
        if ((attribute = clazz.getAttribute(this.attrClassFileVersion)) != null) {
            clazz.removeAttribute(attribute);
            clazz.version = this.parseClassFileVersionAttr(attribute);
        } else {
            clazz.version = this.pkg.defaultClassVersion;
        }
        clazz.expandSourceFile();
        clazz.setCPMap(this.reconstructLocalCPMap(clazz));
    }

    ConstantPool.Entry[] reconstructLocalCPMap(Package.Class clazz) {
        ConstantPool.Entry entry;
        Set<ConstantPool.Entry> set = this.ldcRefMap.get(clazz);
        HashSet<ConstantPool.Entry> hashSet = new HashSet<ConstantPool.Entry>();
        clazz.visitRefs(0, hashSet);
        ArrayList<ConstantPool.BootstrapMethodEntry> arrayList = new ArrayList<ConstantPool.BootstrapMethodEntry>();
        clazz.addAttribute(Package.attrBootstrapMethodsEmpty.canonicalInstance());
        ConstantPool.completeReferencesIn(hashSet, true, arrayList);
        int n = clazz.expandLocalICs();
        if (n != 0) {
            if (n > 0) {
                clazz.visitInnerClassRefs(0, hashSet);
            } else {
                hashSet.clear();
                clazz.visitRefs(0, hashSet);
            }
            ConstantPool.completeReferencesIn(hashSet, true, arrayList);
        }
        if (arrayList.isEmpty()) {
            clazz.attributes.remove(Package.attrBootstrapMethodsEmpty.canonicalInstance());
        } else {
            hashSet.add(Package.getRefString("BootstrapMethods"));
            Collections.sort(arrayList);
            clazz.setBootstrapMethods(arrayList);
        }
        int n2 = 0;
        for (ConstantPool.Entry entry2 : hashSet) {
            if (!entry2.isDoubleWord()) continue;
            ++n2;
        }
        ConstantPool.Entry[] entryArray = new ConstantPool.Entry[1 + n2 + hashSet.size()];
        int n3 = 1;
        if (set != null) {
            assert (hashSet.containsAll(set));
            for (ConstantPool.Entry entry3 : set) {
                entryArray[n3++] = entry3;
            }
            assert (n3 == 1 + set.size());
            hashSet.removeAll(set);
            set = null;
        }
        HashSet<ConstantPool.Entry> hashSet2 = hashSet;
        hashSet = null;
        int n4 = n3;
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            entry = (ConstantPool.Entry)iterator.next();
            entryArray[n3++] = entry;
        }
        assert (n3 == n4 + hashSet2.size());
        Arrays.sort(entryArray, 1, n4, this.entryOutputOrder);
        Arrays.sort(entryArray, n4, n3, this.entryOutputOrder);
        if (this.verbose > 3) {
            Utils.log.fine("CP of " + this + " {");
            for (int i = 0; i < n3; ++i) {
                entry = entryArray[i];
                Utils.log.fine("  " + (entry == null ? -1 : this.getOutputIndex(entry)) + " : " + entry);
            }
            Utils.log.fine("}");
        }
        int n5 = entryArray.length;
        int n6 = n3;
        while (--n6 >= 1) {
            ConstantPool.Entry entry4 = entryArray[n6];
            if (entry4.isDoubleWord()) {
                entryArray[--n5] = null;
            }
            entryArray[--n5] = entry4;
        }
        assert (n5 == 1);
        return entryArray;
    }

    void readMembers(Package.Class[] classArray) throws IOException {
        int n;
        assert (classArray.length == this.numClasses);
        this.class_field_count.expectLength(this.numClasses);
        this.class_method_count.expectLength(this.numClasses);
        this.class_field_count.readFrom(this.in);
        this.class_method_count.readFrom(this.in);
        int n2 = this.class_field_count.getIntTotal();
        int n3 = this.class_method_count.getIntTotal();
        this.field_descr.expectLength(n2);
        this.method_descr.expectLength(n3);
        if (this.verbose > 1) {
            Utils.log.fine("expecting #fields=" + n2 + " and #methods=" + n3 + " in #classes=" + this.numClasses);
        }
        ArrayList<Package.Class.Field> arrayList = new ArrayList<Package.Class.Field>(n2);
        this.field_descr.readFrom(this.in);
        for (int i = 0; i < classArray.length; ++i) {
            Package.Class clazz = classArray[i];
            int n4 = this.class_field_count.getInt();
            for (n = 0; n < n4; ++n) {
                Package.Class clazz2 = clazz;
                clazz2.getClass();
                Package.Class.Field field = clazz2.new Package.Class.Field(0, (ConstantPool.DescriptorEntry)this.field_descr.getRef());
                arrayList.add(field);
            }
        }
        this.class_field_count.doneDisbursing();
        this.field_descr.doneDisbursing();
        this.countAndReadAttrs(1, arrayList);
        arrayList = null;
        ArrayList<Package.Class.Method> arrayList2 = new ArrayList<Package.Class.Method>(n3);
        this.method_descr.readFrom(this.in);
        for (int i = 0; i < classArray.length; ++i) {
            Package.Class clazz = classArray[i];
            n = this.class_method_count.getInt();
            for (int j = 0; j < n; ++j) {
                Package.Class clazz3 = clazz;
                clazz3.getClass();
                Package.Class.Method method = clazz3.new Package.Class.Method(0, (ConstantPool.DescriptorEntry)this.method_descr.getRef());
                arrayList2.add(method);
            }
        }
        this.class_method_count.doneDisbursing();
        this.method_descr.doneDisbursing();
        this.countAndReadAttrs(2, arrayList2);
        this.allCodes = this.buildCodeAttrs(arrayList2);
    }

    Code[] buildCodeAttrs(List<Package.Class.Method> list) {
        ArrayList<Code> arrayList = new ArrayList<Code>(list.size());
        for (Package.Class.Method method : list) {
            if (method.getAttribute(this.attrCodeEmpty) == null) continue;
            method.code = new Code(method);
            arrayList.add(method.code);
        }
        Code[] codeArray = new Code[arrayList.size()];
        arrayList.toArray(codeArray);
        return codeArray;
    }

    void readCodeHeaders() throws IOException {
        boolean bl = PackageReader.testBit(this.archiveOptions, 4);
        this.code_headers.expectLength(this.allCodes.length);
        this.code_headers.readFrom(this.in);
        ArrayList<Code> arrayList = new ArrayList<Code>(this.allCodes.length / 10);
        for (int i = 0; i < this.allCodes.length; ++i) {
            Code code = this.allCodes[i];
            int n = this.code_headers.getByte();
            assert (n == (n & 0xFF));
            if (this.verbose > 2) {
                Utils.log.fine("codeHeader " + code + " = " + n);
            }
            if (n == 0) {
                arrayList.add(code);
                continue;
            }
            code.setMaxStack(PackageReader.shortCodeHeader_max_stack(n));
            code.setMaxNALocals(PackageReader.shortCodeHeader_max_na_locals(n));
            code.setHandlerCount(PackageReader.shortCodeHeader_handler_count(n));
            assert (PackageReader.shortCodeHeader(code) == n);
        }
        this.code_headers.doneDisbursing();
        this.code_max_stack.expectLength(arrayList.size());
        this.code_max_na_locals.expectLength(arrayList.size());
        this.code_handler_count.expectLength(arrayList.size());
        this.code_max_stack.readFrom(this.in);
        this.code_max_na_locals.readFrom(this.in);
        this.code_handler_count.readFrom(this.in);
        for (Code code : arrayList) {
            code.setMaxStack(this.code_max_stack.getInt());
            code.setMaxNALocals(this.code_max_na_locals.getInt());
            code.setHandlerCount(this.code_handler_count.getInt());
        }
        this.code_max_stack.doneDisbursing();
        this.code_max_na_locals.doneDisbursing();
        this.code_handler_count.doneDisbursing();
        this.readCodeHandlers();
        this.codesWithFlags = bl ? Arrays.asList(this.allCodes) : arrayList;
        this.countAttrs(3, this.codesWithFlags);
    }

    void readCodeHandlers() throws IOException {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.allCodes.length; ++i) {
            Code code = this.allCodes[i];
            n2 += code.getHandlerCount();
        }
        BandStructure.ValueBand[] valueBandArray = new BandStructure.ValueBand[]{this.code_handler_start_P, this.code_handler_end_PO, this.code_handler_catch_PO, this.code_handler_class_RCN};
        for (n = 0; n < valueBandArray.length; ++n) {
            valueBandArray[n].expectLength(n2);
            valueBandArray[n].readFrom(this.in);
        }
        for (n = 0; n < this.allCodes.length; ++n) {
            Code code = this.allCodes[n];
            int n3 = code.getHandlerCount();
            for (int i = 0; i < n3; ++i) {
                code.handler_class[i] = this.code_handler_class_RCN.getRef();
                code.handler_start[i] = this.code_handler_start_P.getInt();
                code.handler_end[i] = this.code_handler_end_PO.getInt();
                code.handler_catch[i] = this.code_handler_catch_PO.getInt();
            }
        }
        for (n = 0; n < valueBandArray.length; ++n) {
            valueBandArray[n].doneDisbursing();
        }
    }

    void fixupCodeHandlers() {
        for (int i = 0; i < this.allCodes.length; ++i) {
            Code code = this.allCodes[i];
            int n = code.getHandlerCount();
            for (int j = 0; j < n; ++j) {
                int n2 = code.handler_start[j];
                code.handler_start[j] = code.decodeBCI(n2);
                code.handler_end[j] = code.decodeBCI(n2 += code.handler_end[j]);
                code.handler_catch[j] = code.decodeBCI(n2 += code.handler_catch[j]);
            }
        }
    }

    void countAndReadAttrs(int n, Collection<? extends Attribute.Holder> collection) throws IOException {
        this.countAttrs(n, collection);
        this.readAttrs(n, collection);
    }

    /*
     * WARNING - void declaration
     */
    void countAttrs(int n, Collection<? extends Attribute.Holder> collection) throws IOException {
        void var17_19;
        int n2;
        Attribute.Layout layout;
        int n3;
        BandStructure.MultiBand multiBand = this.attrBands[n];
        long l = this.attrFlagMask[n];
        if (this.verbose > 1) {
            Utils.log.fine("scanning flags and attrs for " + Attribute.contextName(n) + "[" + collection.size() + "]");
        }
        List list = (List)this.attrDefs.get(n);
        Attribute.Layout[] layoutArray = new Attribute.Layout[list.size()];
        list.toArray(layoutArray);
        BandStructure.IntBand intBand = PackageReader.getAttrBand(multiBand, 0);
        BandStructure.IntBand intBand2 = PackageReader.getAttrBand(multiBand, 1);
        BandStructure.IntBand intBand3 = PackageReader.getAttrBand(multiBand, 2);
        BandStructure.IntBand intBand4 = PackageReader.getAttrBand(multiBand, 3);
        BandStructure.IntBand intBand5 = PackageReader.getAttrBand(multiBand, 4);
        int n4 = this.attrOverflowMask[n];
        int n5 = 0;
        boolean bl = this.haveFlagsHi(n);
        intBand.expectLength(bl ? collection.size() : 0);
        intBand.readFrom(this.in);
        intBand2.expectLength(collection.size());
        intBand2.readFrom(this.in);
        assert ((l & (long)n4) == (long)n4);
        for (Attribute.Holder object : collection) {
            int bl2;
            object.flags = bl2 = intBand2.getInt();
            if ((bl2 & n4) == 0) continue;
            ++n5;
        }
        intBand3.expectLength(n5);
        intBand3.readFrom(this.in);
        intBand4.expectLength(intBand3.getIntTotal());
        intBand4.readFrom(this.in);
        Object object = new int[layoutArray.length];
        for (Attribute.Holder holder : collection) {
            Attribute attribute;
            assert (holder.attributes == null);
            long l2 = ((long)holder.flags & l) << 32 >>> 32;
            holder.flags -= (int)l2;
            assert (holder.flags == (char)holder.flags);
            assert (n != 3 || holder.flags == 0);
            if (bl) {
                l2 += (long)intBand.getInt() << 32;
            }
            if (l2 == 0L) continue;
            int n6 = 0;
            long l3 = l2 & (long)n4;
            assert (l3 >= 0L);
            l2 -= l3;
            if (l3 != 0L) {
                n6 = intBand3.getInt();
            }
            int n7 = 0;
            long l4 = l2;
            int n8 = 0;
            while (l4 != 0L) {
                if ((l4 & 1L << n8) != 0L) {
                    l4 -= 1L << n8;
                    ++n7;
                }
                ++n8;
            }
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(n7 + n6);
            holder.attributes = arrayList;
            l4 = l2;
            int n9 = 0;
            while (l4 != 0L) {
                if ((l4 & 1L << n9) != 0L) {
                    l4 -= 1L << n9;
                    Object object2 = object;
                    int n10 = n9;
                    object2[n10] = object2[n10] + true;
                    if (layoutArray[n9] == null) {
                        this.badAttrIndex(n9, n);
                    }
                    attribute = layoutArray[n9].canonicalInstance();
                    arrayList.add(attribute);
                    --n7;
                }
                ++n9;
            }
            assert (n7 == 0);
            while (n6 > 0) {
                n9 = intBand4.getInt();
                Object object3 = object;
                int n11 = n9;
                object3[n11] = object3[n11] + true;
                if (layoutArray[n9] == null) {
                    this.badAttrIndex(n9, n);
                }
                attribute = layoutArray[n9].canonicalInstance();
                arrayList.add(attribute);
                --n6;
            }
        }
        intBand.doneDisbursing();
        intBand2.doneDisbursing();
        intBand3.doneDisbursing();
        intBand4.doneDisbursing();
        boolean bl2 = false;
        boolean bl3 = true;
        while (true) {
            boolean bl4;
            for (n3 = 0; n3 < layoutArray.length; ++n3) {
                Object object4;
                layout = layoutArray[n3];
                if (layout == null || bl4 != this.isPredefinedAttr(n, n3) || (object4 = object[n3]) == false) continue;
                Attribute.Layout.Element[] elementArray = layout.getCallables();
                for (n2 = 0; n2 < elementArray.length; ++n2) {
                    assert (elementArray[n2].kind == 10);
                    if (!elementArray[n2].flagTest((byte)8)) continue;
                    ++var17_19;
                }
            }
            if (!bl4) break;
            bl4 = false;
        }
        intBand5.expectLength((int)var17_19);
        intBand5.readFrom(this.in);
        boolean bl5 = true;
        while (true) {
            boolean bl6;
            for (n3 = 0; n3 < layoutArray.length; ++n3) {
                layout = layoutArray[n3];
                if (layout == null || bl6 != this.isPredefinedAttr(n, n3)) continue;
                Object object5 = object[n3];
                BandStructure.Band[] bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
                if (layout == this.attrInnerClassesEmpty) {
                    this.class_InnerClasses_N.expectLength((int)object5);
                    this.class_InnerClasses_N.readFrom(this.in);
                    n2 = this.class_InnerClasses_N.getIntTotal();
                    this.class_InnerClasses_RC.expectLength(n2);
                    this.class_InnerClasses_RC.readFrom(this.in);
                    this.class_InnerClasses_F.expectLength(n2);
                    this.class_InnerClasses_F.readFrom(this.in);
                    this.class_InnerClasses_outer_RCN.expectLength(n2 -= this.class_InnerClasses_F.getIntCount(0));
                    this.class_InnerClasses_outer_RCN.readFrom(this.in);
                    this.class_InnerClasses_name_RUN.expectLength(n2);
                    this.class_InnerClasses_name_RUN.readFrom(this.in);
                    continue;
                }
                if (!this.optDebugBands && object5 == false) {
                    for (n2 = 0; n2 < bandArray.length; ++n2) {
                        bandArray[n2].doneWithUnusedBand();
                    }
                    continue;
                }
                n2 = layout.hasCallables() ? 1 : 0;
                if (n2 == 0) {
                    this.readAttrBands(layout.elems, (int)object5, new int[0], bandArray);
                } else {
                    Attribute.Layout.Element[] elementArray = layout.getCallables();
                    int[] nArray = new int[elementArray.length];
                    nArray[0] = (int)object5;
                    for (int i = 0; i < elementArray.length; ++i) {
                        assert (elementArray[i].kind == 10);
                        int n12 = nArray[i];
                        nArray[i] = -1;
                        if (object5 > 0 && elementArray[i].flagTest((byte)8)) {
                            n12 += intBand5.getInt();
                        }
                        this.readAttrBands(elementArray[i].body, n12, nArray, bandArray);
                    }
                }
                if (!this.optDebugBands || object5 != false) continue;
                for (int i = 0; i < bandArray.length; ++i) {
                    bandArray[i].doneDisbursing();
                }
            }
            if (!bl6) break;
            bl6 = false;
        }
        intBand5.doneDisbursing();
    }

    void badAttrIndex(int n, int n2) throws IOException {
        throw new IOException("Unknown attribute index " + n + " for " + Constants.ATTR_CONTEXT_NAME[n2] + " attribute");
    }

    /*
     * WARNING - void declaration
     */
    void readAttrs(int n, Collection<? extends Attribute.Holder> collection) throws IOException {
        void var6_10;
        Object object;
        HashSet<Attribute.Layout> hashSet = new HashSet<Attribute.Layout>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (final Attribute.Holder object2 : collection) {
            if (object2.attributes == null) continue;
            object = object2.attributes.listIterator();
            while (object.hasNext()) {
                boolean bl;
                Attribute attribute = object.next();
                Attribute.Layout layout = attribute.layout();
                if (layout.bandCount == 0) {
                    if (layout != this.attrInnerClassesEmpty) continue;
                    this.readLocalInnerClasses((Package.Class)object2);
                    continue;
                }
                hashSet.add(layout);
                boolean bl2 = bl = n == 1 && layout == this.attrConstantValue;
                if (bl) {
                    this.setConstantValueIndex((Package.Class.Field)object2);
                }
                if (this.verbose > 2) {
                    Utils.log.fine("read " + attribute + " in " + object2);
                }
                final BandStructure.Band[] bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
                byteArrayOutputStream.reset();
                Object object3 = attribute.unparse(new Attribute.ValueStream(){

                    @Override
                    public int getInt(int n) {
                        return ((BandStructure.IntBand)bandArray[n]).getInt();
                    }

                    @Override
                    public ConstantPool.Entry getRef(int n) {
                        return ((BandStructure.CPRefBand)bandArray[n]).getRef();
                    }

                    @Override
                    public int decodeBCI(int n) {
                        Code code = (Code)object2;
                        return code.decodeBCI(n);
                    }
                }, byteArrayOutputStream);
                object.set(attribute.addContent(byteArrayOutputStream.toByteArray(), object3));
                if (!bl) continue;
                this.setConstantValueIndex(null);
            }
        }
        for (Attribute.Layout layout : hashSet) {
            if (layout == null) continue;
            object = (BandStructure.Band[])this.attrBandTable.get(layout);
            for (int i = 0; i < ((BandStructure.Band[])object).length; ++i) {
                object[i].doneDisbursing();
            }
        }
        if (n == 0) {
            this.class_InnerClasses_N.doneDisbursing();
            this.class_InnerClasses_RC.doneDisbursing();
            this.class_InnerClasses_F.doneDisbursing();
            this.class_InnerClasses_outer_RCN.doneDisbursing();
            this.class_InnerClasses_name_RUN.doneDisbursing();
        }
        BandStructure.MultiBand multiBand = this.attrBands[n];
        boolean bl = false;
        while (var6_10 < multiBand.size()) {
            object = multiBand.get((int)var6_10);
            if (object instanceof BandStructure.MultiBand) {
                ((BandStructure.Band)object).doneDisbursing();
            }
            ++var6_10;
        }
        multiBand.doneDisbursing();
    }

    private void readAttrBands(Attribute.Layout.Element[] elementArray, int n, int[] nArray, BandStructure.Band[] bandArray) throws IOException {
        block6: for (int i = 0; i < elementArray.length; ++i) {
            Attribute.Layout.Element element = elementArray[i];
            BandStructure.Band band = null;
            if (element.hasBand()) {
                band = bandArray[element.bandIndex];
                band.expectLength(n);
                band.readFrom(this.in);
            }
            switch (element.kind) {
                case 5: {
                    int n2 = ((BandStructure.IntBand)band).getIntTotal();
                    this.readAttrBands(element.body, n2, nArray, bandArray);
                    continue block6;
                }
                case 7: {
                    int n3 = n;
                    for (int j = 0; j < element.body.length; ++j) {
                        int n4;
                        if (j == element.body.length - 1) {
                            n4 = n3;
                        } else {
                            n4 = 0;
                            int n5 = j;
                            while (j == n5 || j < element.body.length && element.body[j].flagTest((byte)8)) {
                                n4 += ((BandStructure.IntBand)band).getIntCount(element.body[j].value);
                                ++j;
                            }
                            --j;
                        }
                        n3 -= n4;
                        this.readAttrBands(element.body[j].body, n4, nArray, bandArray);
                    }
                    assert (n3 == 0);
                    continue block6;
                }
                case 9: {
                    assert (element.body.length == 1);
                    assert (element.body[0].kind == 10);
                    if (element.flagTest((byte)8)) continue block6;
                    assert (nArray[element.value] >= 0);
                    int n6 = element.value;
                    nArray[n6] = nArray[n6] + n;
                    continue block6;
                }
                case 10: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    void readByteCodes() throws IOException {
        int n;
        this.bc_codes.elementCountForDebug = this.allCodes.length;
        this.bc_codes.setInputStreamFrom(this.in);
        this.readByteCodeOps();
        this.bc_codes.doneDisbursing();
        BandStructure.Band[] bandArray = new BandStructure.Band[]{this.bc_case_value, this.bc_byte, this.bc_short, this.bc_local, this.bc_label, this.bc_intref, this.bc_floatref, this.bc_longref, this.bc_doubleref, this.bc_stringref, this.bc_loadablevalueref, this.bc_classref, this.bc_fieldref, this.bc_methodref, this.bc_imethodref, this.bc_indyref, this.bc_thisfield, this.bc_superfield, this.bc_thismethod, this.bc_supermethod, this.bc_initref, this.bc_escref, this.bc_escrefsize, this.bc_escsize};
        for (n = 0; n < bandArray.length; ++n) {
            bandArray[n].readFrom(this.in);
        }
        this.bc_escbyte.expectLength(this.bc_escsize.getIntTotal());
        this.bc_escbyte.readFrom(this.in);
        this.expandByteCodeOps();
        this.bc_case_count.doneDisbursing();
        for (n = 0; n < bandArray.length; ++n) {
            bandArray[n].doneDisbursing();
        }
        this.bc_escbyte.doneDisbursing();
        this.bc_bands.doneDisbursing();
        this.readAttrs(3, this.codesWithFlags);
        this.fixupCodeHandlers();
        this.code_bands.doneDisbursing();
        this.class_bands.doneDisbursing();
    }

    private void readByteCodeOps() throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[4096];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block11: for (int i = 0; i < this.allCodes.length; ++i) {
            Code object = this.allCodes[i];
            n2 = 0;
            while (true) {
                n = this.bc_codes.getByte();
                if (n2 + 10 > byArray.length) {
                    byArray = PackageReader.realloc(byArray);
                }
                byArray[n2] = (byte)n;
                boolean bl = false;
                if (n == 196) {
                    n = this.bc_codes.getByte();
                    byArray[++n2] = (byte)n;
                    bl = true;
                }
                assert (n == (0xFF & n));
                switch (n) {
                    case 170: 
                    case 171: {
                        this.bc_case_count.expectMoreLength(1);
                        arrayList.add(n);
                        break;
                    }
                    case 132: {
                        this.bc_local.expectMoreLength(1);
                        if (bl) {
                            this.bc_short.expectMoreLength(1);
                            break;
                        }
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 17: {
                        this.bc_short.expectMoreLength(1);
                        break;
                    }
                    case 16: {
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 188: {
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 197: {
                        assert (this.getCPRefOpBand(n) == this.bc_classref);
                        this.bc_classref.expectMoreLength(1);
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 253: {
                        this.bc_escrefsize.expectMoreLength(1);
                        this.bc_escref.expectMoreLength(1);
                        break;
                    }
                    case 254: {
                        this.bc_escsize.expectMoreLength(1);
                        break;
                    }
                    default: {
                        BandStructure.CPRefBand cPRefBand;
                        if (Instruction.isInvokeInitOp(n)) {
                            this.bc_initref.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isSelfLinkerOp(n)) {
                            cPRefBand = this.selfOpRefBand(n);
                            cPRefBand.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isBranchOp(n)) {
                            this.bc_label.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isCPRefOp(n)) {
                            cPRefBand = this.getCPRefOpBand(n);
                            cPRefBand.expectMoreLength(1);
                            assert (n != 197);
                            break;
                        }
                        if (!Instruction.isLocalSlotOp(n)) break;
                        this.bc_local.expectMoreLength(1);
                        break;
                    }
                    case 255: {
                        object.bytes = PackageReader.realloc(byArray, n2);
                        continue block11;
                    }
                }
                ++n2;
            }
        }
        this.bc_case_count.readFrom(this.in);
        for (Integer n3 : arrayList) {
            n2 = n3;
            n = this.bc_case_count.getInt();
            this.bc_label.expectMoreLength(1 + n);
            this.bc_case_value.expectMoreLength(n2 == 170 ? 1 : n);
        }
        this.bc_case_count.resetForSecondPass();
    }

    private void expandByteCodeOps() throws IOException {
        byte[] byArray = new byte[4096];
        int[] nArray = new int[4096];
        int[] nArray2 = new int[1024];
        Fixups fixups = new Fixups();
        for (int i = 0; i < this.allCodes.length; ++i) {
            int n;
            int n2;
            Code code = this.allCodes[i];
            byte[] byArray2 = code.bytes;
            code.bytes = null;
            Package.Class clazz = code.thisClass();
            Set<ConstantPool.Entry> set = this.ldcRefMap.get(clazz);
            if (set == null) {
                set = new HashSet<ConstantPool.Entry>();
                this.ldcRefMap.put(clazz, set);
            }
            ConstantPool.ClassEntry classEntry = clazz.thisClass;
            ConstantPool.ClassEntry classEntry2 = clazz.superClass;
            ConstantPool.ClassEntry classEntry3 = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            fixups.clear();
            block29: for (int j = 0; j < byArray2.length; ++j) {
                n2 = Instruction.getByte(byArray2, j);
                n = n3;
                nArray[n4++] = n;
                if (n3 + 10 > byArray.length) {
                    byArray = PackageReader.realloc(byArray);
                }
                if (n4 + 10 > nArray.length) {
                    nArray = PackageReader.realloc(nArray);
                }
                if (n5 + 10 > nArray2.length) {
                    nArray2 = PackageReader.realloc(nArray2);
                }
                boolean bl2 = false;
                if (n2 == 196) {
                    byArray[n3++] = (byte)n2;
                    n2 = Instruction.getByte(byArray2, ++j);
                    bl2 = true;
                }
                switch (n2) {
                    case 170: 
                    case 171: {
                        int n6 = this.bc_case_count.getInt();
                        while (n3 + 30 + n6 * 8 > byArray.length) {
                            byArray = PackageReader.realloc(byArray);
                        }
                        byArray[n3++] = (byte)n2;
                        Arrays.fill(byArray, n3, n3 + 30, (byte)0);
                        Instruction.Switch switch_ = (Instruction.Switch)Instruction.at(byArray, n);
                        switch_.setCaseCount(n6);
                        if (n2 == 170) {
                            switch_.setCaseValue(0, this.bc_case_value.getInt());
                        } else {
                            for (int k = 0; k < n6; ++k) {
                                switch_.setCaseValue(k, this.bc_case_value.getInt());
                            }
                        }
                        nArray2[n5++] = n;
                        n3 = switch_.getNextPC();
                        continue block29;
                    }
                    case 132: {
                        byArray[n3++] = (byte)n2;
                        int n7 = this.bc_local.getInt();
                        if (bl2) {
                            int n8 = this.bc_short.getInt();
                            Instruction.setShort(byArray, n3, n7);
                            Instruction.setShort(byArray, n3 += 2, n8);
                            n3 += 2;
                            continue block29;
                        }
                        byte by = (byte)this.bc_byte.getByte();
                        byArray[n3++] = (byte)n7;
                        byArray[n3++] = by;
                        continue block29;
                    }
                    case 17: {
                        int n9 = this.bc_short.getInt();
                        byArray[n3++] = (byte)n2;
                        Instruction.setShort(byArray, n3, n9);
                        n3 += 2;
                        continue block29;
                    }
                    case 16: 
                    case 188: {
                        int n10 = this.bc_byte.getByte();
                        byArray[n3++] = (byte)n2;
                        byArray[n3++] = (byte)n10;
                        continue block29;
                    }
                    case 253: {
                        bl = true;
                        int n11 = this.bc_escrefsize.getInt();
                        ConstantPool.Entry entry = this.bc_escref.getRef();
                        if (n11 == 1) {
                            set.add(entry);
                        }
                        switch (n11) {
                            case 1: {
                                fixups.addU1(n3, entry);
                                break;
                            }
                            case 2: {
                                fixups.addU2(n3, entry);
                                break;
                            }
                            default: {
                                assert (false);
                                boolean bl3 = false;
                            }
                        }
                        byArray[n3 + 1] = 0;
                        byArray[n3 + 0] = 0;
                        n3 += n11;
                        continue block29;
                    }
                    case 254: {
                        bl = true;
                        int n12 = this.bc_escsize.getInt();
                        while (n3 + n12 > byArray.length) {
                            byArray = PackageReader.realloc(byArray);
                        }
                        while (n12-- > 0) {
                            byArray[n3++] = (byte)this.bc_escbyte.getByte();
                        }
                        continue block29;
                    }
                    default: {
                        int n13;
                        if (Instruction.isInvokeInitOp(n2)) {
                            ConstantPool.ClassEntry classEntry4;
                            int n14 = n2 - 230;
                            int n15 = 183;
                            switch (n14) {
                                case 0: {
                                    classEntry4 = classEntry;
                                    break;
                                }
                                case 1: {
                                    classEntry4 = classEntry2;
                                    break;
                                }
                                default: {
                                    assert (n14 == 2);
                                    classEntry4 = classEntry3;
                                }
                            }
                            byArray[n3++] = (byte)n15;
                            n13 = this.bc_initref.getInt();
                            ConstantPool.MemberEntry memberEntry = this.pkg.cp.getOverloadingForIndex((byte)10, classEntry4, "<init>", n13);
                            fixups.addU2(n3, memberEntry);
                            byArray[n3 + 1] = 0;
                            byArray[n3 + 0] = 0;
                            assert (Instruction.opLength(n15) == (n3 += 2) - n);
                            continue block29;
                        }
                        if (Instruction.isSelfLinkerOp(n2)) {
                            ConstantPool.Index index;
                            BandStructure.CPRefBand cPRefBand;
                            ConstantPool.ClassEntry classEntry5;
                            boolean bl4;
                            boolean bl5;
                            int n16 = n2 - 202;
                            boolean bl6 = bl5 = n16 >= 14;
                            if (bl5) {
                                n16 -= 14;
                            }
                            boolean bl7 = bl4 = n16 >= 7;
                            if (bl4) {
                                n16 -= 7;
                            }
                            n13 = 178 + n16;
                            boolean bl8 = Instruction.isFieldOp(n13);
                            ConstantPool.ClassEntry classEntry6 = classEntry5 = bl5 ? classEntry2 : classEntry;
                            if (bl8) {
                                cPRefBand = bl5 ? this.bc_superfield : this.bc_thisfield;
                                index = this.pkg.cp.getMemberIndex((byte)9, classEntry5);
                            } else {
                                cPRefBand = bl5 ? this.bc_supermethod : this.bc_thismethod;
                                index = this.pkg.cp.getMemberIndex((byte)10, classEntry5);
                            }
                            assert (cPRefBand == this.selfOpRefBand(n2));
                            ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)cPRefBand.getRef(index);
                            if (bl4) {
                                byArray[n3++] = 42;
                                n = n3;
                                nArray[n4++] = n;
                            }
                            byArray[n3++] = (byte)n13;
                            fixups.addU2(n3, memberEntry);
                            byArray[n3 + 1] = 0;
                            byArray[n3 + 0] = 0;
                            assert (Instruction.opLength(n13) == (n3 += 2) - n);
                            continue block29;
                        }
                        if (Instruction.isBranchOp(n2)) {
                            byArray[n3++] = (byte)n2;
                            assert (!bl2);
                            int n17 = n + Instruction.opLength(n2);
                            nArray2[n5++] = n;
                            while (n3 < n17) {
                                byArray[n3++] = 0;
                            }
                            continue block29;
                        }
                        if (Instruction.isCPRefOp(n2)) {
                            BandStructure.CPRefBand cPRefBand = this.getCPRefOpBand(n2);
                            ConstantPool.Entry entry = cPRefBand.getRef();
                            if (entry == null) {
                                if (cPRefBand == this.bc_classref) {
                                    entry = classEntry;
                                } else assert (false);
                            }
                            int n18 = n2;
                            n13 = 2;
                            switch (n2) {
                                case 243: {
                                    n18 = 184;
                                    break;
                                }
                                case 242: {
                                    n18 = 183;
                                    break;
                                }
                                case 18: 
                                case 233: 
                                case 234: 
                                case 235: 
                                case 240: {
                                    n18 = 18;
                                    n13 = 1;
                                    set.add(entry);
                                    break;
                                }
                                case 19: 
                                case 236: 
                                case 237: 
                                case 238: 
                                case 241: {
                                    n18 = 19;
                                    break;
                                }
                                case 20: 
                                case 239: {
                                    n18 = 20;
                                    break;
                                }
                                case 187: {
                                    classEntry3 = (ConstantPool.ClassEntry)entry;
                                }
                            }
                            byArray[n3++] = (byte)n18;
                            switch (n13) {
                                case 1: {
                                    fixups.addU1(n3, entry);
                                    break;
                                }
                                case 2: {
                                    fixups.addU2(n3, entry);
                                    break;
                                }
                                default: {
                                    assert (false);
                                    boolean bl9 = false;
                                }
                            }
                            byArray[n3 + 1] = 0;
                            byArray[n3 + 0] = 0;
                            n3 += n13;
                            if (n18 == 197) {
                                int n19 = this.bc_byte.getByte();
                                byArray[n3++] = (byte)n19;
                            } else if (n18 == 185) {
                                int n20 = ((ConstantPool.MemberEntry)entry).descRef.typeRef.computeSize(true);
                                byArray[n3++] = (byte)(1 + n20);
                                byArray[n3++] = 0;
                            } else if (n18 == 186) {
                                byArray[n3++] = 0;
                                byArray[n3++] = 0;
                            }
                            assert (Instruction.opLength(n18) == n3 - n);
                            continue block29;
                        }
                        if (Instruction.isLocalSlotOp(n2)) {
                            byArray[n3++] = (byte)n2;
                            int n21 = this.bc_local.getInt();
                            if (bl2) {
                                Instruction.setShort(byArray, n3, n21);
                                n3 += 2;
                                if (n2 == 132) {
                                    int n22 = this.bc_short.getInt();
                                    Instruction.setShort(byArray, n3, n22);
                                    n3 += 2;
                                }
                            } else {
                                Instruction.setByte(byArray, n3, n21);
                                ++n3;
                                if (n2 == 132) {
                                    int n23 = this.bc_byte.getByte();
                                    Instruction.setByte(byArray, n3, n23);
                                    ++n3;
                                }
                            }
                            assert (Instruction.opLength(n2) == n3 - n);
                            continue block29;
                        }
                        if (n2 >= 202) {
                            Utils.log.warning("unrecognized bytescode " + n2 + " " + Instruction.byteName(n2));
                        }
                        assert (n2 < 202);
                        byArray[n3++] = (byte)n2;
                        assert (Instruction.opLength(n2) == n3 - n);
                        continue block29;
                    }
                }
            }
            code.setBytes(PackageReader.realloc(byArray, n3));
            code.setInstructionMap(nArray, n4);
            Instruction instruction = null;
            for (n2 = 0; n2 < n5; ++n2) {
                n = nArray2[n2];
                if ((instruction = Instruction.at(code.bytes, n, instruction)) instanceof Instruction.Switch) {
                    Instruction.Switch switch_ = (Instruction.Switch)instruction;
                    switch_.setDefaultLabel(this.getLabel(this.bc_label, code, n));
                    int n24 = switch_.getCaseCount();
                    for (int j = 0; j < n24; ++j) {
                        switch_.setCaseLabel(j, this.getLabel(this.bc_label, code, n));
                    }
                    continue;
                }
                instruction.setBranchLabel(this.getLabel(this.bc_label, code, n));
            }
            if (fixups.size() <= 0) continue;
            if (this.verbose > 2) {
                Utils.log.fine("Fixups in code: " + fixups);
            }
            code.addFixups(fixups);
        }
    }

    static class LimitedBuffer
    extends BufferedInputStream {
        long served;
        int servedPos;
        long limit;
        long buffered;

        public boolean atLimit() {
            boolean bl;
            boolean bl2 = bl = this.getBytesServed() == this.limit;
            assert (!bl || this.limit == this.buffered);
            return bl;
        }

        public long getBytesServed() {
            return this.served + (long)(this.pos - this.servedPos);
        }

        public void setReadLimit(long l) {
            this.limit = l == -1L ? -1L : this.getBytesServed() + l;
        }

        public long getReadLimit() {
            if (this.limit == -1L) {
                return this.limit;
            }
            return this.limit - this.getBytesServed();
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.count) {
                return this.buf[this.pos++] & 0xFF;
            }
            this.served += (long)(this.pos - this.servedPos);
            int n = super.read();
            this.servedPos = this.pos;
            if (n >= 0) {
                ++this.served;
            }
            assert (this.served <= this.limit || this.limit == -1L);
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.served += (long)(this.pos - this.servedPos);
            int n3 = super.read(byArray, n, n2);
            this.servedPos = this.pos;
            if (n3 >= 0) {
                this.served += (long)n3;
            }
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            throw new RuntimeException("no skipping");
        }

        private void ensureLengthValid(int n) throws IOException {
            int n2;
            long l;
            int n3;
            int n4 = 1024;
            super.mark(n);
            byte[] byArray = new byte[Math.min(n, n4)];
            for (l = 0L; l < (long)n && (n3 = this.read(byArray, 0, n2 = (int)Math.min((long)n - l, (long)n4))) >= 0; l += (long)n3) {
            }
            if (l < (long)n) {
                throw new IOException("bad length value");
            }
            super.reset();
        }

        LimitedBuffer(InputStream inputStream) {
            super(null, 16384);
            this.servedPos = this.pos;
            this.in = new FilterInputStream(inputStream){

                @Override
                public int read() throws IOException {
                    if (buffered == limit) {
                        return -1;
                    }
                    ++buffered;
                    return super.read();
                }

                @Override
                public int read(byte[] byArray, int n, int n2) throws IOException {
                    int n3;
                    long l;
                    if (buffered == limit) {
                        return -1;
                    }
                    if (limit != -1L && (long)n2 > (l = limit - buffered)) {
                        n2 = (int)l;
                    }
                    if ((n3 = super.read(byArray, n, n2)) >= 0) {
                        buffered += (long)n3;
                    }
                    return n3;
                }
            };
        }
    }
}

