/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;

public class BasicResolverTests
extends TestCase {
    protected Catalog catalog;

    public static void main(String[] args) {
        TestRunner.run(BasicResolverTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        CatalogManager manager = new CatalogManager();
        int verbosity = manager.getVerbosity();
        this.catalog = new Catalog(manager);
        this.catalog.setupReaders();
        this.catalog.loadSystemCatalogs();
    }

    public void testResolveSystem() {
        String resolved = null;
        String local = "file:/local/system-resolver.dtd";
        try {
            resolved = this.catalog.resolveSystem("http://example.org/resolver.dtd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testResolvePublic() {
        String resolved = null;
        String local = "file:/local/public-resolver.dtd";
        try {
            resolved = this.catalog.resolvePublic("-//Apache//DTD Resolver Test//EN", "some-broken-system-identifier");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testRewriteSystem() {
        String resolved = null;
        String local = "file:/longest/path";
        try {
            resolved = this.catalog.resolveSystem("http://rewrite.example.org/longest/path");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testResolveURI() {
        String resolved = null;
        String local = "file:/local/uri";
        try {
            resolved = this.catalog.resolveURI("http://example.org/someURI");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testGroup() {
        String resolved = null;
        String local = "file:/local/other/uri";
        try {
            resolved = this.catalog.resolveURI("http://example.org/someOtherURI");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testDelegateSystem() {
        String resolved = null;
        String local = "file:/local/delegated/system-resolver.dtd";
        try {
            resolved = this.catalog.resolveSystem("http://delegate.example.org/resolver.dtd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testDocument() {
        String resolved = null;
        String local = "file:/default-document";
        try {
            resolved = this.catalog.resolveDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testSystemSuffix() {
        String resolved = null;
        String local = "file:/usr/local/xml/docbook/4.4/docbookx.dtd";
        try {
            resolved = this.catalog.resolveSystem("http://any/random/path/to/docbookx.dtd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }

    public void testUriSuffix() {
        String resolved = null;
        String local = "file:/usr/local/xsl/docbook/html/docbook.xsl";
        try {
            resolved = this.catalog.resolveURI("http://any/path/to/html/docbook.xsl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BasicResolverTests.assertTrue((boolean)local.equals(resolved));
    }
}

