/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import java.util.HashMap;
import org.apache.xerces.impl.dtd.models.CMAny;
import org.apache.xerces.impl.dtd.models.CMBinOp;
import org.apache.xerces.impl.dtd.models.CMLeaf;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.dtd.models.CMUniOp;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class DFAContentModel
implements ContentModelValidator {
    private static String fEpsilonString = "<<CMNODE_EPSILON>>";
    private static String fEOCString = "<<CMNODE_EOC>>";
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fMixed;
    private int fEOCPos = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private final QName fQName = new QName();

    static {
        fEpsilonString = fEpsilonString.intern();
        fEOCString = fEOCString.intern();
    }

    public DFAContentModel(CMNode syntaxTree, int leafCount, boolean mixed) {
        this.fLeafCount = leafCount;
        this.fMixed = mixed;
        this.buildDFA(syntaxTree);
    }

    @Override
    public int validate(QName[] children, int offset, int length) {
        if (length == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int curState = 0;
        int childIndex = 0;
        while (childIndex < length) {
            QName curElem = children[offset + childIndex];
            if (!this.fMixed || curElem.localpart != null) {
                int elemIndex = 0;
                while (elemIndex < this.fElemMapSize) {
                    String uri;
                    int type = this.fElemMapType[elemIndex] & 0xF;
                    if (type == 0 ? this.fElemMap[elemIndex].rawname == curElem.rawname : (type == 6 ? (uri = this.fElemMap[elemIndex].uri) == null || uri == curElem.uri : (type == 8 ? curElem.uri == null : type == 7 && this.fElemMap[elemIndex].uri != curElem.uri))) break;
                    ++elemIndex;
                }
                if (elemIndex == this.fElemMapSize) {
                    return childIndex;
                }
                if ((curState = this.fTransTable[curState][elemIndex]) == -1) {
                    return childIndex;
                }
            }
            ++childIndex;
        }
        if (!this.fFinalStateFlags[curState]) {
            return length;
        }
        return -1;
    }

    private void buildDFA(CMNode syntaxTree) {
        this.fQName.setValues(null, fEOCString, fEOCString, null);
        CMLeaf nodeEOC = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, syntaxTree, nodeEOC);
        this.fEOCPos = this.fLeafCount;
        nodeEOC.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int index = 0;
        while (index < this.fLeafCount) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
            ++index;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int outIndex = 0;
        while (outIndex < this.fLeafCount) {
            this.fElemMap[outIndex] = new QName();
            QName element = this.fLeafList[outIndex].getElement();
            int inIndex = 0;
            while (inIndex < this.fElemMapSize) {
                if (this.fElemMap[inIndex].rawname == element.rawname) break;
                ++inIndex;
            }
            if (inIndex == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues(element);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[outIndex];
                ++this.fElemMapSize;
            }
            ++outIndex;
        }
        int[] fLeafSorter = new int[this.fLeafCount + this.fElemMapSize];
        int fSortCount = 0;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int leafIndex = 0;
            while (leafIndex < this.fLeafCount) {
                QName leaf = this.fLeafList[leafIndex].getElement();
                QName element = this.fElemMap[elemIndex];
                if (leaf.rawname == element.rawname) {
                    fLeafSorter[fSortCount++] = leafIndex;
                }
                ++leafIndex;
            }
            fLeafSorter[fSortCount++] = -1;
            ++elemIndex;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        HashMap<CMStateSet, Integer> stateTable = new HashMap<CMStateSet, Integer>();
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(this.fEOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int sorterIndex = 0;
            int elemIndex2 = 0;
            while (elemIndex2 < this.fElemMapSize) {
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = fLeafSorter[sorterIndex++];
                while (leafIndex != -1) {
                    if (setT.getBit(leafIndex)) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    leafIndex = fLeafSorter[sorterIndex++];
                }
                if (!newSet.isEmpty()) {
                    int stateIndex;
                    Integer stateObj = (Integer)stateTable.get(newSet);
                    int n = stateIndex = stateObj == null ? curState : stateObj;
                    if (stateIndex == curState) {
                        statesToDo[curState] = newSet;
                        this.fTransTable[curState] = this.makeDefStateList();
                        stateTable.put(newSet, new Integer(curState));
                        ++curState;
                        newSet = null;
                    }
                    transEntry[elemIndex2] = stateIndex;
                    if (curState == curArraySize) {
                        int newSize = (int)((double)curArraySize * 1.5);
                        CMStateSet[] newToDo = new CMStateSet[newSize];
                        boolean[] newFinalFlags = new boolean[newSize];
                        int[][] newTransTable = new int[newSize][];
                        System.arraycopy(statesToDo, 0, newToDo, 0, curArraySize);
                        System.arraycopy(this.fFinalStateFlags, 0, newFinalFlags, 0, curArraySize);
                        System.arraycopy(this.fTransTable, 0, newTransTable, 0, curArraySize);
                        curArraySize = newSize;
                        statesToDo = newToDo;
                        this.fFinalStateFlags = newFinalFlags;
                        this.fTransTable = newTransTable;
                    }
                }
                ++elemIndex2;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode nodeCur) {
        if (nodeCur.type() == 4) {
            this.calcFollowList(((CMBinOp)nodeCur).getLeft());
            this.calcFollowList(((CMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 5) {
            this.calcFollowList(((CMBinOp)nodeCur).getLeft());
            this.calcFollowList(((CMBinOp)nodeCur).getRight());
            CMStateSet last = ((CMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((CMBinOp)nodeCur).getRight().firstPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 2 || nodeCur.type() == 3) {
            this.calcFollowList(((CMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 1) {
            this.calcFollowList(((CMUniOp)nodeCur).getChild());
        }
    }

    private void dumpTree(CMNode nodeCur, int level) {
        int index = 0;
        while (index < level) {
            System.out.print("   ");
            ++index;
        }
        int type = nodeCur.type();
        if (type == 4 || type == 5) {
            if (type == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (nodeCur.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(nodeCur.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(nodeCur.lastPos().toString());
            this.dumpTree(((CMBinOp)nodeCur).getLeft(), level + 1);
            this.dumpTree(((CMBinOp)nodeCur).getRight(), level + 1);
        } else if (nodeCur.type() == 2) {
            System.out.print("Rep Node ");
            if (nodeCur.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(nodeCur.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(nodeCur.lastPos().toString());
            this.dumpTree(((CMUniOp)nodeCur).getChild(), level + 1);
        } else if (nodeCur.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)nodeCur).getPosition() + "), " + ((CMLeaf)nodeCur).getElement() + "(elemIndex=" + ((CMLeaf)nodeCur).getElement() + ") ");
            if (nodeCur.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(nodeCur.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(nodeCur.lastPos().toString());
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fElemMapSize];
        int index = 0;
        while (index < this.fElemMapSize) {
            retArray[index] = -1;
            ++index;
        }
        return retArray;
    }

    private int postTreeBuildInit(CMNode nodeCur, int curIndex) {
        nodeCur.setMaxStates(this.fLeafCount);
        if ((nodeCur.type() & 0xF) == 6 || (nodeCur.type() & 0xF) == 8 || (nodeCur.type() & 0xF) == 7) {
            QName qname = new QName(null, null, null, ((CMAny)nodeCur).getURI());
            this.fLeafList[curIndex] = new CMLeaf(qname, ((CMAny)nodeCur).getPosition());
            this.fLeafListType[curIndex] = nodeCur.type();
            ++curIndex;
        } else if (nodeCur.type() == 4 || nodeCur.type() == 5) {
            curIndex = this.postTreeBuildInit(((CMBinOp)nodeCur).getLeft(), curIndex);
            curIndex = this.postTreeBuildInit(((CMBinOp)nodeCur).getRight(), curIndex);
        } else if (nodeCur.type() == 2 || nodeCur.type() == 3 || nodeCur.type() == 1) {
            curIndex = this.postTreeBuildInit(((CMUniOp)nodeCur).getChild(), curIndex);
        } else if (nodeCur.type() == 0) {
            QName node = ((CMLeaf)nodeCur).getElement();
            if (node.localpart != fEpsilonString) {
                this.fLeafList[curIndex] = (CMLeaf)nodeCur;
                this.fLeafListType[curIndex] = 0;
                ++curIndex;
            }
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM: type=" + nodeCur.type());
        }
        return curIndex;
    }
}

