/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynamic;

import java.util.Locale;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicAttributeIterator;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPropertyPointer;

public class DynamicPointer
extends PropertyOwnerPointer {
    private QName name;
    private Object bean;
    private DynamicPropertyHandler handler;
    private static final long serialVersionUID = -1842347025295904256L;

    public DynamicPointer(QName name, Object bean, DynamicPropertyHandler handler, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.handler = handler;
    }

    public DynamicPointer(NodePointer parent, QName name, Object bean, DynamicPropertyHandler handler) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.handler = handler;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new DynamicPropertyPointer((NodePointer)this, this.handler);
    }

    @Override
    public NodeIterator createNodeIterator(String property, boolean reverse, NodePointer startWith) {
        return new PropertyIterator(this, property, reverse, startWith);
    }

    @Override
    public NodeIterator attributeIterator(QName name) {
        return new DynamicAttributeIterator(this, name);
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public boolean isDynamicPropertyDeclarationSupported() {
        return true;
    }

    @Override
    public Object getBaseValue() {
        return this.bean;
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public String asPath() {
        return this.parent == null ? "/" : super.asPath();
    }

    public int hashCode() {
        return System.identityHashCode(this.bean) + this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynamicPointer)) {
            return false;
        }
        DynamicPointer other = (DynamicPointer)object;
        return this.bean == other.bean && this.name.equals(other.name);
    }
}

