/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.server;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.scf8.cluster.common.KscfClusterEventHandler;
import jp.co.extreme.scf8.cluster.common.KscfClusterNode;
import jp.co.extreme.web.server.WbsSiteContext;
import jp.co.extreme.web.servlet.WbsMainServlet;
import jp.co.extreme.web.session.WbsSessionManager;
import jp.co.extreme.web.session.WbsSessionManagerImpl;
import org.w3c.dom.Document;

public class WbsContainer
extends BcLoggableObject
implements KscfClusterEventHandler {
    protected Document webConfigDom;
    public WbsSiteContext siteContextDefault;
    public Map<Integer, WbsSiteContext> siteIdMap = new HashMap<Integer, WbsSiteContext>();
    public Map<String, WbsSiteContext> serverNameMap = new TreeMap<String, WbsSiteContext>();
    public int sessionManagerNo;
    protected WbsSessionManager httpSessionManager;
    public WbsMainServlet mainServlet;

    public void startService() throws Exception {
        this.getLogger().info("HtsvContainer is starting...");
        WbsSessionManagerImpl sessionManager = new WbsSessionManagerImpl();
        this.setHttpSessionManager(sessionManager);
        sessionManager.startSesionLifeCheck();
        this.getLogger().info("      manager no : " + this.sessionManagerNo);
        this.getLogger().info("  sessionTimeout : " + this.getSiteContextDefault().sessionTimeout);
        this.getLogger().info(" ");
    }

    public void endService() {
        this.getLogger().info("HtsvContainer is stopping...");
        if (this.httpSessionManager != null) {
            try {
                this.httpSessionManager.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }

    public WbsSessionManager getHttpSessionManager() {
        return this.httpSessionManager;
    }

    public void setHttpSessionManager(WbsSessionManager httpSessionManager) {
        this.httpSessionManager = httpSessionManager;
    }

    public WbsSiteContext getSiteContextDefault() {
        return this.siteContextDefault;
    }

    @Override
    public void nodeRemoved(KscfClusterNode clusterNode) {
        this.getLogger().info("FwWebContainer.nodeRemoved:clusterNode.id=" + clusterNode.id + " type=" + clusterNode.type);
        if (BcStringUtil.isEmpty(clusterNode.type)) {
            return;
        }
        if (clusterNode.type.indexOf("W") <= 0) {
            return;
        }
    }
}

