/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf6.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.util.List;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.charset.BcUtf8Util;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.etc.sql.ScfMmdServerUtil;
import jp.co.extreme.poi.PoiAbstractCsvWriter;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;

public class ApcmCsvWriterForDb
extends PoiAbstractCsvWriter {
    protected void outputHeader(Writer writer, ResultSetMetaData rsmd, List<BcTableColumn> tableColumnList) throws Exception {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            int idx = i + 1;
            String value = rsmd.getColumnName(idx);
            if (i > 0) {
                this.write(writer, this.exportCondition.fieldSeparator);
            }
            this.writeValue(writer, value, tableColumn.getMmdField());
            ++i;
        }
        this.write(writer, this.exportCondition.lineSeparator);
    }

    protected long outputRows(Writer writer, SqlResultSet rs, List<BcTableColumn> tableColumnList) throws Exception {
        long rowCount = 0L;
        while (rs.next()) {
            if (rowCount > 0L) {
                this.write(writer, this.exportCondition.lineSeparator);
            }
            ++rowCount;
            this.outputRow(writer, rs, tableColumnList);
        }
        if (this.exportCondition.lineSeparatorLast) {
            this.write(writer, this.exportCondition.lineSeparator);
        }
        return rowCount;
    }

    protected void outputRow(Writer writer, SqlResultSet rs, List<BcTableColumn> tableColumnList) throws Exception {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            int idx = i + 1;
            Object value = rs.getObject(idx);
            String strValue = BcStringUtil.toString(value);
            if (i > 0) {
                this.write(writer, this.exportCondition.fieldSeparator);
            }
            this.writeValue(writer, strValue, tableColumn.getMmdField());
            ++i;
        }
    }

    public long output(DtsSession dtsSession, String sql, Writer writer) throws Exception {
        this.getLogger().debug("output:sql=" + sql);
        long rowCount = 0L;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            EtcRsmdSupplement rsmdSupplement = null;
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, rsmdSupplement);
            if (this.exportCondition.headerEnabled) {
                this.outputHeader(writer, rsmd, tableColumnList);
            }
            rowCount = this.outputRows(writer, rs, tableColumnList);
            rs.close();
        }
        return rowCount;
    }

    public long output(DtsSession dtsSession, String sql, File destFile) throws Exception {
        this.getLogger().info("\u51fa\u529b\u5148=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        long rowCount = 0L;
        Throwable throwable = null;
        Object var7_7 = null;
        try (FileOutputStream os = new FileOutputStream(destFile, false);){
            if (BcStringUtil.equalsIgnoreCase(this.exportCondition.encoding, BcCharsetNames.UTF_8.value) && this.exportCondition.bomEnabled) {
                os.write(BcUtf8Util.bomBytes);
            }
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, this.exportCondition.encoding);){
                rowCount = this.output(dtsSession, sql, writer);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return rowCount;
    }
}

