/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import java.util.Collection;
import java.util.List;
import javafx.scene.control.TableView;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.table.FxTableColumn;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.scf3.client.ScfSqlClientTask;

public class HfxTableLoadTask
extends ScfSqlClientTask {
    private TableView tableView;
    private BcTableContext tableContext;
    private BcMonitor monitor = new BcMonitor();

    @Override
    public void tableColumnReceived(final List<BcTableColumn> bcTableColumnList, int rowSize, BcTableContext tableContext) throws Exception {
        super.tableColumnReceived(bcTableColumnList, rowSize, tableContext);
        this.monitor.lock();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    List<FxTableColumn> tableColumnList = HfxTableLoadTask.this.covertTableColumn(bcTableColumnList);
                    HfxTableLoadTask.this.tableView.getColumns().addAll(tableColumnList);
                    HfxTableLoadTask.this.monitor.unLock();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.monitor.sync();
        this.tableContext = tableContext;
    }

    public List<FxTableColumn> covertTableColumn(Collection<? extends BcTableColumn> bcTableColumnCollection) throws Exception {
        List<FxTableColumn> tableColumnList = FxTableUtil.createTableColumnList(bcTableColumnCollection, null);
        return tableColumnList;
    }

    @Override
    public void rowListReceived(final List<List> rowList) throws Exception {
        super.rowListReceived(rowList);
        this.monitor.lock();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxTableLoadTask.this.tableView.getItems().addAll((Collection)rowList);
                    HfxTableLoadTask.this.monitor.unLock();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.monitor.sync();
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public void setTableView(TableView tableView) {
        this.tableView = tableView;
    }

    public BcTableContext getTableContext() {
        return this.tableContext;
    }
}

