/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf.common.ScfHandleManager;
import jp.co.extreme.scf.common.ScfHandleResource;

public class ScfHandleImpl
implements ScfHandle {
    private String handleId;
    private Long startTime;
    private long timeout = -1L;
    private Long lastAccessTime;
    private long accessCount;
    private List<ScfHandleResource> resourceList = new ArrayList<ScfHandleResource>();
    private Object owner;
    private String note;
    private ScfHandleManager handleManager;

    @Override
    public String getHandleId() {
        return this.handleId;
    }

    @Override
    public void setHandleId(String handleId) {
        this.handleId = handleId;
    }

    @Override
    public Long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long lifeSpan) {
        this.timeout = lifeSpan;
    }

    @Override
    public Long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTime(Long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public void incrementAccessCount() {
        ++this.accessCount;
    }

    @Override
    public long getAccessCount() {
        return this.accessCount;
    }

    @Override
    public ScfHandleResource getHandleResource(int index) throws Exception {
        return this.resourceList.get(index);
    }

    @Override
    public void addHandleResource(ScfHandleResource handleResource) {
        this.resourceList.add(handleResource);
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public ScfHandleManager getHandleManager() {
        return this.handleManager;
    }

    @Override
    public void setHandleManager(ScfHandleManager handleManager) {
        this.handleManager = handleManager;
    }

    @Override
    public void close() throws Exception {
        if (this.resourceList != null) {
            ScfHandleResource[] sandleResources = this.resourceList.toArray(new ScfHandleResource[0]);
            int i = 0;
            while (i < sandleResources.length) {
                try {
                    sandleResources[i].releaseResource();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i;
            }
            this.resourceList.clear();
            this.resourceList = null;
        }
        this.owner = null;
        this.note = null;
    }
}

