/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.orm.persistence;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.entity.OrmAddOnly;
import jp.co.extreme.orm.entity.OrmAddition;
import jp.co.extreme.orm.entity.OrmEntityId;
import jp.co.extreme.orm.entity.OrmGeneralData;
import jp.co.extreme.orm.entity.OrmObjectId;
import jp.co.extreme.orm.entity.OrmOverwrite;
import jp.co.extreme.orm.persistence.OrmEntityContext;
import jp.co.extreme.orm.persistence.OrmEntityContextManager;
import jp.co.extreme.orm.persistence.OrmPersistence;
import jp.co.extreme.orm.persistence.OrmPersistenceAddOnly;
import jp.co.extreme.orm.persistence.OrmPersistenceAddition;
import jp.co.extreme.orm.persistence.OrmPersistenceApplyPeriodDate;
import jp.co.extreme.orm.persistence.OrmPersistenceApplyPeriodTimestamp;
import jp.co.extreme.orm.persistence.OrmPersistenceDataId;
import jp.co.extreme.orm.persistence.OrmPersistenceDomain;
import jp.co.extreme.orm.persistence.OrmPersistenceObjectId;
import jp.co.extreme.orm.persistence.OrmPersistenceOverwrite;
import jp.co.extreme.orm.persistence.OrmPersistenceTreeNode;
import jp.co.extreme.orm.persistence.OrmPersistenceUtil;
import jp.co.extreme.sql.SqlPreparedStatement;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlUpdateQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class OrmPersistenceProxy
extends BcLoggableObject {
    protected List<OrmPersistence> persistenceList;
    protected OrmPersistenceAddition persistenceAddition = new OrmPersistenceAddition();
    protected OrmPersistenceDataId persistenceDataId = new OrmPersistenceDataId();
    protected OrmPersistenceAddOnly persistenceAddOnly = new OrmPersistenceAddOnly();
    protected OrmPersistenceOverwrite persistenceOverwrite = new OrmPersistenceOverwrite();
    public boolean logEnabled = false;

    private OrmPersistenceProxy() {
        this.persistenceList = new ArrayList<OrmPersistence>();
        this.persistenceList.add(new OrmPersistenceObjectId());
        this.persistenceList.add(this.persistenceDataId);
        this.persistenceList.add(this.persistenceAddition);
        this.persistenceList.add(new OrmPersistenceAddOnly());
        this.persistenceList.add(new OrmPersistenceOverwrite());
        this.persistenceList.add(new OrmPersistenceApplyPeriodTimestamp());
        this.persistenceList.add(new OrmPersistenceApplyPeriodDate());
        this.persistenceList.add(new OrmPersistenceTreeNode());
        this.persistenceList.add(new OrmPersistenceDomain());
    }

    public static OrmPersistenceProxy getInstance() {
        return SingletonHolder.instance;
    }

    protected void log(BcLogger logger, Object log) {
        if (this.logEnabled) {
            logger.debug(log);
        }
    }

    public int logicalDeleteByDataId(DtsSession dtsSession, String tableName, long entityId, BcLogger logger) throws Exception {
        int objectId = this.getObjectIdNewest(dtsSession, tableName, entityId);
        this.getLogger().debug("logicalDeleteByDataId:objectId = " + objectId);
        return OrmPersistenceAddition.logicalDeleted(dtsSession, tableName, objectId, logger);
    }

    public int logicalDeleteByDataId(DtsSession dtsSession, String tableName, long entityId) throws Exception {
        return this.logicalDeleteByDataId(dtsSession, tableName, entityId, this.getLogger());
    }

    public int logicalDeleteByObjectId(DtsSession dtsSession, String tableName, long objectId, int userId, BcLogger logger) throws Exception {
        this.getLogger().debug("logicalDeleteByObjectId:objectId = " + objectId);
        return OrmPersistenceAddition.logicalDeleted(dtsSession, tableName, objectId, userId, logger);
    }

    public int physicalDeleteByObjectId(DtsSession dtsSession, String tableName, long objectId) throws Exception {
        boolean deletedCount = false;
        String sql = "DELETE FROM " + tableName + " WHERE " + "sy_oid" + "=" + objectId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), sql);
    }

    public int physicalDeleteByEntityId(DtsSession dtsSession, String tableName, long entityId) throws Exception {
        boolean deletedCount = false;
        String sql = "DELETE FROM " + tableName + " WHERE " + "id" + "=" + entityId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), sql);
    }

    public StringBuilder createCommonSetPhrase(SqlContext sqlContext, Object entity) throws Exception {
        ArrayList<String> phraseList = new ArrayList<String>();
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.setSetClause(sqlContext, phraseList, entity);
            ++i;
        }
        StringBuilder sb = new StringBuilder(256);
        int i2 = 0;
        while (i2 < phraseList.size()) {
            if (i2 == 0) {
                sb.append(" ");
            } else {
                sb.append(",");
            }
            sb.append((String)phraseList.get(i2));
            ++i2;
        }
        return sb;
    }

    public void createCommonSetPhrase(SqlUpdateQuery updateQuery, Object entity) throws Exception {
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.setSetClause(updateQuery, entity);
            ++i;
        }
    }

    public String createCommonSelectPhrase(Class javaClassType, String tableAlias) throws Exception {
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.getSelectColumnName(columnNameList, tableAlias, javaClassType);
            ++i;
        }
        StringBuilder sb = new StringBuilder(256);
        int i2 = 0;
        while (i2 < columnNameList.size()) {
            if (i2 == 0) {
                sb.append(' ');
            } else {
                sb.append(',');
            }
            sb.append((String)columnNameList.get(i2));
            ++i2;
        }
        return sb.toString();
    }

    public String createCommonSelectPhrase(Class entityClass) throws Exception {
        return this.createCommonSelectPhrase(entityClass, null);
    }

    public void transResultset(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity) throws Exception {
        int i = 0;
        while (i < this.persistenceList.size()) {
            OrmPersistence persistence = this.persistenceList.get(i);
            persistence.setResultSet(dtsSession, rs, columnIndex, entity);
            ++i;
        }
    }

    public String createObjectIdWhereClause(long objectId) throws Exception {
        return " WHERE sy_oid=" + objectId;
    }

    public String createWhereClause(OrmObjectId objectIdentity) throws Exception {
        return this.createObjectIdWhereClause(objectIdentity.getObjectId());
    }

    public String createDataIdWhereClause(long entityId) throws Exception {
        return " WHERE id=" + entityId;
    }

    public String createDataIdWhereClause(OrmEntityId entityId) throws Exception {
        return this.createDataIdWhereClause(entityId.getEntityId());
    }

    public void createWhereClause(OrmGeneralData generalData, SqlUpdateQuery updateQuery) throws Exception {
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            if (mmdField.columnName.equals("sy_oid")) {
                Object valueObject = generalData.getValue(i);
                SqlWhereElement whereElement = new SqlWhereElement();
                whereElement.setLogical_AND();
                whereElement.setFormula("sy_oid" + SqlUtil.toWhere("=", valueObject, mmdField.sqlTypeId));
                updateQuery.addWhereElement(whereElement);
            }
            ++i;
        }
    }

    public int putEntity(DtsSession dtsSession, int userId, String tableName, List<String> columnList, List<Object> valueList, Object entity, boolean isInsertCheck) throws Exception {
        Class<?> entityClass = entity.getClass();
        int updateCount = 0;
        if (OrmAddition.class.isAssignableFrom(entityClass)) {
            updateCount = this.persistenceAddition.putEntity(dtsSession, this, tableName, columnList, valueList, entity, isInsertCheck);
        } else if (OrmEntityId.class.isAssignableFrom(entityClass)) {
            updateCount = this.persistenceDataId.putEntity(dtsSession, this, tableName, columnList, valueList, entity, isInsertCheck);
        }
        return updateCount;
    }

    public int putEntity(DtsSession dtsSession, int userId, String tableName, List<String> columnList, List<Object> valueList, Object entity) throws Exception {
        return this.putEntity(dtsSession, userId, tableName, columnList, valueList, entity, true);
    }

    public int putEntity(DtsSession dtsSession, String tableName, List<String> columnList, List<Object> valueList, Object entity) throws Exception {
        return this.putEntity(dtsSession, -1, tableName, columnList, valueList, entity);
    }

    public int putEntitys_1(DtsSession dtsSession, int userId, String tableName, int manipulationPolicy, BcLogger logger, Object ... entitys) throws Exception {
        if (entitys.length <= 0) {
            logger.warning("putEntity:entitys.length=" + entitys.length);
            return 0;
        }
        SqlContext sqlContext = dtsSession.getSqlContext();
        Class<?> entityClass = entitys[0].getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        List<Integer> sqlTypeList1 = entityContext.getSqlTypeList(dtsSession, tableName);
        SqlUpdateQuery updateQuery = entityContext.getUpdateQuery(sqlContext, tableName);
        String updateQueryStr = null;
        SqlStatement ppstUpdate = null;
        boolean duUpdate = true;
        if (manipulationPolicy == 1) {
            duUpdate = false;
        } else if (BcCollectionUtil.isEmpty(updateQuery.getWhereElementList())) {
            duUpdate = false;
        }
        if (duUpdate) {
            updateQueryStr = sqlContext.buildUpdateQueryForPrepareStatement(updateQuery);
            this.log(logger, "updateQueryStr=" + updateQueryStr);
            ppstUpdate = dtsSession.getConnection().prepareStatement(updateQueryStr);
        }
        String insertSqlStr = null;
        SqlStatement ppstInsert = null;
        List<Object> valueList = null;
        int updateSummaryCount = 0;
        try {
            try {
                int i = 0;
                while (i < entitys.length) {
                    Object entity = entitys[i];
                    if (manipulationPolicy != 1) {
                        entityContext.autoSequence(dtsSession, tableName, entity);
                        if (OrmAddition.class.isAssignableFrom(entityClass)) {
                            this.persistenceAddition.preTrans(dtsSession, userId, tableName, entity);
                        } else if (OrmEntityId.class.isAssignableFrom(entityClass)) {
                            if (OrmAddOnly.class.isAssignableFrom(entityClass)) {
                                this.persistenceAddOnly.preTrans(dtsSession, userId, tableName, entity);
                            }
                            if (OrmOverwrite.class.isAssignableFrom(entityClass)) {
                                this.persistenceOverwrite.preTrans(dtsSession, userId, tableName, entity);
                            }
                            this.persistenceDataId.preTrans(dtsSession, tableName, entity);
                        }
                    }
                    BcInteger typeIndex = new BcInteger();
                    ArrayList<Integer> sqlTypeList2 = new ArrayList<Integer>();
                    valueList = entityContext.createValueList(entity, true, sqlTypeList1, sqlTypeList2, typeIndex, null);
                    this.log(logger, "valueList=" + valueList);
                    int updateCount = 0;
                    if (ppstUpdate != null) {
                        updateCount = this.putEntity_update(dtsSession, entityContext, sqlTypeList2, valueList, tableName, (SqlPreparedStatement)ppstUpdate, entity, logger);
                        this.log(logger, "updateCount#1=" + updateCount);
                    }
                    if (updateCount <= 0) {
                        if (ppstInsert == null) {
                            insertSqlStr = entityContext.getInsertQueryText(sqlContext, tableName);
                            this.log(logger, "insertSqlStr=" + insertSqlStr);
                            ppstInsert = dtsSession.getConnection().prepareStatement(insertSqlStr);
                        }
                        updateCount = this.putEntity_insert(dtsSession, sqlTypeList2, valueList, (SqlPreparedStatement)ppstInsert, logger);
                        this.log(logger, "putEntity:updateCount#2=" + updateCount);
                    }
                    updateSummaryCount += updateCount;
                    if ((i + 1) % 100 == 0) {
                        logger.info("putEntity:" + tableName + " [" + (i + 1) + "/" + entitys.length + "]");
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                logger.error("updateQueryStr=" + updateQueryStr);
                logger.error("insertSqlStr=" + insertSqlStr);
                logger.error("valueList=" + valueList);
                throw ex;
            }
        }
        finally {
            if (ppstUpdate != null) {
                ppstUpdate.close();
            }
            if (ppstInsert != null) {
                ppstInsert.close();
            }
        }
        return updateSummaryCount;
    }

    public int putEntitys_1(DtsSession dtsSession, int userId, String tableName, boolean insertOnly, Object ... entitys) throws Exception {
        int manipulationPolicy = 0;
        if (insertOnly) {
            manipulationPolicy = 1;
        }
        return this.putEntitys_1(dtsSession, userId, tableName, manipulationPolicy, this.getLogger(), entitys);
    }

    public int putEntitys_2(DtsSession dtsSession, int userId, String tableName, Object ... entitys) throws Exception {
        return this.putEntitys_1(dtsSession, userId, tableName, false, entitys);
    }

    public int putEntitys_3(DtsSession dtsSession, String tableName, Object ... entitys) throws Exception {
        return this.putEntitys_2(dtsSession, -1, tableName, entitys);
    }

    public int putEntityCollection(DtsSession dtsSession, int userId, String tableName, boolean insertOnly, Collection entityCollection) throws Exception {
        return this.putEntitys_1(dtsSession, userId, tableName, insertOnly, entityCollection.toArray());
    }

    public int putEntityCollection(DtsSession dtsSession, int userId, String tableName, Collection entityCollection) throws Exception {
        return this.putEntityCollection(dtsSession, userId, tableName, false, entityCollection);
    }

    public int putEntityCollection(DtsSession dtsSession, String tableName, Collection entityCollection) throws Exception {
        return this.putEntityCollection(dtsSession, -1, tableName, entityCollection);
    }

    protected int putEntity_update(DtsSession dtsSession, OrmEntityContext entityContext, List<Integer> sqlTypeIdList, List<Object> valueList, String tableName, SqlPreparedStatement ppstUpdate, Object entity, BcLogger logger) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        sqlContext.setPreStmtValues(ppstUpdate, sqlTypeIdList, valueList);
        BcInteger primaryKeyOffset = new BcInteger();
        primaryKeyOffset.value = valueList.size();
        entityContext.setPrimaryKeyValue(dtsSession, ppstUpdate, tableName, primaryKeyOffset, entity);
        return ppstUpdate.executeUpdate();
    }

    protected int putEntity_insert(DtsSession dtsSession, List<Integer> sqlTypeIdList, List<Object> valueList, SqlPreparedStatement ppstInsert, BcLogger logger) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        sqlContext.setPreStmtValues(ppstInsert, sqlTypeIdList, valueList);
        return ppstInsert.executeUpdate();
    }

    public int deleteEntity(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlUpdateQuery updateQuery = entityContext.getUpdateQuery(sqlContext, tableName);
        String query = sqlContext.buildDeleteQuery(updateQuery);
        this.log(this.getLogger(), "query" + query);
        int updateCount = 0;
        try (SqlPreparedStatement ppst = dtsSession.getConnection().prepareStatement(query);){
            entityContext.setPrimaryKeyValue(dtsSession, ppst, tableName, entity);
            updateCount = ppst.executeUpdate();
        }
        return updateCount;
    }

    public String createSelectColumnPhrase(Class entityClass, String tableAlias) throws Exception {
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        return entityContext.getSelectColumnPhrase(tableAlias);
    }

    public String createSelectColumnPhrase(Class entityClass) throws Exception {
        return this.createSelectColumnPhrase(entityClass, null);
    }

    public boolean getEntity(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = entityContext.getSelectQuery(sqlContext, tableName);
        String query = sqlContext.buildSelectQuery(selectQuery);
        boolean dataExits = false;
        try (SqlPreparedStatement ppst1 = dtsSession.getConnection().prepareStatement(query);){
            entityContext.setPrimaryKeyValue(dtsSession, ppst1, tableName, entity);
            SqlResultSet rs = ppst1.executeQuery();
            if (rs.next()) {
                this.getEntity(dtsSession, rs, entity);
                dataExits = true;
            }
        }
        return dataExits;
    }

    protected void getEntity_ArrayFiled(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object array) throws Exception {
        Class<?> componentType = array.getClass().getComponentType();
        int arrayLength = Array.getLength(array);
        int i = 0;
        while (i < arrayLength) {
            this.getEntity_ArrayFiled_L2(dtsSession, rs, columnIndex, array, componentType, i);
            ++i;
        }
    }

    protected void getEntity_ArrayFiled_L2(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object array, Class componentType, int index) throws Exception {
        if (componentType.isPrimitive()) {
            this.setPrimitiveAyrrayValue(rs, columnIndex, array, componentType, index);
        } else if (BcLangUtil.isWrapperClass(componentType) || componentType.equals(String.class)) {
            Object value1 = rs.getObject(columnIndex);
            Object value2 = BcObjectConvertor.getInstance().convert(value1, componentType);
            Array.set(array, index, value2);
        } else {
            Object arrayElement = Array.get(array, index);
            if (arrayElement != null) {
                if (arrayElement.getClass().isArray()) {
                    this.getEntity_ArrayFiled(dtsSession, rs, columnIndex, arrayElement);
                } else {
                    this.getEntity(dtsSession, rs, columnIndex, arrayElement);
                }
            } else {
                this.getEntity(dtsSession, rs, columnIndex, arrayElement);
            }
        }
    }

    protected void setPrimitiveAyrrayValue(SqlResultSet rs, BcInteger columnIndex, Object array, Class componentType, int index) throws Exception {
        if (Integer.TYPE.isAssignableFrom(componentType)) {
            Array.setInt(array, index, rs.getInt(columnIndex));
        } else if (Short.TYPE.isAssignableFrom(componentType)) {
            Array.setShort(array, index, rs.getShort(columnIndex));
        } else if (Long.TYPE.isAssignableFrom(componentType)) {
            Array.setLong(array, index, rs.getLong(columnIndex));
        } else if (Byte.TYPE.isAssignableFrom(componentType)) {
            Array.setByte(array, index, rs.getByte(columnIndex));
        } else if (Double.TYPE.isAssignableFrom(componentType)) {
            Array.setDouble(array, index, rs.getDouble(columnIndex));
        } else if (Float.TYPE.isAssignableFrom(componentType)) {
            Array.setFloat(array, index, rs.getFloat(columnIndex));
        } else if (Character.TYPE.isAssignableFrom(componentType)) {
            Array.setChar(array, index, rs.getChar(columnIndex));
        } else if (Boolean.TYPE.isAssignableFrom(componentType)) {
            Array.setBoolean(array, index, rs.getBoolean(columnIndex));
        } else {
            throw new Exception(String.valueOf(componentType.getName()) + " is not primitive.");
        }
    }

    protected void getEntity_field(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity, Field field) throws Exception {
        if (!OrmPersistenceUtil.isPersistence(field)) {
            return;
        }
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            Object array = field.get(entity);
            this.getEntity_ArrayFiled(dtsSession, rs, columnIndex, array);
        } else if (OrmPersistenceUtil.isPersistence(fieldType)) {
            Object jdbcValue = rs.getObject(columnIndex);
            SqlContext sqlContext = dtsSession.getSqlContext();
            Object fieldValue = sqlContext.toCommonTypeValue(jdbcValue);
            fieldValue = BcObjectConvertor.getInstance().convert(fieldValue, fieldType);
            BcReflectUtil.setFieldValue(field, entity, fieldValue);
        } else {
            Object entity2 = BcReflectUtil.getFieldValue(field, entity);
            OrmEntityContext entityContext2 = OrmEntityContextManager.getInstance().getEntityContext(fieldType);
            List<Field> fieldList2 = entityContext2.getFieldList();
            int i = 0;
            while (i < fieldList2.size()) {
                Field field2 = fieldList2.get(i);
                this.getEntity_field(dtsSession, rs, columnIndex, entity2, field2);
                ++i;
            }
        }
    }

    protected void getEntity(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object entity) throws Exception {
        Class<?> entityClass = entity.getClass();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(entityClass);
        int i = 0;
        while (i < entityContext.getFieldList().size()) {
            Field field = entityContext.getFieldList().get(i);
            this.getEntity_field(dtsSession, rs, columnIndex, entity, field);
            ++i;
        }
        i = 0;
        while (i < entityContext.getSetterMethodList().size()) {
            Method setterMehtod = entityContext.getSetterMethodList().get(i);
            Object jdbcValue = rs.getObject(columnIndex);
            Object fieldValue = dtsSession.getSqlContext().toCommonTypeValue(jdbcValue);
            fieldValue = BcObjectConvertor.getInstance().convert(fieldValue, setterMehtod.getParameterTypes()[0]);
            setterMehtod.invoke(entity, fieldValue);
            ++i;
        }
    }

    public void getEntity(DtsSession dtsSession, SqlResultSet rs, Object entity) throws Exception {
        BcInteger columnIndex = new BcInteger();
        this.getEntity(dtsSession, rs, columnIndex, entity);
    }

    public int getObjectIdNewest(DtsSession dtsSession, String tableName, String columnName, long entityId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int objectId = -1;
        String query = "SELECT sy_oid FROM " + tableName + " WHERE " + columnName + "=" + entityId + " AND " + "sy_noid" + "=" + -1 + " ORDER BY " + "sy_oid" + " DESC";
        query = sqlContext.setLimit(query, 1L, -1L);
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                objectId = rs.getInt(1);
            }
            rs.close();
        }
        return objectId;
    }

    public int getObjectIdNewest(DtsSession dtsSession, String tableName, long entityId) throws Exception {
        return this.getObjectIdNewest(dtsSession, tableName, "id", entityId);
    }

    /* synthetic */ OrmPersistenceProxy(OrmPersistenceProxy ormPersistenceProxy) {
        this();
    }

    private static final class SingletonHolder {
        private static final OrmPersistenceProxy instance = new OrmPersistenceProxy(null);

        private SingletonHolder() {
        }
    }
}

