/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpNounFinderHelper;
import jp.co.extreme.nlp.NlpToken;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpUtil;
import jp.co.extreme.nlp.NlpWord;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;

public class NlpPersonNameFinderEN2
extends BcLoggableObject {
    private POSTaggerME posTagger;
    private NounFinderHelper nounFinderHelper = new NounFinderHelper();
    private List<Map<String, NlpWord>> wordMapList = new ArrayList<Map<String, NlpWord>>();

    public void addWordMap(Map<String, NlpWord> wordMap) throws Exception {
        this.wordMapList.add(wordMap);
    }

    public void init() throws Exception {
        InputStream modelIn = this.getClass().getResourceAsStream("en-pos-maxent-1.5.bin");
        POSModel posModel = new POSModel(modelIn);
        this.posTagger = new POSTaggerME(posModel);
        modelIn.close();
    }

    public List<NlpElement> partOfSpeech(String[] sentenceArray) throws Exception {
        String[] tags = this.getTags(sentenceArray);
        ArrayList<NlpTokenWrap> tokenWrapList = new ArrayList<NlpTokenWrap>();
        int i = 0;
        while (i < sentenceArray.length) {
            NlpToken nlpToken = new NlpToken();
            nlpToken.surface = sentenceArray[i];
            nlpToken.posLevel1 = tags[i];
            NlpTokenWrap nlpTokenWrap = new NlpTokenWrap();
            nlpTokenWrap.token = nlpToken;
            tokenWrapList.add(nlpTokenWrap);
            ++i;
        }
        List<NlpElement> elementList = this.nounFinderHelper.find(tokenWrapList);
        if (!BcCollectionUtil.isEmpty(elementList)) {
            int i2 = 0;
            while (i2 < elementList.size()) {
                NlpElement nlpElement = elementList.get(i2);
                nlpElement.tokenWrapList = tokenWrapList;
                ++i2;
            }
        }
        return elementList;
    }

    public String[] getTags(String[] sentenceArray) throws Exception {
        if (this.posTagger == null) {
            this.init();
        }
        String[] tags = this.posTagger.tag(sentenceArray);
        return tags;
    }

    public String getTag(String sentence) throws Exception {
        String[] sentenceArray = new String[]{sentence};
        String[] tags = this.getTags(sentenceArray);
        return tags[0];
    }

    NlpWord getNoun(List<NlpTokenWrap> tokenWrapList) throws Exception {
        String key = NlpUtil.toStringForEN(tokenWrapList);
        NlpWord word = null;
        for (Map<String, NlpWord> wordMap : this.wordMapList) {
            word = wordMap.get(key);
            if (word != null) break;
        }
        return word;
    }

    class NounFinderHelper
    extends NlpNounFinderHelper {
        NounFinderHelper() {
        }

        @Override
        protected boolean isSkip(NlpTokenWrap tokenWrap1) throws Exception {
            return !NlpUtil.EnglishPartOfSpeech.NNP.name().equalsIgnoreCase(tokenWrap1.token.posLevel1) && !NlpUtil.EnglishPartOfSpeech.NN.name().equalsIgnoreCase(tokenWrap1.token.posLevel1) && !".".equals(tokenWrap1.token.posLevel1);
        }

        @Override
        NlpWord getNoun(List<NlpTokenWrap> tokenWrapList) throws Exception {
            return NlpPersonNameFinderEN2.this.getNoun(tokenWrapList);
        }
    }
}

