/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.web;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.Future;
import javax.servlet.DispatcherType;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.module.xdts.web.XdtsDataViewMenuWCB;
import jp.co.extreme.module.xfil.web.XfilFileListWCB;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.web.XwebMainServlet;
import jp.co.extreme.task.TskAbstractCallable2;
import jp.co.extreme.web.server.WbsContainer;
import jp.co.extreme.web.server.WbsResourceHolder;
import jp.co.extreme.web.server.WbsSiteContext;
import jp.co.extreme.web.servlet.WbsFilter;
import jp.co.extreme.web.servlet.WbsFrontServlet;
import jp.co.extreme.web.servlet.WbsServletContextListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

class XsysHttpServerTask
extends TskAbstractCallable2
implements LifeCycle.Listener {
    public Future future;
    public WbsSiteContext siteContext;
    public String hostName;
    public int port;
    public int sessionTimeout;
    public Server server;
    public String url;
    public Exception connectException;

    public XsysHttpServerTask() {
        this.setName(XsysWords.getInstance().WEB_Server);
    }

    public Object taskProcess() throws Exception {
        WbsContainer webContainer;
        this.connectException = null;
        this.siteContext.sessionValidationInterval = 60;
        this.siteContext.sessionTimeout = this.sessionTimeout;
        String resourceDirPath = "${APP}web_server/resource";
        File resourceDir = new File(AfbApplication.getInstance().toReal(resourceDirPath));
        this.getLogger().info("start:resourceDir=" + resourceDir.getPath());
        this.siteContext.resourceDirList.clear();
        this.siteContext.resourceDirList.add(new File(resourceDir, "option"));
        this.siteContext.resourceDirList.add(new File(resourceDir, "default"));
        this.siteContext.resourceDirList.add(resourceDir);
        this.siteContext.theme = "dark_gray_blue";
        AfbApplication application = AfbApplication.getInstance();
        String appType = application.properties.getProperty("type");
        String siteName = null;
        if (XsysConstants.AppType.DatabaseClient.appType.equals(appType)) {
            String function = EtcEnumStrUtil.toElement(WbxConstants.SiteFunction.dbTool.name());
            this.siteContext.propertyMap.put(WbxConstants.SitePropertyKey.function.name(), function);
            siteName = "Database Search Service";
            this.siteContext.homePath = XdtsDataViewMenuWCB.Method.dataViewMenu.getPath();
        } else if (XsysConstants.AppType.MovieFiler.appType.equals(appType)) {
            siteName = "Video Service";
            this.siteContext.homePath = XfilFileListWCB.Method.form.getPath();
        }
        WbsResourceHolder.getInstance().webContainer = webContainer = new WbsContainer();
        webContainer.siteContextDefault = this.siteContext;
        String serverName = String.valueOf(this.hostName) + ":" + this.port;
        webContainer.serverNameMap.put(serverName, this.siteContext);
        webContainer.mainServlet = new XwebMainServlet();
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.addFilter(WbsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder servletHolderRoot = new ServletHolder(WbsFrontServlet.class);
        servletContextHandler.addServlet(servletHolderRoot, "/");
        WbsServletContextListener servletContextListener = new WbsServletContextListener();
        servletContextListener.appStart = false;
        servletContextHandler.addEventListener((EventListener)((Object)servletContextListener));
        HandlerList handlerList = new HandlerList();
        handlerList.addHandler((Handler)servletContextHandler);
        this.server = new Server();
        this.server.setHandler((Handler)handlerList);
        ArrayList<ServerConnector> serverConnectorList = new ArrayList<ServerConnector>();
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add(this.hostName);
        int i = 0;
        while (i < hostList.size()) {
            String host = (String)hostList.get(i);
            ServerConnector serverConnector = new ServerConnector(this.server);
            serverConnector.setHost(host);
            serverConnector.setPort(this.port);
            serverConnectorList.add(serverConnector);
            ++i;
        }
        ServerConnector[] serverConnectors = serverConnectorList.toArray(new ServerConnector[0]);
        this.getLogger().info("Server Connector count=" + serverConnectors.length);
        this.server.setConnectors((Connector[])serverConnectors);
        this.server.addLifeCycleListener((LifeCycle.Listener)this);
        this.server.start();
        this.server.join();
        return null;
    }

    public void lifeCycleStarting(LifeCycle lifeCycle) {
        this.getLogger().info(String.valueOf(XsysWords.getInstance().WEB_Server) + " is starting...");
    }

    public void lifeCycleStarted(LifeCycle lifeCycle) {
        this.getLogger().info(String.valueOf(XsysWords.getInstance().WEB_Server) + " is started.");
        this.getLogger().info("Connecting to '" + this.url + "'...");
        try {
            Document document = Jsoup.connect((String)this.url).timeout(180000).get();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            this.connectException = ex;
        }
    }

    public void lifeCycleStopping(LifeCycle lifeCycle) {
        this.getLogger().info(String.valueOf(XsysWords.getInstance().WEB_Server) + " is stopping...");
    }

    public void lifeCycleStopped(LifeCycle lifeCycle) {
        this.getLogger().info(String.valueOf(XsysWords.getInstance().WEB_Server) + " is stopped.");
    }

    public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
        this.handleException(throwable);
    }
}

