/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.rmo;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.webserver.WebServerController;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.server.XdtsMenuCreator;
import jp.co.extreme.module.xdts.server.XdtsUserMenu;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.server.XsysServerUtil;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf.server.ScfServerLogger;
import jp.co.extreme.scf.server.ScfServerLoggerManager;
import jp.co.extreme.scf5.dao.ScfAbstractIntPropertyDAO;
import jp.co.extreme.scf5.dao.ZScfPropertyDAOManager;
import jp.co.extreme.scf5.model.ZScfIntProperties;
import jp.co.extreme.web.server.WbsSiteContext;

public class XsysWebServerRMO
extends RmiAbstractRMO {
    public void getSiteContext(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        ZScfIntProperties intProps = propertyDAO2.getPropertyAsIntProps(dtsSession);
        String jsonStr = intProps.get(XdtsConstants.Property.webServer.id);
        String dataSourceIdStr = intProps.get(XdtsConstants.Property.dataSourceId.id);
        HashMap<String, String> map = null;
        if (BcStringUtil.isEmpty(jsonStr)) {
            AfbApplication application = AfbApplication.getInstance();
            String appType = application.properties.getProperty("type");
            String siteName = null;
            if (XsysConstants.AppType.DatabaseClient.appType.equals(appType)) {
                siteName = "Database Search Service";
            } else if (XsysConstants.AppType.MovieFiler.appType.equals(appType)) {
                siteName = "Video Service";
            }
            map = new HashMap<String, String>();
            map.put(XsysConstants.HttpServerProperty.hostName.name(), "localhost");
            map.put(XsysConstants.HttpServerProperty.port.name(), "8080");
            map.put(XsysConstants.HttpServerProperty.sessionTimeout.name(), Integer.toString(900));
            map.put(XsysConstants.HttpServerProperty.siteName.name(), siteName);
            map.put(XdtsConstants.HttpServerProperty.resultTimeout.name(), Integer.toString(900));
            jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(map);
        } else {
            map = (HashMap<String, String>)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        }
        WbsSiteContext siteContext = new WbsSiteContext();
        siteContext.propertyMap.put(XdtsConstants.Property.webServer.name(), jsonStr);
        siteContext.propertyMap.put(XdtsConstants.Property.dataSourceId.name(), dataSourceIdStr);
        rmoArg.getRespons().addData(siteContext);
    }

    public void start(RmiRmoArgument rmoArg) throws Exception {
        WbsSiteContext siteContext = (WbsSiteContext)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        String jsonStr = siteContext.propertyMap.get(XdtsConstants.Property.webServer.name());
        Map map = (Map)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        String hostName = (String)map.get(XsysConstants.HttpServerProperty.hostName.name());
        String tmpStr = (String)map.get(XsysConstants.HttpServerProperty.port.name());
        int port = BcNumberUtil.parseInteger(tmpStr, -1);
        tmpStr = (String)map.get(XsysConstants.HttpServerProperty.sessionTimeout.name());
        int sessionTimeout = BcNumberUtil.parseInteger(tmpStr, -1);
        siteContext.siteName = (String)map.get(XsysConstants.HttpServerProperty.siteName.name());
        String dataSourceIdStr = siteContext.propertyMap.get(XdtsConstants.Property.dataSourceId.name());
        ZScfIntProperties intProps = new ZScfIntProperties();
        intProps.put((Integer)XdtsConstants.Property.webServer.id, jsonStr);
        intProps.put((Integer)XdtsConstants.Property.dataSourceId.id, dataSourceIdStr);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        propertyDAO2.putPropertyElement(dtsSession, intProps);
        dtsSession.commit();
        AfbApplication application = AfbApplication.getInstance();
        String appType = application.properties.getProperty("type");
        if (XsysConstants.AppType.DatabaseClient.appType.equals(appType)) {
            XdtsMenuCreator.getInstance().setLogger(logger);
            XdtsUserMenu userMenu = XdtsMenuCreator.getInstance().createMenu(dtsSession);
            XdtsMenuCreator.getInstance().setUserMenu(userMenu);
        } else {
            XsysConstants.AppType.MovieFiler.appType.equals(appType);
        }
        siteContext.servletPathMap.clear();
        XfilServerUtil.getInstance().initForWeb();
        WebServerController httpServerController = XsysServerUtil.getInstance().getHttpServerController();
        httpServerController.setLogger(logger);
        BcResult result = httpServerController.start(siteContext, hostName, port, sessionTimeout);
        rmoArg.getRespons().addData(result);
    }

    public void stop(RmiRmoArgument rmoArg) throws Exception {
        WebServerController httpServerProcess = XsysServerUtil.getInstance().getHttpServerController();
        this.getLogger().debug("httpServerProcess=" + httpServerProcess);
        httpServerProcess.stop();
        BcResult result = new BcResult();
        rmoArg.getRespons().addData(result);
    }

    public static enum Method implements RmiRemoteMethod
    {
        getSiteContext,
        start,
        stop;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

