/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.fx;

import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.fx.XsysWebServerSetting;

public class XsysWebConfigPane
extends FxBorderPane
implements XsysWebServerSetting {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField hostNameField = new FxTextField();
    FxNumberField portField = new FxNumberField();
    FxNumberField sessionTimeoutField = new FxNumberField();
    FxTextField siteNameField = new FxTextField();

    public XsysWebConfigPane() throws Exception {
        this.initComponant();
    }

    protected void initComponant() throws Exception {
        this.hostNameField.setPrefColumnCount(60);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().hostName.toPlain()), new Node[]{this.hostNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.portField.setPrefColumnCount(6);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().port), new Node[]{this.portField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.sessionTimeoutField.setPrefColumnCount(5);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(BcWords.getInstance().sessionTimeout.toPlain()) + "(sec)"), new Node[]{this.sessionTimeoutField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.siteNameField.setPrefColumnCount(60);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().siteName), new Node[]{this.siteNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
    }

    @Override
    public void storeData(Map<String, String> map) throws Exception {
        map.put(XsysConstants.HttpServerProperty.hostName.name(), this.hostNameField.getText());
        map.put(XsysConstants.HttpServerProperty.port.name(), this.portField.getBigDecimal().toString());
        map.put(XsysConstants.HttpServerProperty.sessionTimeout.name(), this.sessionTimeoutField.getBigDecimal().toString());
        map.put(XsysConstants.HttpServerProperty.siteName.name(), this.siteNameField.getText());
    }

    @Override
    public void setData(Map<String, String> map) throws Exception {
        this.hostNameField.setText(map.get(XsysConstants.HttpServerProperty.hostName.name()));
        String tmpStr = map.get(XsysConstants.HttpServerProperty.port.name());
        this.portField.setValue(BcNumberUtil.parseInteger(tmpStr, 0));
        tmpStr = map.get(XsysConstants.HttpServerProperty.sessionTimeout.name());
        this.sessionTimeoutField.setValue(BcNumberUtil.parseInteger(tmpStr, 0));
        this.siteNameField.setText(map.get(XsysConstants.HttpServerProperty.siteName.name()));
    }

    @Override
    public BcResult validate() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        inputValidator.notNullable(BcWords.getInstance().hostName.toPlain(), this.hostNameField.getText(), result.getErrorList());
        return result;
    }

    @Override
    public void setTab(TabPane tabPane) throws Exception {
        Tab tab = new Tab();
        tab.setText(XsysWords.getInstance().Basic_settings);
        tab.setContent((Node)this);
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
    }
}

