/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.util.Duration;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxImageUtil;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsod.common.FxxImageCash;
import jp.co.extreme.module.xsod.fx.XsodAbstractSignage;
import jp.co.extreme.module.xsod.fx.XsodSignageController;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.fx.Z_XsodJBackgroundPane;
import jp.co.extreme.module.xsod.model.XsodMerchandisePack;
import jp.co.extreme.module.xsod.model.XsodSignageData;

public class XsodSignageMerchandiseMenu
extends XsodAbstractSignage {
    StackPane baseStackPane1 = new StackPane();
    FxBorderPane bgBorderPane = new FxBorderPane();
    int merchandiseIndex = -1;
    boolean isEnd;
    FxBorderPane borderPane1 = new FxBorderPane();

    @Override
    public void init() throws Exception {
    }

    @Override
    public Node getNode() throws Exception {
        this.setBackground();
        this.baseStackPane1.getChildren().add((Object)this.bgBorderPane);
        this.scene1_1();
        return this.baseStackPane1;
    }

    private void setBackground() throws Exception {
        Pane bgPane = new Pane();
        XsodUiFactory.getInstance().setBgPane((Node)bgPane, Color.BLACK, 1.0);
        this.bgBorderPane.setCenter((Node)bgPane);
    }

    public void msg_1() throws Exception {
        Z_XsodJBackgroundPane backgroundPane = new Z_XsodJBackgroundPane();
        Pane bgBasePane = new Pane();
        bgBasePane.getChildren().add((Object)backgroundPane);
        this.baseStackPane1.getChildren().add((Object)bgBasePane);
        backgroundPane.setOpacity(0.0);
        String msg = "\u672c\u65e5\u306e\u304a\u3059\u3059\u3081\uff01";
        final Pane titleText = XsodUiFactory.getInstance().createTextPane(XsodUiFactory.getInstance().titleFont, Color.PLUM, Color.VIOLET, msg);
        this.baseStackPane1.getChildren().add((Object)titleText);
        SimpleDoubleProperty doubleProperty = new SimpleDoubleProperty();
        doubleProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                titleText.opacityProperty().set(newValue.doubleValue());
            }
        });
        Timeline timeline = new Timeline();
        double zoomStartDuration = 5000.0;
        double zoomEndtDuration = zoomStartDuration + 4000.0;
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)backgroundPane.opacityProperty(), (Object)0)});
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)3000.0), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.opacityProperty(), (Object)1)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf0, kf1});
        KeyFrame kf11 = new KeyFrame(Duration.millis((double)zoomStartDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.scaleXProperty(), (Object)1)});
        KeyFrame kf12 = new KeyFrame(Duration.millis((double)zoomEndtDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.scaleXProperty(), (Object)0.2)});
        KeyFrame kf13 = new KeyFrame(Duration.millis((double)zoomStartDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.scaleYProperty(), (Object)1)});
        KeyFrame kf14 = new KeyFrame(Duration.millis((double)zoomEndtDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.scaleYProperty(), (Object)0.2)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf11, kf12, kf13, kf14});
        KeyFrame kf21 = new KeyFrame(Duration.millis((double)zoomStartDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.layoutXProperty(), (Object)backgroundPane.layoutXProperty().get())});
        KeyFrame kf22 = new KeyFrame(Duration.millis((double)zoomEndtDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.layoutXProperty(), (Object)700)});
        KeyFrame kf23 = new KeyFrame(Duration.millis((double)zoomStartDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.layoutYProperty(), (Object)backgroundPane.layoutYProperty().get())});
        KeyFrame kf24 = new KeyFrame(Duration.millis((double)zoomEndtDuration), new KeyValue[]{new KeyValue((WritableValue)backgroundPane.layoutYProperty(), (Object)380)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf21, kf22, kf23, kf24});
        KeyFrame kf02 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)doubleProperty, (Object)0)});
        KeyFrame kf15 = new KeyFrame(Duration.millis((double)3000.0), new KeyValue[]{new KeyValue((WritableValue)doubleProperty, (Object)1)});
        KeyFrame kf3 = new KeyFrame(Duration.millis((double)10000.0), new KeyValue[0]);
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf02, kf15, kf3});
        timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                XsodSignageMerchandiseMenu.this.baseStackPane1.getChildren().remove((Object)titleText);
                try {
                    XsodSignageMerchandiseMenu.this.scene1_1();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        timeline.play();
    }

    protected void scene1_1() throws Exception {
        this.baseStackPane1.getChildren().add((Object)this.borderPane1);
        String msg = "\u30e1\u30cb\u30e5\u30fc\u306e\u3054\u6848\u5185\uff01";
        Pane titleText = XsodUiFactory.getInstance().createTextPane(XsodUiFactory.getInstance().titleFont, Color.RED, Color.WHITE, msg);
        HBox hBox1 = new HBox(0.0);
        hBox1.setAlignment(Pos.CENTER);
        hBox1.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBox1.getChildren().add((Object)titleText);
        this.borderPane1.setTop((Node)hBox1);
        FxBorderPane bottomBorderPane = new FxBorderPane();
        this.borderPane1.setBottom((Node)bottomBorderPane);
        Font font = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)26.0);
        msg = "\u203b\u4fa1\u683c\u306f\u5168\u3066\u7a0e\u629c\u304d\u4fa1\u683c\u3068\u306a\u3063\u3066\u304a\u308a\u307e\u3059\u3002";
        Pane taxText = XsodUiFactory.getInstance().createTextPane(font, Color.RED, Color.WHITE, msg);
        HBox hBox2 = new HBox(0.0);
        hBox2.setAlignment(Pos.BOTTOM_RIGHT);
        hBox2.getChildren().add((Object)taxText);
        bottomBorderPane.setRight((Node)hBox2);
        HBox hBox3 = new HBox(0.0);
        hBox3.setMaxWidth(20.0);
        FxButton button = new FxButton();
        button.prefWidthProperty().bind((ObservableValue)hBox3.widthProperty());
        button.prefHeightProperty().bind((ObservableValue)hBox3.heightProperty());
        hBox3.getChildren().add((Object)button);
        bottomBorderPane.setLeft((Node)hBox3);
        button.setOnAction(ActionEvent2 -> {
            Stage stage = (Stage)FxUtil.getWindow((Node)button);
            stage.setFullScreen(false);
        });
        this.scene1_2();
    }

    protected void scene1_2() throws Exception {
        XsodSignageData signageData = XsodSignageController.getInstance().signageData;
        int colmnCnt = 2;
        int rowCnt = 2;
        double cellWidth = XsodUiFactory.getInstance().recommendedWidth / (double)colmnCnt;
        double cellHeight = XsodUiFactory.getInstance().recommendedHeight / (double)rowCnt;
        final TilePane tilePane = new TilePane();
        tilePane.setOrientation(Orientation.HORIZONTAL);
        tilePane.setAlignment(Pos.CENTER);
        tilePane.setTileAlignment(Pos.CENTER);
        tilePane.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
        tilePane.setVgap(20.0);
        tilePane.setHgap(20.0);
        tilePane.setPrefColumns(colmnCnt);
        tilePane.setPrefSize(XsodUiFactory.getInstance().recommendedWidth, XsodUiFactory.getInstance().recommendedHeight);
        this.borderPane1.setCenter((Node)tilePane);
        Timeline timeline = new Timeline();
        int i = 0;
        while (i < colmnCnt) {
            int j = 0;
            while (j < colmnCnt) {
                ++this.merchandiseIndex;
                if (this.merchandiseIndex >= signageData.merchandisePackList.size()) {
                    this.isEnd = true;
                    break;
                }
                Node node = this.scene1_3(cellWidth, cellHeight, timeline);
                tilePane.getChildren().add((Object)node);
                ++j;
            }
            if (this.isEnd) break;
            ++i;
        }
        timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                XsodSignageMerchandiseMenu.this.borderPane1.getChildren().remove((Object)tilePane);
                try {
                    if (XsodSignageMerchandiseMenu.this.isEnd) {
                        XsodSignageMerchandiseMenu.this.finished();
                    } else {
                        XsodSignageMerchandiseMenu.this.scene1_2();
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        timeline.play();
    }

    protected Node scene1_3(double targetWidth, double targetHeight, Timeline timeline) throws Exception {
        XsodSignageData signageData = XsodSignageController.getInstance().signageData;
        Pane basePane = new Pane();
        StackPane baseStackPane = new StackPane();
        basePane.getChildren().add((Object)baseStackPane);
        StackPane imageStackPane = new StackPane();
        StackPane.setAlignment((Node)imageStackPane, (Pos)Pos.TOP_LEFT);
        baseStackPane.getChildren().add((Object)imageStackPane);
        FxUtil.setFixedSize((Region)basePane, targetWidth, targetHeight);
        XsodMerchandisePack merchandisePack = signageData.merchandisePackList.get(this.merchandiseIndex);
        Image image = FxxImageCash.getInstance().getImageNI(merchandisePack.merchandise.imageFileName);
        if (image == null) {
            BcLogUtil.warning("image is null.");
            return null;
        }
        final double gap = 20.0;
        double durationMillis = 15000.0;
        double fadeOutMillis = 2000.0;
        double fadeOutStartMillis = durationMillis - fadeOutMillis;
        image = FxImageUtil.extractImage(image, targetWidth, targetHeight);
        final double imageWidth = image.getWidth();
        final double imageHeight = image.getHeight();
        final ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(targetWidth);
        imageView.setFitHeight(targetHeight);
        imageStackPane.getChildren().add((Object)imageView);
        StackPane.setAlignment((Node)imageView, (Pos)Pos.TOP_LEFT);
        basePane.setOpacity(0.0);
        FlowPane merchandisePane = XsodUiFactory.getInstance().createMenuName(merchandisePack, targetWidth, 60.0);
        baseStackPane.getChildren().add((Object)merchandisePane);
        StackPane.setAlignment((Node)merchandisePane, (Pos)Pos.BOTTOM_LEFT);
        if (merchandisePack.merchandise.quantity == 0) {
            HBox soldOutPane = XsodUiFactory.getInstance().createSoldOutOane(100.0);
            baseStackPane.getChildren().add((Object)soldOutPane);
            StackPane.setAlignment((Node)soldOutPane, (Pos)Pos.CENTER);
        }
        SimpleDoubleProperty doubleProperty = new SimpleDoubleProperty();
        doubleProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                double nw = 0.0;
                double nh = 0.0;
                nw = imageWidth * (100.0 - gap + newValue.doubleValue()) / 100.0;
                nh = imageHeight * (100.0 - gap + newValue.doubleValue()) / 100.0;
                double nx = (imageWidth - nw) / 2.0;
                double ny = (imageHeight - nh) / 2.0;
                Rectangle2D rectangle = new Rectangle2D(nx, ny, nw, nh);
                imageView.setViewport(rectangle);
            }
        });
        KeyFrame kf11 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)doubleProperty, (Object)0)});
        KeyFrame kf12 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{new KeyValue((WritableValue)doubleProperty, (Object)gap)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf11, kf12});
        KeyFrame kf21 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)basePane.opacityProperty(), (Object)0)});
        KeyFrame kf22 = new KeyFrame(Duration.millis((double)fadeOutMillis), new KeyValue[]{new KeyValue((WritableValue)basePane.opacityProperty(), (Object)1)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf21, kf22});
        KeyFrame kf31 = new KeyFrame(Duration.millis((double)fadeOutStartMillis), new KeyValue[]{new KeyValue((WritableValue)basePane.opacityProperty(), (Object)1)});
        KeyFrame kf32 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{new KeyValue((WritableValue)basePane.opacityProperty(), (Object)0)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{kf31, kf32});
        KeyFrame kf41 = new KeyFrame(Duration.millis((double)fadeOutStartMillis), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
            }
        }, new KeyValue[0]);
        timeline.getKeyFrames().add((Object)kf41);
        return basePane;
    }
}

