/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.css.common.CssConstants;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlDataAttribute;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlImageAttribute;
import jp.co.extreme.html.common.HtmlTagAttribute;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.lib.html.mdc.MdcConstants;
import jp.co.extreme.lib.html.mdc.MdcLabelAndInputBuilder;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.ffmpeg.FfmpegHelper;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.server.Wbs1ServerUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1RecruitmentListWCB;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilIndexGroup;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlUtil2;
import jp.co.extreme.module.xweb.common.WbsProgress;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebIconManager;
import jp.co.extreme.module.xweb.common.XwebPaginationBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.hls.HlsjsUtil;
import jp.co.extreme.web.hls.WjsElementReplaceUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class XfilFileListWCB
extends Wbs1AbstractWCB {
    final String key_entityId = "entityId";

    @Override
    protected String createHeadStyle(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.append(sb, super.createHeadStyle(wcbArg));
        sb.append("\n\n.mdl-layout__content {\nposition: relative;\nbackground-size:cover;\nbackground-image: url(images/main_bg.jpg);\n}");
        return sb.toString();
    }

    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionFiler = Wbs1ServerUtil.getInstance().createSessionFiler(this);){
            this.form_L2(wcbArg, dtsSessionFiler);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(WbsArgument wcbArg, DtsSession dtsSessionFiler) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsUrlParam urlParam = null;
        WbsTempCondition tempCondition = null;
        if (tokenContext.validationResult == null) {
            tokenContext.validationResult = new XsysValidationResult();
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, urlParam);
            XwebUtil.putToMap(tokenContext.map, urlParam);
            tempCondition = new WbsTempCondition();
            XwebUtil.putToMap(tokenContext.map, tempCondition);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            tempCondition = (WbsTempCondition)XwebUtil.getMapValue(tokenContext.map, WbsTempCondition.class);
        }
        tempCondition.hasKeyword = wcbArg.getRequestParameter().map.containsKey(WbsTempCondition.FieldName.keyword.fieldName);
        if (tempCondition.hasKeyword) {
            WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, tempCondition);
        }
        EtcPagination pagination = XwebUtil.cretaePagination(wcbArg);
        pagination.countPerPage = 20;
        StringBuilder sb = new StringBuilder();
        int contentColumn = 12;
        sb.append((CharSequence)MdlCreator.getInstance().div_grid_cell_start(contentColumn));
        sb.append(this.createConditionForm(wcbArg, tokenContext, dtsSessionFiler, Method.form.path, tempCondition));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(this.createDetailList(wcbArg, tokenContext, pagination, dtsSessionFiler, urlParam, tempCondition));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.clear().text_align(CssConstants.CssAlign.center).build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        List<File> fileList = XfilServerUtil.getInstance().getRootFileList(dtsSessionFiler);
        int i = 0;
        while (i < fileList.size()) {
            File file = fileList.get(i);
            long total = file.getTotalSpace();
            long free = file.getUsableSpace();
            double usage = total - free;
            String totalStr = BcSIUnitUtil.toByteString(total);
            String freeStr = BcSIUnitUtil.toByteString(free);
            double usageRate = usage / (double)total * 100.0;
            String diskIfo = String.valueOf(file.getPath()) + "   total:" + totalStr + "   free:" + freeStr + "   usage:" + String.format("%.1f%%", usageRate);
            sb.append(HtmlUtil.encodeNotLineFeed(diskIfo));
            ++i;
        }
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        MdlCreator mdlCreator = MdlCreator.getInstance();
        MdlCreator.getInstance();
        sb.append((CharSequence)mdlCreator.div_grid_cell_start(12 - contentColumn));
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1RecruitmentListWCB.Method.form);
        sb.append(this.getHtmlBuilder().div_end());
        sb = MdlCreator.getInstance().grid_portfolio(sb, false);
        ArrayList<String> headElementList = new ArrayList<String>();
        ArrayList<String> bodyScriptList = new ArrayList<String>();
        bodyScriptList.addAll(HlsjsUtil.getInstance().getBodyScriptSrcList());
        bodyScriptList.add(HlsjsUtil.getInstance().getScript());
        bodyScriptList.add(WjsElementReplaceUtil.getInstance().getScript1());
        String param1 = WbfwUtil.createParameter("entityId=", null);
        String url = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.getProgress)) + WbfwUtil.createUrlQuery(param1);
        bodyScriptList.add(WjsElementReplaceUtil.getInstance().getScript2(url));
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, null, null, html, headElementList, bodyScriptList);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
        List tsEentityList = (List)tokenContext.map.remove("tmp");
        XfilServerUtil.getInstance().addSegmentTarget(tsEentityList);
    }

    protected String createConditionForm(WbsArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionFiler, String url, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_flex_center.className));
        InnerMdcLabelAndInputBuilder labelAndInputBuilder = new InnerMdcLabelAndInputBuilder();
        String textField = labelAndInputBuilder.create(HtmlConstants.HtmlInputType.text, WbsTempCondition.FieldName.keyword.fieldName, 60, 1, 255, false, false, tempCondition.keyword, false, null, "Search Files...", null, false, null, null, null, null, null);
        sb.append(textField);
        String formName = "form1";
        StringBuilder controls = new StringBuilder();
        String onclickAction = WbfJslUtil.submit2(formName, url);
        sb.append((CharSequence)this.getHtmlBuilder().div(controls.toString(), HtmlConstants.HtmlAlign.center, -1));
        sb.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        sb.append(this.getHtmlBuilder().div_end());
        sb = HtmlUtil2.form(formName, sb.toString());
        return sb.toString();
    }

    protected String createDetailList(WbsArgument wcbArg, WbxTokenContext tokenContext, EtcPagination pagination, DtsSession dtsSessionFiler, WbsUrlParam urlParam, WbsTempCondition tempCondition) throws Exception {
        ArrayList<XfilUriEntity> entityList2 = (ArrayList<XfilUriEntity>)XwebUtil.getMapValue(tokenContext.map, XfilUriEntity.class);
        if (tempCondition.hasKeyword || entityList2 == null) {
            XfilUriEntityDAO dao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
            List entityList1 = null;
            entityList1 = BcStringUtil.isEmpty(tempCondition.keyword) ? dao.getListByLimit(dtsSessionFiler, 100) : dao.getListByName(dtsSessionFiler, -1L, tempCondition.keyword, true);
            ArrayList<Long> targetIndexGroupIdList = new ArrayList<Long>();
            Map<Long, XfilIndexGroup> indexGroupMap = XfilServerUtil.getInstance().getIndexGroupMap(dtsSessionFiler);
            for (Map.Entry<Long, XfilIndexGroup> mapEntry : indexGroupMap.entrySet()) {
                XfilIndexGroup indexGroup = mapEntry.getValue();
                if (!EtcEnumStrUtil.contains(indexGroup.text1, XsysConstants.Function.web.name())) continue;
                targetIndexGroupIdList.add(indexGroup.id);
            }
            entityList2 = new ArrayList<XfilUriEntity>();
            int i = 0;
            while (i < entityList1.size()) {
                File sourceFile;
                XfilUriEntity uriEntity = (XfilUriEntity)entityList1.get(i);
                this.getLogger().debug("uriEntity.id=" + uriEntity.id + " indexGroupId=" + uriEntity.indexGroupId + " " + targetIndexGroupIdList.contains(uriEntity.indexGroupId));
                if (XfilUtil.isTargetExtention(XfilConstants.getMovieExtentionList(), uriEntity.extention) && targetIndexGroupIdList.contains(uriEntity.indexGroupId) && (sourceFile = new File(uriEntity.directory, uriEntity.name)).exists()) {
                    entityList2.add(uriEntity);
                }
                ++i;
            }
            tokenContext.map.put(XfilUriEntity.class.getName(), entityList2);
        } else {
            entityList2 = (List)XwebUtil.getMapValue(tokenContext.map, XfilUriEntity.class);
        }
        pagination.setDataCount(entityList2.size());
        List entityList3 = pagination.newList(entityList2);
        StringBuilder sb = new StringBuilder();
        InnerPaginationBuilder paginationBuilder = new InnerPaginationBuilder();
        paginationBuilder.tokenContext = tokenContext;
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_flex_center.className));
        sb.append(paginationBuilder.create(wcbArg, pagination));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.clazz = "media_grid";
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        ArrayList<XfilUriEntity> tsEentityList = new ArrayList<XfilUriEntity>();
        int i = 0;
        while (i < entityList3.size()) {
            File segmentDir;
            XfilUriEntity uriEntity = (XfilUriEntity)entityList3.get(i);
            File m3u8File = XfilUtil.getM3u8(uriEntity, segmentDir = XfilServerUtil.getInstance().getSegmentDir(uriEntity.indexGroupId, dtsSessionFiler));
            if (!m3u8File.exists()) {
                tsEentityList.add(uriEntity);
            }
            sb.append(this.createDetailCell(wcbArg, dtsSessionFiler, urlParam, uriEntity));
            sb.append("\n\n");
            ++i;
        }
        tokenContext.map.put("tmp", tsEentityList);
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_flex_center.className));
        sb.append(paginationBuilder.create(wcbArg, pagination));
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    protected String createDetailCell(WbsArgument wcbArg, DtsSession dtsSessionFiler, WbsUrlParam tempCondition, XfilUriEntity uriEntity) throws Exception {
        StringBuilder sb = new StringBuilder();
        String imagePath = null;
        List<String> fileNameList = BcCsvUtil.parseCsvRow(uriEntity.thumbnailFiles, true);
        if (!BcCollectionUtil.isEmpty(fileNameList)) {
            String fileName = BcCollectionUtil.getFirst(fileNameList);
            String subDir = XfilUtil.toEntityPath(uriEntity.id);
            imagePath = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.poster)) + "/" + subDir + fileName;
        }
        CssBuiler cssBuiler = new CssBuiler();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.clear().width(String.valueOf(FfmpegHelper.Resolution._144p.width) + "px").build();
        globalAttribute.clazz = "media_cell";
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.clear().width("100%").height(String.valueOf(FfmpegHelper.Resolution._144p.height) + "px").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        File m3u8File = XfilServerUtil.getInstance().getM3u8File(uriEntity, dtsSessionFiler);
        if (m3u8File.exists()) {
            sb.append(this.createVideoParentDiv(wcbArg, uriEntity, m3u8File, imagePath, null, false));
        } else {
            sb.append(this.createVideoParentDiv(wcbArg, uriEntity, null, imagePath, XfilWords.getInstance().Creating_segment_file, false));
        }
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.clear().margin_top("0.3rem").margin_left("0.5rem").margin_right("0.5rem").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row_wrap.className));
        sb.append(HtmlUtil.encode(uriEntity.name));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_row.className);
        globalAttribute.style = cssBuiler.clear().justify_content(CssConstants.justifyContent.space_between).build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        BcTimeUtil.TimeStructure timeStructure = BcTimeUtil.toTimeStructure(uriEntity.durationMillis);
        String duration = BcTimeUtil.toDurationString(timeStructure, false);
        String size = String.valueOf(uriEntity.width) + "x" + uriEntity.height;
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.clear().font_size("0.8rem").height("1rem").build();
        sb.append(this.getHtmlBuilder().p(globalAttribute, duration, true, true));
        sb.append(this.getHtmlBuilder().p(globalAttribute, size, true, true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    public void poster(WbsArgument wcbArg) throws Exception {
        HttpServletRequest httpReq = wcbArg.getRequest();
        String fileName = XwebUtil.getServletPathAfter(httpReq);
        File dir = XfilUtil.getTthumbnailBaseDir();
        File file = new File(dir, fileName);
        this.getLogger().debug("file.getPath()=" + file.getPath() + " exists=" + file.exists());
        if (file.exists()) {
            WbfwUtil.outputFile_Z(wcbArg, file);
        } else {
            wcbArg.getResponse().sendError(404);
        }
    }

    public void hls(WbsArgument wcbArg) throws Exception {
        HttpServletRequest httpReq = wcbArg.getRequest();
        String filePath = httpReq.getServletPath().replace("/hls/", "");
        int idx = filePath.indexOf("/");
        String igStr = filePath.substring(0, idx);
        long indexGroupId = BcNumberUtil.parseLong(igStr, -1);
        String filePath2 = filePath.substring(idx + 1);
        File segmentDir = XfilServerUtil.getInstance().getSegmentDir(indexGroupId, null);
        File file = new File(segmentDir, filePath2);
        if (file.exists()) {
            WbfwUtil.outputFile_Z(wcbArg, file);
        } else {
            wcbArg.getResponse().sendError(404);
        }
    }

    public void getProgress(WbsArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.status);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        long entityId = requestParameter.map.getAsLong("entityId", (Number)-1);
        WbsProgress progress = new WbsProgress();
        XfilUriEntity uriEntity = XfilServerUtil.getInstance().getUriEntity(entityId);
        if (uriEntity != null) {
            File m3u8File;
            String imagePath = null;
            List<String> fileNameList = BcCsvUtil.parseCsvRow(uriEntity.thumbnailFiles, true);
            if (!BcCollectionUtil.isEmpty(fileNameList)) {
                String fileName = BcCollectionUtil.getFirst(fileNameList);
                String subDir = XfilUtil.toEntityPath(uriEntity.id);
                imagePath = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.poster)) + "/" + subDir + fileName;
            }
            if ((m3u8File = XfilServerUtil.getInstance().getM3u8File(uriEntity, null)).exists()) {
                progress.statusId = WbxConstants.ProgressStatus.Finished.id;
                progress.data = this.createVideoParentDiv(wcbArg, uriEntity, m3u8File, imagePath, null, false);
            } else {
                XfilUriEntity uriEntityErr = XfilServerUtil.getInstance().getUriEntityErrorMap().get(entityId);
                if (uriEntityErr == null) {
                    progress.statusId = WbxConstants.ProgressStatus.OK.id;
                } else {
                    progress.statusId = WbxConstants.ProgressStatus.NG.id;
                    progress.message = String.valueOf(XfilWords.getInstance().The_segment_file_could_not_be_created) + " entityId=" + entityId;
                    progress.data = this.createVideoParentDiv(wcbArg, uriEntity, m3u8File, imagePath, XfilWords.getInstance().The_segment_file_could_not_be_created, true);
                }
            }
        } else {
            progress.statusId = WbxConstants.ProgressStatus.NG.id;
            progress.message = "err:entityId=" + entityId;
            progress.data = this.createVideoParentDiv(wcbArg, uriEntity, null, null, "Not Found.", true);
        }
        ObjectMapper objectMapper = JacksonUtil.getObjectMapper();
        String jsonStr = objectMapper.writeValueAsString((Object)progress);
        WbfwUtil.outputJsonStr(wcbArg, jsonStr);
    }

    protected String createVideoParentDiv(WbsArgument wcbArg, XfilUriEntity uriEntity, File m3u8File, String imagePath, String message, boolean isError) throws Exception {
        CssBuiler cssBuiler = new CssBuiler();
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.dataAttributeCollection = new ArrayList<HtmlDataAttribute>();
        if (m3u8File == null) {
            globalAttribute.clazz = BcStringUtil.toSsv("resourceStandy");
            globalAttribute.dataAttributeCollection.add(new HtmlDataAttribute("entity_id", Long.toString(uriEntity.id)));
        } else {
            globalAttribute.clazz = BcStringUtil.toSsv("pre_element");
            String videoTag = this.createVideoTag(wcbArg, uriEntity, m3u8File, imagePath);
            globalAttribute.dataAttributeCollection.add(new HtmlDataAttribute("html", this.getHtmlBuilder().encode(videoTag, true)));
        }
        globalAttribute.style = cssBuiler.clear().width("100%").height("100%").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        if (!BcStringUtil.isEmpty(imagePath)) {
            HtmlImageAttribute imageAttribute = new HtmlImageAttribute();
            imageAttribute.src = imagePath;
            imageAttribute.width = "100%";
            imageAttribute.height = "100%";
            imageAttribute.objectFit = "cover";
            sb.append(this.getHtmlBuilder().image(null, imageAttribute, null));
        }
        if (m3u8File == null) {
            sb.append(this.getHtmlBuilder().div(null, "loader"));
        } else {
            ArrayList<String> classList = new ArrayList<String>();
            classList.add("media_icon");
            XwebIconManager.WebIcon webIcon = XwebIconManager.WebIcon.play;
            if (isError) {
                webIcon = XwebIconManager.WebIcon.video_slash;
            }
            sb.append(XwebIconManager.createTag(webIcon, classList, null));
        }
        if (!BcStringUtil.isEmpty(message)) {
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.clazz = "media_message";
            sb.append(this.getHtmlBuilder().p(globalAttribute, message, true, true));
        }
        return sb.toString();
    }

    public String createVideoTag(WbsArgument wcbArg, XfilUriEntity uriEntity, File m3u8File, String poster) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = "video_hls";
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.clear().width("100%").height("100%").build();
        String scr = null;
        if (m3u8File != null) {
            String path = XfilUtil.getM3u8Path(uriEntity);
            scr = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.hls)) + "/" + uriEntity.indexGroupId + "/" + path;
        }
        String videoTag = this.getHtmlBuilder().video(globalAttribute, -1, -1, poster, scr);
        return videoTag;
    }

    public void resource(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionFiler = Wbs1ServerUtil.getInstance().createSessionFiler(this);){
            this.resource_L2(wcbArg, dtsSessionFiler);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void resource_L2(WbsArgument wcbArg, DtsSession dtsSessionFiler) throws Exception {
        this.getLogger().debug("resource_L2:");
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tmpStr = requestParameter.getAsString("id");
        long entityId = BcNumberUtil.parseLong(tmpStr, -1);
        this.getLogger().debug("entityId=" + entityId);
        XfilUriEntityDAO dao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
        XfilUriEntity uriEntity = (XfilUriEntity)dao.getById(dtsSessionFiler, entityId);
        File file = new File(uriEntity.directory, uriEntity.name);
        this.getLogger().debug("file.getPath()=" + file.getPath());
        if (file.exists()) {
            WbfwUtil.outputFile_Z(wcbArg, file);
        } else {
            wcbArg.getResponse().sendError(404);
        }
    }

    class InnerMdcLabelAndInputBuilder
    extends MdcLabelAndInputBuilder {
        InnerMdcLabelAndInputBuilder() {
        }

        @Override
        public String getLeadingIconTag(String inputName) throws Exception {
            StringBuilder sb = new StringBuilder();
            HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
            List<String> classList = XwebIconManager.createClassList(XwebIconManager.WebIcon.search);
            classList.add(MdcConstants.MdcClass.mdc_text_field__icon.value);
            classList.add(MdcConstants.MdcClass.mdc_text_field__icon__leading.value);
            globalAttribute.clazz = BcStringUtil.toSsv(classList);
            globalAttribute.id = "searchIcon";
            ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
            this.getHtmlBuilder().addTagAttribute(tagAttributeList, "onClick", "jsfn_submit(form1)");
            this.getHtmlBuilder().addTagAttribute(tagAttributeList, "tabindex", "0");
            this.getHtmlBuilder().addTagAttribute(tagAttributeList, "role", "button");
            sb.append(XwebIconManager.createTag(globalAttribute, tagAttributeList));
            return sb.toString();
        }
    }

    class InnerPaginationBuilder
    extends XwebPaginationBuilder {
        WbxTokenContext tokenContext;
        String area1;

        InnerPaginationBuilder() {
        }

        @Override
        protected String createHref(WbsArgument wcbArg, int pageNo) throws Exception {
            String param1 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.token.name(), (Object)XwebUtil.createTokenString(this.tokenContext));
            String param2 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.page.name(), (Object)Integer.toString(pageNo));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1, param2);
            return href;
        }
    }

    public static enum Method implements WbxPath
    {
        form("file"),
        poster(null),
        hls(null),
        getProgress("file-progress"),
        resource(null);

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return XfilFileListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

