/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.rmo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;

public class XfilUriEntityRMO
extends RmiAbstractRMO {
    public void putUriEntities(RmiRmoArgument rmoArg) throws Exception {
        Collection uriEntityCollection = (Collection)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            uriEntityDAO.putEntityCollection(dtsSessionWk, uriEntityCollection);
            rmoArg.getRespons().addData(uriEntityCollection);
            dtsSessionWk.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteEntities(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        BcResult result = new BcResult();
        Throwable throwable = null;
        Object var5_7 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            ArrayList<Long> deletedEntityIdList = new ArrayList<Long>();
            for (Long entityId : entityIdCollection) {
                XfilUriEntity uriEntity = (XfilUriEntity)uriEntityDAO.getById(dtsSessionWk, entityId);
                if (uriEntity == null) {
                    String msg = BcWords.getInstance().Object_not_found("entityId=" + entityId);
                    this.getLogger().debug(msg);
                    result.addError(msg);
                    continue;
                }
                int updateCnt = uriEntityDAO.deleteBylId(dtsSessionWk, uriEntity.id);
                this.getLogger().debug("uriEntity.id=" + uriEntity.id + " updateCnt=" + updateCnt);
                if (updateCnt <= 0) continue;
                deletedEntityIdList.add(entityId);
                XfilUtil.deleteTthumbnail(uriEntity);
            }
            dtsSessionWk.commit();
            rmoArg.getRespons().addData(deletedEntityIdList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getUriEntities(RmiRmoArgument rmoArg) throws Exception {
        Collection uriEntityIdCollection = (Collection)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            LinkedHashMap<Long, XfilUriEntity> uriEntityIdMap = new LinkedHashMap<Long, XfilUriEntity>();
            for (Long uriEntityId : uriEntityIdCollection) {
                XfilUriEntity uriEntity = (XfilUriEntity)uriEntityDAO.getById(dtsSessionWk, uriEntityId);
                if (uriEntity == null) continue;
                uriEntityIdMap.put(uriEntity.id, uriEntity);
            }
            rmoArg.getRespons().addData(uriEntityIdMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void update(RmiRmoArgument rmoArg) throws Exception {
        Long entityId = rmoArg.getRequest().getDataAsLong();
        String tag = rmoArg.getRequest().getDataAsString();
        Throwable throwable = null;
        Object var5_7 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityDAO.getById(dtsSessionWk, entityId);
            uriEntity.tag = tag;
            uriEntityDAO.putEntity(dtsSessionWk, uriEntity);
            dtsSessionWk.commit();
            rmoArg.getRespons().addData(uriEntity);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum Method implements RmiRemoteMethod
    {
        putUriEntities,
        deleteEntities,
        getUriEntities,
        update;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

