/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.doc.poi.DcfExcel2Book;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.parser.XfilFileParser;
import jp.co.extreme.poi.PoiConstants;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class XfilMsWordParser
extends XfilFileParser {
    DcfExcel2Book excel2Book = new DcfExcel2Book();
    DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();

    @Override
    public void parse(XfilUriEntity uriEntity, File file) throws Exception {
        if (file.exists()) {
            this.parse_L2(uriEntity, file);
            uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
        } else {
            BcLogUtil.warning("Not found file:" + file.getPath());
            uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
        }
    }

    protected void parse_L2(XfilUriEntity uriEntity, File file) throws Exception {
        String extention = BcFileUtil.getExtention(file);
        if (BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.docx.name(), extention)) {
            this.parseWord2007(uriEntity, file);
        } else if (BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.doc.name(), extention)) {
            this.parseWord2003(uriEntity, file);
        } else {
            throw new Exception("extention=" + extention);
        }
    }

    protected void parseWord2007(XfilUriEntity uriEntity, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        XWPFDocument xwpfDocument = new XWPFDocument(OPCPackage.open((InputStream)fis));
        XWPFWordExtractor wordExtractor = new XWPFWordExtractor(xwpfDocument);
        uriEntity.text02 = wordExtractor.getText();
        BcLogUtil.debug("uriEntity.text02=" + uriEntity.text02);
        wordExtractor.close();
        xwpfDocument.close();
    }

    protected void parseWord2003(XfilUriEntity uriEntity, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        HWPFDocument document = new HWPFDocument((InputStream)fis);
        WordExtractor wordExtractor = new WordExtractor(document);
        uriEntity.text02 = wordExtractor.getText();
        BcLogUtil.debug("uriEntity.text02=" + uriEntity.text02);
        wordExtractor.close();
        document.close();
    }
}

