/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.tree.FxTreeItemHelperImpl;
import jp.co.extreme.fx.tree.FxTreeUtil;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreeView;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.sql.context.SqlContext;

abstract class XdtsProfileTreeItemHelper
extends FxTreeItemHelperImpl
implements BcEventHandler<BcEvent> {
    XdtsProfile profile;
    SqlContext sqlContext;
    DtsWordManager wordManager;
    XdtsProfileTreeView profileTreeView;
    protected List<String> clipboardValueList;

    XdtsProfileTreeItemHelper() {
    }

    public void setProfile(XdtsProfile profile, SqlContext sqlContext, DtsWordManager wordManager, XdtsProfileTreeView profileTreeView) throws Exception {
        this.profile = profile;
        this.sqlContext = sqlContext;
        this.wordManager = wordManager;
        this.profileTreeView = profileTreeView;
    }

    protected void delete(Event ev, FxTreeItem treeItem) throws Exception {
        List treeItemList = FxTreeUtil.extractParent(this.getTreeView().getSelectionModel().getSelectedItems(), null);
        String msg = null;
        if (treeItemList.size() == 1) {
            FxTreeItem treeItemWk = (FxTreeItem)treeItemList.get(0);
            String valueName = null;
            if (treeItemWk.getValue() instanceof XdtsCustomSql) {
                XdtsCustomSql customSql = (XdtsCustomSql)treeItemWk.getValue();
                valueName = customSql.name;
            } else {
                valueName = BcStringUtil.toString(treeItemWk.getValue());
            }
            msg = String.format("'%s' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", valueName);
        } else {
            msg = String.format("%d\u4ef6\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", treeItemList.size());
        }
        if (FxOptionPane.showConfirmDialog((Node)this.getTreeView(), (Object)msg, BcWords.getInstance().confirmation, 3) == 0) {
            ArrayList<FxTreeItem> descendantList1 = new ArrayList<FxTreeItem>();
            int i = 0;
            while (i < treeItemList.size()) {
                FxTreeItem treeItemWk1 = (FxTreeItem)treeItemList.get(i);
                List descendantList2 = FxTreeUtil.createDescendantList(treeItemWk1, true);
                for (FxTreeItem fxTreeItem : descendantList2) {
                    if (descendantList1.contains((Object)fxTreeItem)) continue;
                    descendantList1.add(fxTreeItem);
                }
                ++i;
            }
            this.delete(descendantList1);
        }
    }

    protected void delete(List<FxTreeItem> descendantList) throws Exception {
    }

    protected String createGroupPath(TreeItem toItem) throws Exception {
        ArrayList<String> folderNameList = new ArrayList<String>();
        for (TreeItem treeItemWk = toItem; treeItemWk != this.getSubTreeItem(); treeItemWk = treeItemWk.getParent()) {
            folderNameList.add(BcStringUtil.toString(treeItemWk.getValue()));
        }
        Collections.reverse(folderNameList);
        String groupPath = BcStringUtil.marge(folderNameList, "/").toString();
        return groupPath;
    }
}

