/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventManager;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsQueryCreator;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsConditionModelToFx;
import jp.co.extreme.module.xdts.fx.XdtsFxCondition;
import jp.co.extreme.module.xdts.fx.XdtsFxToConditionModel;
import jp.co.extreme.module.xdts.fx.XdtsSelectQueryEditPane;
import jp.co.extreme.module.xdts.fx.Y_ConditonEvent;
import jp.co.extreme.module.xdts.fx.Y_FxErrorHandle;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import jp.co.extreme.module.xdts.stub.XdtsExtractionConditionStub;
import jp.co.extreme.module.xdts.stub.XdtsProfileStub;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Sql;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsExtractionConditionEditPane
extends FxDecoratePane {
    FxBorderPane centerPane = new FxBorderPane();
    FxFlowPane topPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    TabPane tabPane = new TabPane();
    FxButton buildSqlButton;
    FxButton completionButton;
    FxButton cancelButton;
    Stage stage;
    SqlContext sqlContext;
    XdtsExtractionCondition extractionCondition;
    protected Y_FxErrorHandle.Silent<Y_ConditonEvent> conditonEventHandler = new Y_FxErrorHandle.Silent<Y_ConditonEvent>(){

        @Override
        public void handle(Y_ConditonEvent ev) throws Exception {
            XdtsExtractionConditionEditPane.this.repaint();
        }
    };
    EventHandler<Y_ConditonEvent> conditonEventHandler1 = Y_FxErrorHandle.wrap(this.conditonEventHandler);
    XdtsConditionModelToFx conditionModelToFx = new XdtsConditionModelToFx();
    XdtsFxCondition fxConditionBase;

    public XdtsExtractionConditionEditPane() throws Exception {
        this.nameTextField.setPrefColumnCount(80);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().extractionConditionName), new Node[]{this.nameTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.groupTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(80);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.topPane.setPrefHeight(60.0);
        this.setTop((Node)this.topPane);
        this.centerPane.setCenter((Node)this.tabPane);
        this.setCenter((Node)this.centerPane);
        this.buildSqlButton = new FxButton(XdtsWords.getInstance().buildSql.toPlain());
        this.buildSqlButton.setOnAction(this.actionEventHandler);
        this.buildSqlButton.setGraphic((Node)FxImageHelper.createImageView_icon("sql_48x48.png"));
        this.addControlNode((Node)this.buildSqlButton);
        this.completionButton = FxUtil.createCompletionButton();
        this.completionButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.completionButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.cancelButton);
        FxUtil.defaultInitialize((Node)this);
    }

    public void conditionEdit1_L3(SqlContext sqlContext, XdtsExtractionCondition extractionCondition) throws Exception {
        this.sqlContext = sqlContext;
        this.extractionCondition = extractionCondition;
        XdtsUserSetting userSetting = new XdtsUserSetting();
        this.fxConditionBase = this.conditionModelToFx.createFxCondition(extractionCondition, userSetting, true);
        this.repaint();
    }

    public void repaint() throws Exception {
        this.nameTextField.setText(this.extractionCondition.name);
        this.groupTextField.setText(this.extractionCondition.group);
        this.noteTextField.setText(this.extractionCondition.note);
        this.tabPane.getTabs().clear();
        int i = 0;
        while (i < this.extractionCondition.selectList.size()) {
            XdtsSelect selectContext = this.extractionCondition.selectList.get(i);
            Tab tab = new Tab();
            tab.setClosable(false);
            if (selectContext.id == 0) {
                tab.setText("Main SQL");
            } else {
                tab.setText(XdtsSqlParserUtil.toSubSelectName(selectContext.id));
            }
            this.tabPane.getTabs().add((Object)tab);
            XdtsSelectQueryEditPane selectQueryEditPane = new XdtsSelectQueryEditPane(this);
            selectQueryEditPane.setup(selectContext, this.fxConditionBase);
            tab.setContent((Node)selectQueryEditPane);
            ++i;
        }
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.buildSqlButton) {
            this.createExtractionCondition();
            XdtsQueryCreator queryCreator = new XdtsQueryCreator();
            String query = queryCreator.createSelectQuery(this.sqlContext, this.extractionCondition);
            XdtsProfile profile = XdtsProfileStub.getInstance().getProfile(this.extractionCondition.dataSourceId);
            SqlConstants.DatabaseProduct databaseProduct = SqlConstants.DatabaseProduct.getById(profile.productId);
            XdtsCustomSql customSql = new XdtsCustomSql();
            customSql.sql = query;
            XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
            dataViewPanel.setProfile(profile);
            dataViewPanel.setCustomSql(customSql);
            dataViewPanel.setTitle("SQL : " + profile.name + " [" + databaseProduct.productName + "]");
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.completionButton) {
            this.extractionCondition.name = this.nameTextField.getText();
            this.extractionCondition.group = this.groupTextField.getText();
            this.extractionCondition.note = this.noteTextField.getText();
            XsysValidator validator = XsysValidator.getInstance();
            BcResult result1 = validator.validateForGui(this.extractionCondition);
            if (result1.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().error, 0);
                return;
            }
            XdtsUserSetting userSetting = new XdtsUserSetting();
            XdtsFxToConditionModel fxToConditionModel = new XdtsFxToConditionModel();
            fxToConditionModel.storeData(this.sqlContext, this.extractionCondition, this.fxConditionBase, userSetting);
            XdtsExtractionCondition extractionCondition2 = XdtsExtractionConditionStub.getInstance().put(this.extractionCondition);
            BcEventManager.getInstance().getEventHandlerList(XdtsExtractionCondition.class).fireEvent(new BcEvent(this.extractionCondition));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected void createExtractionCondition() throws Exception {
        this.extractionCondition.name = this.nameTextField.getText();
        this.extractionCondition.group = this.groupTextField.getText();
        this.extractionCondition.note = this.noteTextField.getText();
        XsysValidator validator = XsysValidator.getInstance();
        BcResult result1 = validator.validateForGui(this.extractionCondition);
        if (result1.hasError()) {
            String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
            FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().error, 0);
            return;
        }
        XdtsUserSetting userSetting = new XdtsUserSetting();
        XdtsFxToConditionModel fxToConditionModel = new XdtsFxToConditionModel();
        fxToConditionModel.storeData(this.sqlContext, this.extractionCondition, this.fxConditionBase, userSetting);
    }

    protected void close() {
        this.stage.close();
    }

    public void show() throws Exception {
        if (this.stage != null) {
            this.stage.show();
            this.stage.toFront();
            return;
        }
        this.stage = new FxStage();
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsExtractionConditionEditPane.this.close();
                }
                catch (Exception ex) {
                    XdtsExtractionConditionEditPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(true);
        FxUtil.setWindowCenter((Window)this.stage, 0.8);
        this.stage.setTitle(XdtsWords.getInstance().createExtractionConditions);
        this.stage.getIcons().add((Object)FxImageHelper.getImage("form_64x64.png"));
        this.stage.show();
    }
}

