/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.layout.Region;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventHandlerList;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.etc.model.EtcQueryCondition;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxComboBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.mmdx.fx.MmdxSqlTypeChoiceBox;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsAndOrPane;
import jp.co.extreme.module.xdts.fx.XdtsOptionSelectionPane;
import jp.co.extreme.module.xdts.fx.XdtsPatternMatchPane;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.sql.SqlWords;

public class XdtsControlOptionPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField tableColumnNameField = new FxTextField();
    MmdxSqlTypeChoiceBox sqlTypeChoiceBox = new MmdxSqlTypeChoiceBox();
    FxTextField itemNameField = new FxTextField();
    FxComboBox<String> controlTypeComboBox = new InnerComboBox<String>();
    FxNumberField displayOrderField = new FxNumberField(-1, 0, false);
    FxNumberField columnCountField = new FxNumberField(-1, 0, false);
    FxNumberField rowCountField = new FxNumberField(-1, 0, false);
    XdtsAndOrPane andOrPane = new XdtsAndOrPane();
    XdtsPatternMatchPane patternMatchPane = new XdtsPatternMatchPane();
    FxTextArea optionsTextArea = new FxTextArea();
    FxTextField defaultValueField = new FxTextField();
    FxTextArea descriptionTextArea = new FxTextArea();
    XdtsProfile profile;
    XdtsControlContext controlContext;
    int rowLimit = 20;
    FxButton completionButton;
    FxButton cancelButton;
    boolean isCompleted;
    BcEventHandlerList closeHandlerList = new BcEventHandlerList();
    FxTabPane tabPane1 = new FxTabPane();
    XdtsOptionSelectionPane optionSelectionPane1;
    XdtsOptionSelectionPane optionSelectionPane2;

    public XdtsControlOptionPane(XdtsProfile profile) throws Exception {
        this.profile = profile;
        XdtsConstants.ControlType[] controlTypeArray = XdtsConstants.ControlType.values();
        int n = controlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            XdtsConstants.ControlType \uff43ontrolType = controlTypeArray[n2];
            this.controlTypeComboBox.getItems().add((Object)\uff43ontrolType.name());
            ++n2;
        }
        this.underLineEnabled();
        this.completionButton = FxUtil.createCompletionButton();
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
    }

    protected void setControlContext(XdtsControlContext controlContext) throws Exception {
        this.controlContext = controlContext;
        this.itemNameField.setText(controlContext.displayName);
        this.tableColumnNameField.setText(controlContext.tableColumnName);
        this.sqlTypeChoiceBox.setSqlTypeId(controlContext.sqlTypeId);
        if (controlContext.controlType != null) {
            this.controlTypeComboBox.getSelectionModel().select((Object)controlContext.controlType.name());
        }
        this.columnCountField.setValue(controlContext.columnCount);
        this.rowCountField.setValue(controlContext.rowCount);
        if (controlContext.patternMatch != null) {
            this.patternMatchPane.setPatternMatch(controlContext.patternMatch);
        }
        this.optionsTextArea.setText(controlContext.options);
        this.defaultValueField.setText(controlContext.defaultValue);
        this.descriptionTextArea.setText(controlContext.description);
        this.displayOrderField.setValue(controlContext.displayOrder);
        this.initComponent();
    }

    protected void storeData() throws Exception {
        this.controlContext.tableColumnName = this.tableColumnNameField.getText();
        this.controlContext.sqlTypeId = this.sqlTypeChoiceBox.getSqlTypeId();
        this.controlContext.isAnd = this.andOrPane.isAnd();
        this.controlContext.displayName = this.itemNameField.getText();
        String controlTypeName = (String)this.controlTypeComboBox.getSelectionModel().getSelectedItem();
        this.controlContext.controlType = BcLangUtil.getEnumByName(XdtsConstants.ControlType.class, controlTypeName);
        if (this.columnCountField.getBigDecimal() != null) {
            this.controlContext.columnCount = this.columnCountField.getBigDecimal().intValue();
        }
        if (this.rowCountField.getBigDecimal() != null) {
            this.controlContext.rowCount = this.rowCountField.getBigDecimal().intValue();
        }
        this.controlContext.patternMatch = this.patternMatchPane.getPatternMatch();
        this.controlContext.options = this.optionsTextArea.getText();
        this.controlContext.defaultValue = this.defaultValueField.getText();
        this.controlContext.description = this.descriptionTextArea.getText();
        this.controlContext.displayOrder = this.displayOrderField.getBigDecimal().intValue();
    }

    protected void initComponent() throws Exception {
        this.centerPane.removeAll();
        this.itemNameField.setPrefColumnCount(80);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().itemName.toPlain()), new Node[]{this.itemNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        if (this.controlContext.contextType == XdtsConstants.ContextType.General) {
            this.tableColumnNameField.setPrefColumnCount(80);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().tableName_columnName), new Node[]{this.tableColumnNameField});
            this.centerPane.addNodeUnit(nodeUnit);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().sqlType.toPlain()), new Node[]{this.sqlTypeChoiceBox});
            this.centerPane.addNodeUnit(nodeUnit);
            if (XdtsSqlParserUtil.isTextType(this.controlContext.sqlTypeId) || XdtsSqlParserUtil.isNumberType(this.controlContext.sqlTypeId)) {
                nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().controlType.toPlain()), new Node[]{this.controlTypeComboBox});
                this.centerPane.addNodeUnit(nodeUnit);
                this.columnCountField.setPrefColumnCount(4);
                nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().numberOfColumns.toPlain()), new Node[]{this.columnCountField});
                this.centerPane.addNodeUnit(nodeUnit);
                this.rowCountField.setPrefColumnCount(4);
                nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().numberOfRows.toPlain()), new Node[]{this.rowCountField});
                this.centerPane.addNodeUnit(nodeUnit);
            }
            if (XdtsSqlParserUtil.isTextType(this.controlContext.sqlTypeId)) {
                FxUtil.setFixedSize((Region)this.patternMatchPane, 400.0, 28.0);
                nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().matchMethod.toPlain()), new Node[]{this.patternMatchPane});
                this.centerPane.addNodeUnit(nodeUnit);
            }
        }
        if (this.controlContext.contextType == XdtsConstants.ContextType.General || this.controlContext.contextType == XdtsConstants.ContextType.RowLimit || this.controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
            this.optionsTextArea.setPrefColumnCount(80);
            this.optionsTextArea.setPrefRowCount(4);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().options), new Node[]{this.optionsTextArea});
            this.centerPane.addNodeUnit(nodeUnit);
            this.defaultValueField.setPrefColumnCount(80);
            nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().defaltValue.toPlain()), new Node[]{this.defaultValueField});
            this.centerPane.addNodeUnit(nodeUnit);
        }
        this.descriptionTextArea.setPrefColumnCount(80);
        this.descriptionTextArea.setPrefRowCount(2);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().explanation), new Node[]{this.descriptionTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        this.displayOrderField.setPrefColumnCount(5);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().displayOrder.toPlain()), new Node[]{this.displayOrderField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData();
            this.isCompleted = true;
            this.closeHandlerList.fireEvent(new BcEvent((Object)this));
        } else if (ev.getSource() == this.cancelButton) {
            this.closeHandlerList.fireEvent(new BcEvent((Object)this));
        }
    }

    public void func1() throws Exception {
        EtcQueryCondition queryCondition = new EtcQueryCondition();
        queryCondition.datasourceName = this.profile.name;
        queryCondition.columNameList = new ArrayList<String>();
        queryCondition.ascending = false;
        queryCondition.rowLimit = this.rowLimit;
        this.optionSelectionPane1 = new XdtsOptionSelectionPane(queryCondition);
        Tab tab1 = new Tab();
        tab1.setText(String.valueOf(XdtsWords.getInstance().\u51fa\u73fe\u983b\u5ea6\u4e0a\u4f4d) + this.rowLimit + "\u4ef6");
        tab1.setContent((Node)this.optionSelectionPane1);
        tab1.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)tab1);
        queryCondition = new EtcQueryCondition();
        queryCondition.datasourceName = this.profile.name;
        queryCondition.columNameList = new ArrayList<String>();
        queryCondition.ascending = true;
        queryCondition.rowLimit = this.rowLimit;
        this.optionSelectionPane2 = new XdtsOptionSelectionPane(queryCondition);
        tab1 = new Tab();
        tab1.setText(String.valueOf(XdtsWords.getInstance().\u51fa\u73fe\u983b\u5ea6\u4e0b\u4f4d) + this.rowLimit + "\u4ef6");
        tab1.setContent((Node)this.optionSelectionPane2);
        tab1.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)tab1);
        this.setBottom((Node)this.tabPane1);
    }

    public List<Object> getValueList() throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (this.optionSelectionPane1 != null) {
            valueList.addAll(this.optionSelectionPane1.getValueList());
        }
        if (this.optionSelectionPane2 != null) {
            valueList.addAll(this.optionSelectionPane2.getValueList());
        }
        return valueList;
    }

    class InnerComboBox<T>
    extends FxComboBox<T> {
        @Override
        protected void valueChanged(ObservableValue ov, T oldValue, T newValue) {
        }
    }
}

