/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.lib.html.lightbox.LightboxCreator;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.common.WbsUploadContext;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.WbsFileUploadFormCreator;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xsod.common.EtcImageCash;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.module.xweb.web.XwebMainServlet;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class X_Wbs1ImageListWCB
extends Wbs1AbstractWCB {
    private Map<Comparable, XfilUriEntity> uriEntityMap = new HashMap<Comparable, XfilUriEntity>();
    protected EtcImageCash imageCash = new EtcImageCash();
    private File dir;

    @Override
    protected StringBuilder createBodyScript(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = super.createBodyScript(wcbArg);
        return sb;
    }

    public void imageList(WbsArgument wcbArg) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String imageId = requestParameter.getAsString(Parm.imageId.name());
        String thumbnailId = requestParameter.getAsString(Parm.thumbnailId.name());
        if (!BcStringUtil.isEmpty(imageId)) {
            this.getImage(wcbArg, imageId);
            return;
        }
        if (!BcStringUtil.isEmpty(thumbnailId)) {
            this.getThumbnail(wcbArg, thumbnailId);
            return;
        }
        if (!BcCollectionUtil.isEmpty(requestParameter.uploadContextList)) {
            BcLogUtil.debug("uploadContextList.size()=" + requestParameter.uploadContextList.size());
            int i = 0;
            while (i < requestParameter.uploadContextList.size()) {
                WbsUploadContext uploadContext = requestParameter.uploadContextList.get(i);
                File newFime = new File(this.getDir(), uploadContext.fileName);
                uploadContext.tempFile.renameTo(newFime);
                ++i;
            }
        }
        StringBuilder content = this.createContent(wcbArg);
        StringBuilder sb = this.getBaseHtml(wcbArg);
        sb = this.replace(wcbArg, "\u753b\u50cf", null, sb);
        sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
        WbfwUtil.outputHtml(wcbArg, sb.toString());
    }

    protected StringBuilder createContent(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createImageList(wcbArg));
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        StringBuilder sb2 = new StringBuilder();
        sb2.append("\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9");
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), XwebMainServlet.ImageMenu.gomatachi);
        WbsFileUploadFormCreator uploadFormCreator = new WbsFileUploadFormCreator();
        sb2.append(uploadFormCreator.createForm("form1", href));
        sb2 = MdlCreator.getInstance().grid_portfolio(sb2, true);
        sb.append((CharSequence)sb2);
        return sb;
    }

    protected StringBuilder createImageList(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        Collection<XfilUriEntity> uriEntityCollection = this.getUriEntityCollection(wcbArg);
        BcLogUtil.debug("uriEntityCollection.size()=" + uriEntityCollection.size());
        for (XfilUriEntity uriEntity : uriEntityCollection) {
            String imageId = this.getImageId(uriEntity);
            this.uriEntityMap.put((Comparable)((Object)imageId), uriEntity);
            StringBuilder tableCell = this.createTableCell(wcbArg, uriEntity);
            sb.append((CharSequence)tableCell);
        }
        sb.append(this.getHtmlBuilder().lineSep);
        return sb;
    }

    protected StringBuilder createTableCell(WbsArgument wcbArg, XfilUriEntity uriEntity) throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilder media = new StringBuilder();
        String methodName = BcFileUtil.deleteTopSlash(wcbArg.getRequest().getServletPath());
        String imageId = this.getImageId(uriEntity);
        String href1 = this.createImageUrl(wcbArg, uriEntity);
        String href2 = this.createThumbnailUrl(wcbArg, uriEntity);
        media.append((CharSequence)LightboxCreator.getInstance().popupImage(this.getHtmlBuilder(), href1, href2, null, uriEntity.name));
        sb.append((CharSequence)MdlCreator.getInstance().card_media(media));
        sb.append((CharSequence)MdlCreator.getInstance().card_title(uriEntity.name));
        sb = MdlCreator.getInstance().grid_cell_shadow(4, sb);
        return sb;
    }

    public Collection<XfilUriEntity> getUriEntityCollection(WbsArgument wcbArg) throws Exception {
        ArrayList<XfilUriEntity> uriEntityList = null;
        uriEntityList = new ArrayList<XfilUriEntity>();
        File imageDir = this.getDir();
        File[] files = imageDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            BcLogUtil.debug("file=" + file.getPath());
            if (file.isFile()) {
                XfilUriEntity uriEntity = XfilUtil.toUriEntity(file.toPath(), true);
                uriEntity.id = i + 1;
                uriEntityList.add(uriEntity);
            }
            ++i;
        }
        return uriEntityList;
    }

    protected String createImageUrl(WbsArgument wcbArg, XfilUriEntity uriEntity) throws Exception {
        String methodName = BcFileUtil.deleteTopSlash(wcbArg.getRequest().getServletPath());
        String imageId = this.getImageId(uriEntity);
        return String.valueOf(methodName) + "?" + (Object)((Object)Parm.imageId) + "=" + imageId;
    }

    protected String createThumbnailUrl(WbsArgument wcbArg, XfilUriEntity uriEntity) throws Exception {
        String methodName = BcFileUtil.deleteTopSlash(wcbArg.getRequest().getServletPath());
        String imageId = this.getImageId(uriEntity);
        return String.valueOf(methodName) + "?" + (Object)((Object)Parm.thumbnailId) + "=" + imageId;
    }

    public String getImageId(XfilUriEntity uriEntity) throws Exception {
        return uriEntity.name;
    }

    public void getImage(WbsArgument wcbArg, String imageId) throws Exception {
        XfilUriEntity uriEntity = this.uriEntityMap.get(imageId);
        BufferedImage bufferedImage = this.getImage(wcbArg, uriEntity);
        if (bufferedImage != null) {
            ServletOutputStream os = wcbArg.getResponse().getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, uriEntity.extention, (OutputStream)os);
        }
    }

    protected BufferedImage getImage(WbsArgument wcbArg, XfilUriEntity uriEntity) throws Exception {
        String imageId = this.getImageId(uriEntity);
        File file = XfilUtil.toFile(uriEntity);
        BufferedImage bufferedImage = this.imageCash.getImage((Comparable)((Object)imageId), file);
        return bufferedImage;
    }

    public void getThumbnail(WbsArgument wcbArg, String imageId) throws Exception {
        XfilUriEntity uriEntity = this.uriEntityMap.get(imageId);
        BufferedImage bufferedImage = this.getThumbnail(wcbArg, uriEntity);
        ServletOutputStream os = wcbArg.getResponse().getOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, uriEntity.extention, (OutputStream)os);
    }

    protected BufferedImage getThumbnail(WbsArgument wcbArg, XfilUriEntity uriEntity) throws Exception {
        String imageId = this.getImageId(uriEntity);
        File file = XfilUtil.toFile(uriEntity);
        BufferedImage bufferedImage = this.imageCash.getThumbnail((Comparable)((Object)imageId), file);
        return bufferedImage;
    }

    public void setDir(File dir) throws Exception {
        this.dir = dir;
    }

    public File getDir() throws Exception {
        return this.dir;
    }

    public static enum Method implements WbxPath
    {
        imageList(null);

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return X_Wbs1ImageListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum Parm {
        imageId,
        thumbnailId;

    }
}

