/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.dao.Wbs1AnswerDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1QuestionDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Answer;
import jp.co.extreme.module.wbs1.model.Wbs1Judgement;
import jp.co.extreme.module.wbs1.model.Wbs1Question;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractDashboardWCB;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebFileContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import jp.co.extreme.web.server.WbsUrlParameterMap;
import jp.co.extreme.web.upload.WebDndUtil;
import jp.co.extreme.web.upload.WebImagePreviewUtil;

public class Wbs1SurveyWCB
extends Wbs1AbstractDashboardWCB {
    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        List<Wbs1Question> questionList = null;
        HashMap<Short, Wbs1Question> questionMap = null;
        if (tokenContext.validationResult == null) {
            Wbs1Question question;
            int i;
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            WbsTempCondition tmpCondition = new WbsTempCondition();
            questionList = Wbs1QuestionDAO.getInstance().getList(dtsSessionSite, 9991L);
            if (BcCollectionUtil.isEmpty(questionList)) {
                i = 0;
                while (i < 5) {
                    question = new Wbs1Question();
                    question.number = (short)(i + 1);
                    questionList.add(question);
                    ++i;
                }
            }
            questionMap = new HashMap<Short, Wbs1Question>();
            i = 0;
            while (i < questionList.size()) {
                question = (Wbs1Question)questionList.get(i);
                questionMap.put(question.number, question);
                ++i;
            }
            XwebUtil.putToMap(tokenContext.map, questionMap);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            questionMap = (HashMap<Short, Wbs1Question>)XwebUtil.getMapValue(tokenContext.map, Map.class);
        }
        BcLogUtil.debug("### mode=" + urlParam.mode);
        WbxFormData formData = new WbxFormData();
        StringBuilder title = new StringBuilder();
        formData.title = String.valueOf(XsysWords.getInstance().\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb) + ":" + urlParam.mode;
        StringBuilder fileds = new StringBuilder();
        fileds.append(this.detail(wcbArg, dtsSessionSite, questionList));
        fileds.append(this.getHtmlBuilder().hidden(WbxConstants.SessionAttributeKey.submitMode.name(), null));
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.submit);
        String onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), Wbs1Constants.JudgementStatus.NULL.id);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().save, onclickAction));
        controls.append(this.getHtmlBuilder().br());
        controls.append(this.getHtmlBuilder().br());
        if (Wbs1Constants.OperationMode.userProfile.name().equals(urlParam.mode)) {
            onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), Wbs1Constants.JudgementStatus.application.id);
            controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().application, onclickAction));
            controls.append(this.getHtmlBuilder().br());
            controls.append(this.getHtmlBuilder().br());
        }
        onclickAction = XwebUtil.onclickActionToBack(wcbArg);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().cancel, onclickAction));
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        StringBuilder sb = new StringBuilder();
        WbxFormBuilder formBaseBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        sb.append(formBaseBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        ArrayList<String> bodyScriptList = new ArrayList<String>();
        bodyScriptList.add(WebImagePreviewUtil.getScript1());
        int i = 0;
        while (i < 1) {
            String fileIdSuffix = Integer.toString(i + 1);
            bodyScriptList.add(WebDndUtil.getScript(String.valueOf(WebDndUtil.dndAreaIdPrefix) + fileIdSuffix, String.valueOf(WebDndUtil.inputFileId) + fileIdSuffix, String.valueOf(WebImagePreviewUtil.canvasId) + fileIdSuffix, String.valueOf(WebImagePreviewUtil.canvasParentId) + fileIdSuffix));
            ++i;
        }
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.getTitle(), null, html, null, bodyScriptList);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    protected String detail(WbsArgument wcbArg, DtsSession dtsSessionSite, List<Wbs1Question> questionList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < questionList.size()) {
            Wbs1Question question = questionList.get(i);
            sb.append(this.detail_L2(wcbArg, dtsSessionSite, question));
            ++i;
        }
        return sb.toString();
    }

    protected String detail_L2(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Question question) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_04rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table.className));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_table_cell.className);
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.width("6rem").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.getHtmlBuilder().p(question.number, true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table_cell.className));
        globalAttribute = new HtmlGlobalAttribute();
        sb.append(this.getHtmlBuilder().textArea(globalAttribute, "name", question.name, 50, 4));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        globalAttribute = new HtmlGlobalAttribute();
        sb.append(this.getHtmlBuilder().textArea(globalAttribute, "option", question.option, 50, 4));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    public void submit(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.submit_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void submit_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        BcLogUtil.debug("### requestParameter.map=" + requestParameter.map);
        Wbs1Answer answer = new Wbs1Answer();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, answer);
        Wbs1Judgement judgement = new Wbs1Judgement();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgement);
        XsysValidator validator = XsysValidator.getInstance();
        tokenContext.validationResult = validator.validate(answer);
        List<XwebFileContext> fileContextList = XwebUtil.createFileContextList(wcbArg, dtsSessionSite, this.getLogger());
        int i = 0;
        while (i < fileContextList.size()) {
            XwebFileContext fileContext = fileContextList.get(i);
            String fileSuffix = XwebUtil.getSuffix(fileContext.uploadContext.fieldName, Wbs1Answer.FieldName.fileIds.name());
            int arrayIndex = Integer.parseInt(fileSuffix) - 1;
            answer.fileIds[arrayIndex] = fileContext.fileResource.id;
            ++i;
        }
        int submitMode = BcNumberUtil.parseInt(requestParameter.map.getAsString(WbxConstants.SessionAttributeKey.submitMode), Wbs1Constants.JudgementStatus.NULL.id);
        this.getLogger().debug("### submitMode=" + submitMode);
        if (submitMode == Wbs1Constants.JudgementStatus.application.id) {
            answer.setJudgementDatetime(null);
            answer.setJudgementStatusId(Wbs1Constants.JudgementStatus.application.id);
            answer.setJudgementReason(null);
        } else {
            XwebJudgementUtil.judgementSet(judgement, answer);
        }
        if (tokenContext.validationResult.hasError()) {
            XwebUtil.putToMap(tokenContext.map, answer);
            XwebUtil.inputErrorPreprocessing(tokenContext, requestParameter, tokenContext.validationResult);
            this.form(wcbArg);
            return;
        }
        Wbs1AnswerDAO.getInstance().putEntity(dtsSessionSite, answer);
        dtsSessionSite.commit();
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        personManager.crear(answer.personId);
        XwebUtil.redirectPreUrl(wcbArg);
    }

    public static enum Method implements WbxPath
    {
        form("survey"),
        submit("survey-submit");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1SurveyWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum ProfileInputType {
        textField,
        textArea,
        select,
        checkBox;

    }
}

