/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.dao.XsodCategoryDAO;
import jp.co.extreme.module.xsod.dao.XsodMerchandiseDAO;
import jp.co.extreme.module.xsod.model.XsodCategory;
import jp.co.extreme.module.xsod.model.XsodCondition;
import jp.co.extreme.module.xsod.model.XsodMerchandise;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlDlCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class Wbs1MarchandiseMenuWCB
extends Wbs1AbstractWCB {
    HtmlDlCreator dlCreator = new HtmlDlCreator();

    @Override
    protected List<String> getHeadElementList(WbsArgument wcbArg) throws Exception {
        List<String> list = super.getHeadElementList(wcbArg);
        return list;
    }

    public void marchandiseMenu(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            StringBuilder html = this.marchandiseMenu_L2(wcbArg, dtsSession);
            WbfwUtil.outputHtml(wcbArg, html.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected StringBuilder marchandiseMenu_L2(WbsArgument wcbArg, DtsSession dtsSession) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        XsodCondition xsodCondition = new XsodCondition();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, xsodCondition);
        BcLogUtil.debug("xsodCondition.marchandiseCategoryCode=" + xsodCondition.marchandiseCategoryCode);
        StringBuilder sb = new StringBuilder();
        StringBuilder list = this.createCategory(dtsSession, xsodCondition);
        list = MdlCreator.getInstance().grid_portfolio(list, true);
        sb.append((CharSequence)list);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, "\u30e1\u30cb\u30e5\u30fc", null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        return html;
    }

    protected StringBuilder createCategory(DtsSession dtsSession, XsodCondition xsodCondition) throws Exception {
        int setId = 1;
        List<XsodCategory> categoryList1 = XsodCategoryDAO.getInstance().getList(dtsSession, setId, null);
        LinkedHashMap<String, XsodCategory> map1 = new LinkedHashMap<String, XsodCategory>();
        ArrayList<String> merchandiseCodeList1 = new ArrayList<String>();
        for (XsodCategory category : categoryList1) {
            List<String> merchandiseCodeList2 = EtcEnumStrUtil.toValueList(category.merchandiseCodes);
            Iterator iterator = merchandiseCodeList2.iterator();
            while (iterator.hasNext()) {
                String merchandiseCode = (String)iterator.next();
                if (merchandiseCodeList1.contains(merchandiseCode)) continue;
                merchandiseCodeList1.add(merchandiseCode);
            }
            map1.put(category.code, category);
        }
        LinkedHashMap<String, XsodMerchandise> merchandiseMap = new LinkedHashMap<String, XsodMerchandise>();
        for (String merchandiseCode : merchandiseCodeList1) {
            XsodMerchandise merchandise = XsodMerchandiseDAO.getInstance().getByCode(dtsSession, merchandiseCode);
            if (merchandise == null) {
                this.getLogger().warning("\u5546\u54c1\u30b3\u30fc\u30c9 '" + merchandise + "' \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                continue;
            }
            merchandiseMap.put(merchandise.code, merchandise);
        }
        int colmnCount = 2;
        int rowCount = (int)Math.ceil((double)categoryList1.size() / (double)colmnCount);
        this.getLogger().debug("rowCount=" + rowCount);
        int index = -1;
        ArrayList categoryListList = new ArrayList();
        int i = 0;
        while (i < colmnCount) {
            ArrayList<XsodCategory> arrayList = new ArrayList<XsodCategory>();
            int j = 0;
            while (j < rowCount) {
                if (++index < categoryList1.size()) {
                    XsodCategory category = categoryList1.get(index);
                    arrayList.add(category);
                }
                ++j;
            }
            categoryListList.add(arrayList);
            ++i;
        }
        StringBuilder sb1 = new StringBuilder();
        for (List list : categoryListList) {
            StringBuilder sb2 = new StringBuilder();
            for (XsodCategory category : list) {
                sb2.append((CharSequence)this.createBox1(category, merchandiseMap));
            }
            sb1.append((CharSequence)MdlCreator.getInstance().grid_cell(6, sb2));
        }
        return sb1;
    }

    protected StringBuilder createBox1(XsodCategory category, Map<String, XsodMerchandise> merchandiseMap) throws Exception {
        String langCode = this.getLangCode();
        String categoryName = XsodUtil.getName(category, langCode, true);
        List<String> merchandiseCodeList = EtcEnumStrUtil.toValueList(category.merchandiseCodes);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().div_start("merchandiseMenuBox"));
        sb.append(this.getHtmlBuilder().div_start("merchandiseMenuSubTitleBox"));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        sb.append(this.getHtmlBuilder().tagStart(HtmlConstants.HtmlTag.h5, globalAttribute, false));
        sb.append(categoryName);
        sb.append(this.getHtmlBuilder().tagEnd(HtmlConstants.HtmlTag.h5, true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = ExtwCssUtil.ExtwClass.extw_row.className;
        globalAttribute.style = "padding: 0 2rem 0 0";
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_width_1rem.className, false));
        sb.append(this.getHtmlBuilder().div_end());
        List<String> merchandiseCodeList2 = EtcEnumStrUtil.toValueList(category.merchandiseCodes);
        sb.append((CharSequence)this.createBox2(merchandiseMap, merchandiseCodeList2));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    protected StringBuilder createBox2(Map<String, XsodMerchandise> merchandiseMap, List<String> merchandiseCodeList) throws Exception {
        String langCode = this.getLangCode();
        StringBuilder sb = new StringBuilder();
        ArrayList<BcPair<String, String>> pairList = new ArrayList<BcPair<String, String>>();
        for (String merchandiseCode : merchandiseCodeList) {
            XsodMerchandise merchandise = merchandiseMap.get(merchandiseCode);
            if (merchandise == null) continue;
            String merchandiseName = XsodUtil.getName(merchandise, langCode, true);
            BcPair<String, String> pair = new BcPair<String, String>(merchandiseName, String.valueOf(BcNumberUtil.toString(merchandise.unitAmount)) + " yen");
            pairList.add(pair);
        }
        this.dlCreator.dlClass = "menu";
        sb.append((CharSequence)this.dlCreator.create(pairList));
        return sb;
    }

    public static enum Method implements WbxPath
    {
        marchandiseMenu("marchandiseMenu");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1MarchandiseMenuWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

