/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.html;

import java.awt.Color;
import java.awt.Font;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.math.BcMath;
import jp.co.extreme.base.mmd.MmdCellAttribute;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.sql.ScfMmdServerUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.html.WbfwHttpTableHandleResource;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf.common.ScfHandleImpl;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.swing.SwgTableViewUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class WbfwHtmlTableCreator {
    protected HtmlBuilder htmlBuilder = new HtmlBuilder();
    protected ScfHandle handle;
    protected WbfwHttpTableHandleResource httpTableHandleResource;
    public boolean theadEnabled;
    public boolean tbodyEnabled;
    public boolean navigationEnabled;
    public String tableCssClass;
    public String thCssClass;
    public String trOddCssClass;
    public String trEvenCssClass;
    public String tdCssClass;
    public Font font;
    public String elementId;
    public String formName;
    public CharSequence urlBase;
    public List<String> sortList;
    public int[] rowCounts = new int[]{20, 50, 100, 200, 400};
    protected StringBuilder mainBuf;

    public WbfwHtmlTableCreator() {
        this.init();
    }

    protected void init() {
        this.theadEnabled = true;
        this.tbodyEnabled = true;
        this.tableCssClass = "table01";
        this.thCssClass = "table01Th";
        this.trOddCssClass = "table01TrEven";
        this.trEvenCssClass = "table01TrOdd";
        this.tdCssClass = "table01Td";
        this.font = new Font("Serif", 0, 8);
        this.initBuffer();
    }

    protected void initBuffer() {
        this.mainBuf = new StringBuilder();
    }

    protected void addData(CharSequence data) {
        if (BcStringUtil.isEmpty(data)) {
            return;
        }
        this.mainBuf.append(data);
    }

    protected StringBuilder tableStart() throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = this.elementId;
        globalAttribute.clazz = this.tableCssClass;
        sb.append(this.htmlBuilder.table_start(globalAttribute, null, null, 0, 0, 0, null));
        return sb;
    }

    protected StringBuilder tableHeader(WbsArgument wcbArg, List<BcTableColumn> tableColumnList) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (this.theadEnabled) {
            sb.append(this.htmlBuilder.thead_start());
        }
        sb.append(this.htmlBuilder.tr_start());
        sb.append(this.htmlBuilder.appLineSep());
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            MmdField mmdField = tableColumn.getMmdField();
            StringBuilder headerCell = this.createHeaderCell(wcbArg, mmdField, tableColumn);
            sb.append((CharSequence)headerCell);
            sb.append(this.htmlBuilder.appLineSep());
            ++i;
        }
        sb.append(this.htmlBuilder.tr_end());
        if (this.theadEnabled) {
            sb.append(this.htmlBuilder.thead_end());
        }
        sb.append(this.htmlBuilder.appLineSep());
        return sb;
    }

    protected StringBuilder createHeaderCell(WbsArgument wcbArg, MmdField mmdField, BcTableColumn tableColumn) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createHeaderCellStartTag(tableColumn));
        sb.append((CharSequence)this.getHeaderCellValue(wcbArg, mmdField, tableColumn));
        sb.append((CharSequence)this.createHeaderCellEndTag());
        return sb;
    }

    protected StringBuilder createHeaderCell(CharSequence value) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createHeaderCellStartTag(null));
        if (!BcStringUtil.isEmpty(value)) {
            sb.append(value);
        }
        sb.append((CharSequence)this.createHeaderCellEndTag());
        return sb;
    }

    protected StringBuilder createHeaderCellStartTag(BcTableColumn tableColumn) throws Exception {
        String style = null;
        if (tableColumn != null) {
            style = "width:" + this.getHeaderCellWidth(tableColumn) + "px;";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.th(-1, -1, -1, -1, this.thCssClass, style));
        return sb;
    }

    protected StringBuilder createHeaderCellEndTag() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.th_end());
        return sb;
    }

    protected StringBuilder getHeaderCellValue(WbsArgument wcbArg, MmdField mmdField, BcTableColumn tableColumn) throws Exception {
        StringBuilder sb = new StringBuilder();
        String valueStr = (String)BcObjectConvertor.getInstance().convert(tableColumn.getHeaderValue(), String.class, mmdField.fieldDisplay.formatStr, Locale.getDefault());
        sb.append(valueStr);
        return sb;
    }

    public String getHeaderCellWidth(BcTableColumn tableColumn) throws Exception {
        double widthPx = SwgTableViewUtil.calcColumnWidth(tableColumn, this.font);
        return Integer.toString((int)widthPx);
    }

    protected StringBuilder footer(WbsArgument wcbArg) throws Exception {
        return null;
    }

    protected StringBuilder rowStartTag(WbsArgument wcbArg, List tableColumnList, List valueList, int rowId) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tableHandleId = requestParameter.getAsString("tableHandleId");
        ScfHandleImpl handle = (ScfHandleImpl)ScfServerContainer.getInstance().getHandleManager().getHandle(tableHandleId);
        boolean isSelected = false;
        if (handle != null) {
            WbfwHttpTableHandleResource httpTableHandleResource = (WbfwHttpTableHandleResource)handle.getHandleResource(0);
            isSelected = httpTableHandleResource.getListSelectionModel().isSelectedIndex(rowId);
        }
        StringBuilder sb = new StringBuilder();
        String cssClass = null;
        cssClass = BcMath.isEven(rowId + 1) ? this.trEvenCssClass : this.trOddCssClass;
        sb.append(this.htmlBuilder.tr_start(cssClass));
        return sb;
    }

    protected StringBuilder rowEndTag() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.tr_end());
        return sb;
    }

    protected StringBuilder createRow(WbsArgument wcbArg, List<BcTableColumn> tableColumnList, int rowId, List<Object> valueList) throws Exception {
        this.createRowPreTrans(wcbArg, tableColumnList, rowId, valueList);
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.rowStartTag(wcbArg, tableColumnList, valueList, rowId));
        int i = 0;
        while (i < tableColumnList.size()) {
            Object value;
            BcTableColumn tableColumn = tableColumnList.get(i);
            MmdField mmdField = tableColumn.getMmdField();
            StringBuilder cell = this.createCell(wcbArg, mmdField, tableColumn, value = valueList.get(i), rowId);
            if (!BcStringUtil.isEmpty(cell)) {
                sb.append((CharSequence)cell);
            }
            ++i;
        }
        sb.append((CharSequence)this.rowEndTag());
        return sb;
    }

    protected void createRowPreTrans(WbsArgument wcbArg, List<BcTableColumn> tableColumnList, int rowId, List<Object> valueList) throws Exception {
        int i = 0;
        while (i < tableColumnList.size()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            MmdField mmdField = tableColumn.getMmdField();
            Object value = valueList.get(i);
            this.createRowPreTrans(wcbArg, mmdField, tableColumn, value, rowId);
            ++i;
        }
    }

    protected void createRowPreTrans(WbsArgument wcbArg, MmdField mmdField, BcTableColumn tableColumn, Object value, int rowId) throws Exception {
    }

    protected StringBuilder createCell(WbsArgument wcbArg, MmdField mmdField, BcTableColumn tableColumn, Object value, int rowId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createCellStart(mmdField));
        StringBuilder cellValue = this.createCellValue(wcbArg, mmdField, tableColumn, value, rowId);
        if (cellValue != null) {
            sb.append((CharSequence)cellValue);
        }
        sb.append((CharSequence)this.cellEnd());
        return sb;
    }

    protected StringBuilder createCellStart(MmdField mmdField) throws Exception {
        StringBuilder sb = new StringBuilder();
        int align = this.getAlign(mmdField);
        sb.append(this.htmlBuilder.tableCell(1, 1, align, -1, this.tdCssClass));
        return sb;
    }

    public int getAlign(MmdField mmdField) throws Exception {
        if (mmdField.dataClass.equals(Number.class)) {
            return 4;
        }
        return 2;
    }

    protected StringBuilder cellEnd() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.td_end());
        return sb;
    }

    protected StringBuilder createCellValue(WbsArgument wcbArg, MmdField mmdField, BcTableColumn tableColumn, Object value1, int rowId) throws Exception {
        StringBuilder sb;
        Object value2 = null;
        Class valueClass2 = null;
        if (mmdField.valueMap != null) {
            value2 = mmdField.valueMap.get(value1);
            if (value2 != null) {
                if (MmdCellAttribute.class.isAssignableFrom(value2.getClass())) {
                    MmdCellAttribute cellAttribute = (MmdCellAttribute)value2;
                    value2 = cellAttribute.value;
                    if (cellAttribute.javaClassType != null) {
                        valueClass2 = cellAttribute.javaClassType;
                    }
                    Color cfr_ignored_0 = cellAttribute.background;
                    Color cfr_ignored_1 = cellAttribute.foreground;
                }
            } else {
                value2 = value1;
            }
        } else {
            value2 = value1;
        }
        if (value2 == null) {
            return null;
        }
        if (valueClass2 == null) {
            valueClass2 = value2.getClass();
        }
        if ((sb = this.value_Number(tableColumn, mmdField, valueClass2, value2)) != null) {
            return sb;
        }
        sb = this.value_Calendar(tableColumn, mmdField, valueClass2, value2);
        if (sb != null) {
            return sb;
        }
        sb = this.value_Boolean(tableColumn, mmdField, valueClass2, value2);
        if (sb != null) {
            return sb;
        }
        DtsSession dtsSession = wcbArg.getDtsSession(this);
        String valueStr = (String)BcObjectConvertor.getInstance().convert(value2, String.class, mmdField.fieldDisplay.formatStr, dtsSession.getLocale());
        sb = new StringBuilder();
        sb.append(valueStr);
        return sb;
    }

    protected StringBuilder value_Number(BcTableColumn lbTableColumn, MmdField mmdField, Class valueClass, Object value) throws Exception {
        if (!Number.class.isAssignableFrom(valueClass)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MmdUtil.toSting(value, mmdField));
        return sb;
    }

    protected StringBuilder value_Calendar(BcTableColumn lbTableColumn, MmdField mmdField, Class valueClass, Object value) throws Exception {
        StringBuilder sb = null;
        if (Calendar.class.isAssignableFrom(valueClass) || Date.class.isAssignableFrom(valueClass)) {
            Calendar calendar = null;
            if (Calendar.class.isAssignableFrom(valueClass)) {
                calendar = (Calendar)value;
            } else if (Date.class.isAssignableFrom(valueClass)) {
                calendar = BcTimeUtil.toCalendar((Date)value);
            }
            sb = new StringBuilder();
            sb.append(BcTimeUtil.toString(calendar, mmdField.fieldDisplay.formatStr));
        }
        return sb;
    }

    protected StringBuilder value_Boolean(BcTableColumn lbTableColumn, MmdField mmdField, Class valueClass, Object value) throws Exception {
        StringBuilder sb = null;
        if (Boolean.class.isAssignableFrom(valueClass)) {
            Boolean bool = (Boolean)value;
            sb = new StringBuilder();
            sb.append(bool);
        }
        return sb;
    }

    protected StringBuilder navigationControl(WbsArgument wcbArg, ScfHandle handle, String formName) throws Exception {
        WbfwHttpTableHandleResource httpTableHandleResource = (WbfwHttpTableHandleResource)handle.getHandleResource(0);
        StringBuilder sb = new StringBuilder();
        int pageCellWidth = 80;
        int buttonCellWidth = 60;
        sb.append(this.htmlBuilder.table_start(null, "100%", null));
        sb.append(this.htmlBuilder.tr_start());
        sb.append(this.htmlBuilder.tableCell(1, 1, 200, 0));
        sb.append("\u4ef6\u6570\uff1a" + httpTableHandleResource.rowCount);
        sb.append(this.htmlBuilder.td_end());
        sb.append(this.htmlBuilder.tableCell());
        sb.append("\u30da\u30fc\u30b8\uff1a");
        sb.append(Integer.toString(httpTableHandleResource.pageNo));
        if (httpTableHandleResource.pageCount > 0) {
            sb.append("/" + Integer.toString(httpTableHandleResource.pageCount));
        }
        sb.append(this.htmlBuilder.td_end());
        if (httpTableHandleResource.pageCount > 0) {
            sb.append(this.htmlBuilder.tableCell());
            int i = 0;
            while (i < httpTableHandleResource.pageCount) {
                int pageNo = i + 1;
                if (i > 0) {
                    sb.append(String.valueOf(HtmlConstants.HtmlSpecialCharacter.space.value) + '|' + HtmlConstants.HtmlSpecialCharacter.space.value);
                }
                if (pageNo != httpTableHandleResource.pageNo) {
                    String url = this.urlBase + "&" + "tablePageNo" + "=" + (i + 1) + "&" + "tableDisplayRow" + "=" + httpTableHandleResource.rowCountAtPage;
                    sb.append(this.htmlBuilder.a_start(url, Integer.toString(pageNo), null));
                    sb.append(this.htmlBuilder.a_end());
                } else {
                    sb.append(Integer.toString(pageNo));
                }
                ++i;
            }
            sb.append(this.htmlBuilder.td_end());
        }
        if (this.sortList != null) {
            ArrayList<BcPair<String, String>> optionList = new ArrayList<BcPair<String, String>>();
            int i = 0;
            while (i < this.sortList.size()) {
                String sort = this.sortList.get(i);
                String value = this.urlBase + "&" + "tablePageNo" + "=" + httpTableHandleResource.pageNo + "&" + "tableDisplayRow" + "=" + httpTableHandleResource.rowCountAtPage + "&" + "tableSort" + "=" + sort;
                BcPair<String, String> pair = new BcPair<String, String>(sort, value);
                optionList.add(pair);
                ++i;
            }
            String script = "onChange=\"location.href=value;\"";
            sb.append(this.htmlBuilder.tableCell());
            if (httpTableHandleResource.rowCountAtPage > 0) {
                sb.append("\u8868\u793a\u9806\uff1a");
                sb.append(this.htmlBuilder.select("tableSort", optionList, Integer.toString(httpTableHandleResource.rowCountAtPage), script));
            }
            sb.append(this.htmlBuilder.td_end());
        }
        if (this.rowCounts != null) {
            ArrayList<BcPair<String, String>> optionList = new ArrayList<BcPair<String, String>>();
            String selectedValue = null;
            int i = 0;
            while (i < this.rowCounts.length) {
                String key = Integer.toString(this.rowCounts[i]);
                String value = this.urlBase + "&" + "tablePageNo" + "=" + httpTableHandleResource.pageNo + "&" + "tableDisplayRow" + "=" + this.rowCounts[i];
                BcPair<String, String> pair = new BcPair<String, String>(key, value);
                optionList.add(pair);
                if (this.rowCounts[i] == httpTableHandleResource.rowCountAtPage) {
                    selectedValue = key;
                }
                ++i;
            }
            String script = "onChange=\"location.href=value;\"";
            sb.append(this.htmlBuilder.tableCell());
            if (httpTableHandleResource.rowCountAtPage > 0) {
                sb.append("\u8868\u793a\u4ef6\u6570\uff1a");
                HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
                sb.append(this.htmlBuilder.select(globalAttribute, "tableDisplayRow", optionList, selectedValue, script));
            }
            sb.append(this.htmlBuilder.td_end());
        }
        sb.append(this.htmlBuilder.tr_end());
        sb.append(this.htmlBuilder.table_end());
        return sb;
    }

    public StringBuilder createTable(WbsArgument wcbArg, ScfHandle handle) throws Exception {
        int rowCountAtPage;
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        this.handle = handle;
        this.httpTableHandleResource = (WbfwHttpTableHandleResource)handle.getHandleResource(0);
        this.initBuffer();
        this.httpTableHandleResource.pageNo = BcNumberUtil.parseInt(requestParameter.getAsString("tablePageNo"), -1);
        if (this.httpTableHandleResource.pageNo <= 0) {
            this.httpTableHandleResource.pageNo = 1;
        }
        if ((rowCountAtPage = BcNumberUtil.parseInt(requestParameter.getAsString("tableDisplayRow"), -1)) > 0) {
            this.httpTableHandleResource.rowCountAtPage = rowCountAtPage;
        }
        SqlContext sqlContext = this.httpTableHandleResource.getdtsSession().getSqlContext();
        SqlResultSet rs = this.httpTableHandleResource.getResultSet();
        List<BcTableColumn> tableColumnList = this.httpTableHandleResource.getTableColumnList();
        BcTableModel tableModel = SqlUtil.getAsTable(rs, tableColumnList);
        this.httpTableHandleResource.rowList = tableModel.getRowList();
        this.httpTableHandleResource.rowCount = this.httpTableHandleResource.rowList.size();
        this.httpTableHandleResource.pageCount = WbfwUtil.calcPageCount(this.httpTableHandleResource.rowCount, this.httpTableHandleResource.rowCountAtPage);
        this.addData(this.htmlBuilder.table_start());
        if (this.navigationEnabled) {
            this.addData(this.htmlBuilder.tr_start());
            this.addData(this.htmlBuilder.tableCell());
            this.addData(this.navigationControl(wcbArg, handle, "form1"));
            this.addData(this.htmlBuilder.td_end());
            this.addData(this.htmlBuilder.tr_end());
        }
        this.addData(this.htmlBuilder.tr_start());
        this.addData(this.htmlBuilder.tableCell());
        this.createTable_L2(wcbArg, this.httpTableHandleResource);
        this.addData(this.htmlBuilder.td_end());
        this.addData(this.htmlBuilder.tr_end());
        if (this.navigationEnabled) {
            this.addData(this.htmlBuilder.tr_start());
            this.addData(this.htmlBuilder.tableCell(1, 1, null, null, 2, 1));
            this.addData(this.navigationControl(wcbArg, handle, "form1"));
            this.addData(this.htmlBuilder.td_end());
            this.addData(this.htmlBuilder.tr_end());
        }
        this.addData(this.htmlBuilder.table_end());
        return this.mainBuf;
    }

    protected StringBuilder createTable_L2(WbsArgument wcbArg, WbfwHttpTableHandleResource httpTableHandleResource) throws Exception {
        this.addData(this.tableStart());
        List<BcTableColumn> tableColumnList = httpTableHandleResource.getTableColumnList();
        this.addData(this.tableHeader(wcbArg, tableColumnList));
        StringBuilder footer = this.footer(wcbArg);
        if (!BcStringUtil.isEmpty(footer)) {
            this.addData(footer);
        }
        if (this.tbodyEnabled) {
            this.addData(this.htmlBuilder.tbody_start());
        }
        SqlResultSet rs = httpTableHandleResource.getResultSet();
        int tmpRowCount = -1;
        BcInteger columnIndex = new BcInteger();
        BcLogUtil.debug("httpTableHandleResource.rowCountAtPage=" + httpTableHandleResource.rowCountAtPage);
        while (true) {
            if (httpTableHandleResource.rowCountAtPage > 0 && ++tmpRowCount >= httpTableHandleResource.rowCountAtPage) {
                BcLogUtil.debug("break#1");
                break;
            }
            int rowId = 0;
            rowId = httpTableHandleResource.rowCountAtPage > 0 ? httpTableHandleResource.rowCountAtPage * (httpTableHandleResource.pageNo - 1) + tmpRowCount : tmpRowCount;
            if (rowId >= httpTableHandleResource.rowCount) {
                BcLogUtil.debug("break#2");
                break;
            }
            List<Object> valueList = httpTableHandleResource.rowList.get(rowId);
            if (valueList == null) {
                rs.absolute(rowId + 1);
                valueList = SqlUtil.getValueList((ResultSet)rs, tableColumnList);
                httpTableHandleResource.rowList.set(rowId, valueList);
            }
            StringBuilder row = this.createRow(wcbArg, tableColumnList, rowId, valueList);
            this.addData(row);
        }
        if (this.tbodyEnabled) {
            this.addData(this.htmlBuilder.tbody_end());
        }
        this.addData(this.htmlBuilder.table_end());
        return this.mainBuf;
    }

    public StringBuilder createTable(WbsArgument wcbArg, List<BcTableColumn> tableColumnList, SqlResultSet rs) throws Exception {
        DtsSession dtsSession = wcbArg.getDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        int rowCount = 0;
        this.addData(this.tableStart());
        this.addData(this.tableHeader(wcbArg, tableColumnList));
        BcInteger columnIndex = new BcInteger();
        while (rs.next()) {
            ++rowCount;
            columnIndex.value = 0;
            ArrayList<Object> valueList = new ArrayList<Object>(tableColumnList.size());
            int i = 0;
            while (i < tableColumnList.size()) {
                BcTableColumn tableColumn = tableColumnList.get(i);
                Object value = rs.getObject(columnIndex);
                MmdField mmdField = tableColumn.getMmdField();
                valueList.add(value);
                ++i;
            }
            StringBuilder row = this.createRow(wcbArg, tableColumnList, rowCount - 1, valueList);
            this.addData(row);
        }
        this.addData(this.htmlBuilder.table_end());
        return this.mainBuf;
    }

    public StringBuilder createTable(WbsArgument wcbArg, SqlResultSet rs) throws Exception {
        DtsSession dtsSession = wcbArg.getDtsSession(this);
        List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData(), Locale.getDefault(), null);
        return this.createTable(wcbArg, tableColumnList, rs);
    }

    public StringBuilder createTable(WbsArgument wcbArg, List<BcTableColumn> tableColumnList, BcTableModel tableModel, String tableWidth) throws Exception {
        boolean rowCount = false;
        this.addData(this.tableStart());
        this.addData(this.tableHeader(wcbArg, tableColumnList));
        int i = 0;
        while (i < tableModel.getRowCount()) {
            ArrayList<Object> valueList = new ArrayList<Object>(tableColumnList.size());
            int j = 0;
            while (j < tableColumnList.size()) {
                BcTableColumn tableColumn = tableColumnList.get(j);
                valueList.add(tableModel.getValueAt(i, j));
                ++j;
            }
            StringBuilder row = this.createRow(wcbArg, tableColumnList, i, valueList);
            this.addData(row);
            ++i;
        }
        this.addData(this.htmlBuilder.table_end());
        return this.mainBuf;
    }

    public StringBuilder createHidden(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.hidden("tableHandleId", this.handle.getHandleId()));
        sb.append(this.htmlBuilder.hidden("tableDisplayRow", this.httpTableHandleResource.rowCountAtPage));
        sb.append(this.htmlBuilder.hidden("tablePageNo", "0"));
        return sb;
    }
}

